<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los criterios de búsqueda de disponibilidad de vuelos
 * - nillable: true
 * - type: tns:AirAvailRQ
 * @subpackage Structs
 */
class AirAvailRQ extends AbstractStructBase
{
    /**
     * The DirectFlightsOnly
     * Meta information extracted from the WSDL
     * - documentation: Booleano que indica si buscar solo vuelos directos
     * - minOccurs: 0
     * @var bool
     */
    public $DirectFlightsOnly;
    /**
     * The IncludeLowCost
     * Meta information extracted from the WSDL
     * - documentation: Booleano que indica si incluir vuelos low-cost en el resultado de la búsqueda
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeLowCost;
    /**
     * The Carriers
     * Meta information extracted from the WSDL
     * - documentation: Lista de codigos de aerolineas a buscar (ej. IB,AZ)
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfString_1
     */
    public $Carriers;
    /**
     * The ClassPref
     * Meta information extracted from the WSDL
     * - documentation: Tipo de cabina a buscar: Sin preferencias, Business, Turista Plena, Economica
     * - minOccurs: 0
     * @var string
     */
    public $ClassPref;
    /**
     * The Travelers
     * Meta information extracted from the WSDL
     * - documentation: Lista de tipos pasajeros para los cuales hay que pedir disponibilidad, en un array de objetos <b>AirTravelerInfo</b>
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTravelerInfo
     */
    public $Travelers;
    /**
     * The FlightSegments
     * Meta information extracted from the WSDL
     * - documentation: Segmentos del vuelo, en un array de objetos <b>AirFlightSegmentRQ</b>
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirFlightSegmentRQ
     */
    public $FlightSegments;
    /**
     * The ReleaseOverride
     * Meta information extracted from the WSDL
     * - documentation: Indica si se debe sobrescribir el release configurado de la agencia por el informado en ReleaseDays
     * - minOccurs: 0
     * @var bool
     */
    public $ReleaseOverride;
    /**
     * The ReleaseDays
     * Meta information extracted from the WSDL
     * - documentation: Indica el numero de dias para permitir la emision de los billetes, no se devolveran esquemas de precio donde la fecha limite de emisión sea anterior a la fecha de hoy mas el release enviado
     * - minOccurs: 0
     * @var int
     */
    public $ReleaseDays;
    /**
     * The GetTourOperation
     * Meta information extracted from the WSDL
     * - documentation: Indica si debemos incluir en la respuesta las combinaciones que sean de tipo de tarifa TourOperacion, ya que estas llevan implícita la obligatoriedad de contratar servicios de tierra junto con la reserva de aéreo.
     * - minOccurs: 0
     * @var bool
     */
    public $GetTourOperation;
    /**
     * The IncludeNDC
     * Meta information extracted from the WSDL
     * - documentation: Indica si debemos incluir en la respuesta ofertas NDC. Si no se especifica, no se devolverá contenido NDC
     * - minOccurs: 0
     * @var string
     */
    public $IncludeNDC;
    /**
     * Constructor method for AirAvailRQ
     * @uses AirAvailRQ::setDirectFlightsOnly()
     * @uses AirAvailRQ::setIncludeLowCost()
     * @uses AirAvailRQ::setCarriers()
     * @uses AirAvailRQ::setClassPref()
     * @uses AirAvailRQ::setTravelers()
     * @uses AirAvailRQ::setFlightSegments()
     * @uses AirAvailRQ::setReleaseOverride()
     * @uses AirAvailRQ::setReleaseDays()
     * @uses AirAvailRQ::setGetTourOperation()
     * @uses AirAvailRQ::setIncludeNDC()
     * @param bool $directFlightsOnly
     * @param bool $includeLowCost
     * @param \ArrayType\ArrayOfString_1 $carriers
     * @param string $classPref
     * @param \ArrayType\ArrayOfAirTravelerInfo $travelers
     * @param \ArrayType\ArrayOfAirFlightSegmentRQ $flightSegments
     * @param bool $releaseOverride
     * @param int $releaseDays
     * @param bool $getTourOperation
     * @param string $includeNDC
     */
    public function __construct($directFlightsOnly = null, $includeLowCost = null, \ArrayType\ArrayOfString_1 $carriers = null, $classPref = null, \ArrayType\ArrayOfAirTravelerInfo $travelers = null, \ArrayType\ArrayOfAirFlightSegmentRQ $flightSegments = null, $releaseOverride = null, $releaseDays = null, $getTourOperation = null, $includeNDC = null)
    {
        $this
            ->setDirectFlightsOnly($directFlightsOnly)
            ->setIncludeLowCost($includeLowCost)
            ->setCarriers($carriers)
            ->setClassPref($classPref)
            ->setTravelers($travelers)
            ->setFlightSegments($flightSegments)
            ->setReleaseOverride($releaseOverride)
            ->setReleaseDays($releaseDays)
            ->setGetTourOperation($getTourOperation)
            ->setIncludeNDC($includeNDC);
    }
    /**
     * Get DirectFlightsOnly value
     * @return bool|null
     */
    public function getDirectFlightsOnly()
    {
        return $this->DirectFlightsOnly;
    }
    /**
     * Set DirectFlightsOnly value
     * @param bool $directFlightsOnly
     * @return \StructType\AirAvailRQ
     */
    public function setDirectFlightsOnly($directFlightsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($directFlightsOnly) && !is_bool($directFlightsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directFlightsOnly, true), gettype($directFlightsOnly)), __LINE__);
        }
        $this->DirectFlightsOnly = $directFlightsOnly;
        return $this;
    }
    /**
     * Get IncludeLowCost value
     * @return bool|null
     */
    public function getIncludeLowCost()
    {
        return $this->IncludeLowCost;
    }
    /**
     * Set IncludeLowCost value
     * @param bool $includeLowCost
     * @return \StructType\AirAvailRQ
     */
    public function setIncludeLowCost($includeLowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeLowCost) && !is_bool($includeLowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeLowCost, true), gettype($includeLowCost)), __LINE__);
        }
        $this->IncludeLowCost = $includeLowCost;
        return $this;
    }
    /**
     * Get Carriers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfString_1|null
     */
    public function getCarriers()
    {
        return isset($this->Carriers) ? $this->Carriers : null;
    }
    /**
     * Set Carriers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfString_1 $carriers
     * @return \StructType\AirAvailRQ
     */
    public function setCarriers(\ArrayType\ArrayOfString_1 $carriers = null)
    {
        if (is_null($carriers) || (is_array($carriers) && empty($carriers))) {
            unset($this->Carriers);
        } else {
            $this->Carriers = $carriers;
        }
        return $this;
    }
    /**
     * Get ClassPref value
     * @return string|null
     */
    public function getClassPref()
    {
        return $this->ClassPref;
    }
    /**
     * Set ClassPref value
     * @uses \EnumType\AirAvailClassPreferences::valueIsValid()
     * @uses \EnumType\AirAvailClassPreferences::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classPref
     * @return \StructType\AirAvailRQ
     */
    public function setClassPref($classPref = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirAvailClassPreferences::valueIsValid($classPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirAvailClassPreferences', is_array($classPref) ? implode(', ', $classPref) : var_export($classPref, true), implode(', ', \EnumType\AirAvailClassPreferences::getValidValues())), __LINE__);
        }
        $this->ClassPref = $classPref;
        return $this;
    }
    /**
     * Get Travelers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTravelerInfo|null
     */
    public function getTravelers()
    {
        return isset($this->Travelers) ? $this->Travelers : null;
    }
    /**
     * Set Travelers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTravelerInfo $travelers
     * @return \StructType\AirAvailRQ
     */
    public function setTravelers(\ArrayType\ArrayOfAirTravelerInfo $travelers = null)
    {
        if (is_null($travelers) || (is_array($travelers) && empty($travelers))) {
            unset($this->Travelers);
        } else {
            $this->Travelers = $travelers;
        }
        return $this;
    }
    /**
     * Get FlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirFlightSegmentRQ|null
     */
    public function getFlightSegments()
    {
        return isset($this->FlightSegments) ? $this->FlightSegments : null;
    }
    /**
     * Set FlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirFlightSegmentRQ $flightSegments
     * @return \StructType\AirAvailRQ
     */
    public function setFlightSegments(\ArrayType\ArrayOfAirFlightSegmentRQ $flightSegments = null)
    {
        if (is_null($flightSegments) || (is_array($flightSegments) && empty($flightSegments))) {
            unset($this->FlightSegments);
        } else {
            $this->FlightSegments = $flightSegments;
        }
        return $this;
    }
    /**
     * Get ReleaseOverride value
     * @return bool|null
     */
    public function getReleaseOverride()
    {
        return $this->ReleaseOverride;
    }
    /**
     * Set ReleaseOverride value
     * @param bool $releaseOverride
     * @return \StructType\AirAvailRQ
     */
    public function setReleaseOverride($releaseOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($releaseOverride) && !is_bool($releaseOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($releaseOverride, true), gettype($releaseOverride)), __LINE__);
        }
        $this->ReleaseOverride = $releaseOverride;
        return $this;
    }
    /**
     * Get ReleaseDays value
     * @return int|null
     */
    public function getReleaseDays()
    {
        return $this->ReleaseDays;
    }
    /**
     * Set ReleaseDays value
     * @param int $releaseDays
     * @return \StructType\AirAvailRQ
     */
    public function setReleaseDays($releaseDays = null)
    {
        // validation for constraint: int
        if (!is_null($releaseDays) && !(is_int($releaseDays) || ctype_digit($releaseDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($releaseDays, true), gettype($releaseDays)), __LINE__);
        }
        $this->ReleaseDays = $releaseDays;
        return $this;
    }
    /**
     * Get GetTourOperation value
     * @return bool|null
     */
    public function getGetTourOperation()
    {
        return $this->GetTourOperation;
    }
    /**
     * Set GetTourOperation value
     * @param bool $getTourOperation
     * @return \StructType\AirAvailRQ
     */
    public function setGetTourOperation($getTourOperation = null)
    {
        // validation for constraint: boolean
        if (!is_null($getTourOperation) && !is_bool($getTourOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getTourOperation, true), gettype($getTourOperation)), __LINE__);
        }
        $this->GetTourOperation = $getTourOperation;
        return $this;
    }
    /**
     * Get IncludeNDC value
     * @return string|null
     */
    public function getIncludeNDC()
    {
        return $this->IncludeNDC;
    }
    /**
     * Set IncludeNDC value
     * @uses \EnumType\AirAvailIncludeNDC::valueIsValid()
     * @uses \EnumType\AirAvailIncludeNDC::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeNDC
     * @return \StructType\AirAvailRQ
     */
    public function setIncludeNDC($includeNDC = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirAvailIncludeNDC::valueIsValid($includeNDC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirAvailIncludeNDC', is_array($includeNDC) ? implode(', ', $includeNDC) : var_export($includeNDC, true), implode(', ', \EnumType\AirAvailIncludeNDC::getValidValues())), __LINE__);
        }
        $this->IncludeNDC = $includeNDC;
        return $this;
    }
}
