<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailLowCostBaggagePriceRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con el resultado de la llamada de petición de emisitón de los billetes de una reserva
 * - nillable: true
 * - type: tns:AirAvailLowCostBaggagePriceRS
 * @subpackage Structs
 */
class AirAvailLowCostBaggagePriceRS extends AbstractStructBase
{
    /**
     * The ListAirAvailBaggagePrice
     * Meta information extracted from the WSDL
     * - documentation: Listado de tipo de equipaje disponible para la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirAvailBaggagePrice
     */
    public $ListAirAvailBaggagePrice;
    /**
     * The NumberBaggageAllowed
     * Meta information extracted from the WSDL
     * - documentation: Numero de ancillary
     * - minOccurs: 0
     * @var int
     */
    public $NumberBaggageAllowed;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de realizar la búsqueda
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al metodo invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * Constructor method for AirAvailLowCostBaggagePriceRS
     * @uses AirAvailLowCostBaggagePriceRS::setListAirAvailBaggagePrice()
     * @uses AirAvailLowCostBaggagePriceRS::setNumberBaggageAllowed()
     * @uses AirAvailLowCostBaggagePriceRS::setError()
     * @uses AirAvailLowCostBaggagePriceRS::setRequestID()
     * @param \ArrayType\ArrayOfAirAvailBaggagePrice $listAirAvailBaggagePrice
     * @param int $numberBaggageAllowed
     * @param \StructType\ResponseError $error
     * @param int $requestID
     */
    public function __construct(\ArrayType\ArrayOfAirAvailBaggagePrice $listAirAvailBaggagePrice = null, $numberBaggageAllowed = null, \StructType\ResponseError $error = null, $requestID = null)
    {
        $this
            ->setListAirAvailBaggagePrice($listAirAvailBaggagePrice)
            ->setNumberBaggageAllowed($numberBaggageAllowed)
            ->setError($error)
            ->setRequestID($requestID);
    }
    /**
     * Get ListAirAvailBaggagePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirAvailBaggagePrice|null
     */
    public function getListAirAvailBaggagePrice()
    {
        return isset($this->ListAirAvailBaggagePrice) ? $this->ListAirAvailBaggagePrice : null;
    }
    /**
     * Set ListAirAvailBaggagePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirAvailBaggagePrice $listAirAvailBaggagePrice
     * @return \StructType\AirAvailLowCostBaggagePriceRS
     */
    public function setListAirAvailBaggagePrice(\ArrayType\ArrayOfAirAvailBaggagePrice $listAirAvailBaggagePrice = null)
    {
        if (is_null($listAirAvailBaggagePrice) || (is_array($listAirAvailBaggagePrice) && empty($listAirAvailBaggagePrice))) {
            unset($this->ListAirAvailBaggagePrice);
        } else {
            $this->ListAirAvailBaggagePrice = $listAirAvailBaggagePrice;
        }
        return $this;
    }
    /**
     * Get NumberBaggageAllowed value
     * @return int|null
     */
    public function getNumberBaggageAllowed()
    {
        return $this->NumberBaggageAllowed;
    }
    /**
     * Set NumberBaggageAllowed value
     * @param int $numberBaggageAllowed
     * @return \StructType\AirAvailLowCostBaggagePriceRS
     */
    public function setNumberBaggageAllowed($numberBaggageAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($numberBaggageAllowed) && !(is_int($numberBaggageAllowed) || ctype_digit($numberBaggageAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberBaggageAllowed, true), gettype($numberBaggageAllowed)), __LINE__);
        }
        $this->NumberBaggageAllowed = $numberBaggageAllowed;
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirAvailLowCostBaggagePriceRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirAvailLowCostBaggagePriceRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
}
