<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirTravelerResidentDocumentTypes EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeración con los tipos de documentos de los pasajeros residentes
 * - nillable: true
 * - type: tns:AirTravelerResidentDocumentTypes
 * @subpackage Enumerations
 */
class AirTravelerResidentDocumentTypes extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DN'
     * Meta information extracted from the WSDL
     * - documentation: Residente con documento actualizado
     * @return string 'DN'
     */
    const VALUE_DN = 'DN';
    /**
     * Constant for value 'CR'
     * Meta information extracted from the WSDL
     * - documentation: Adulto residente con DNI no actualizado
     * @return string 'CR'
     */
    const VALUE_CR = 'CR';
    /**
     * Constant for value 'GR'
     * Meta information extracted from the WSDL
     * - documentation: Residentes temporales trabajando para el gobierno (senadores, diputados, etc..)
     * @return string 'GR'
     */
    const VALUE_GR = 'GR';
    /**
     * Constant for value 'TR'
     * Meta information extracted from the WSDL
     * - documentation: Residente Extranjero
     * @return string 'TR'
     */
    const VALUE_TR = 'TR';
    /**
     * Constant for value 'MR'
     * Meta information extracted from the WSDL
     * - documentation: Residente menor de edad sin DNI, pero con Cert. Residencia.
     * @return string 'MR'
     */
    const VALUE_MR = 'MR';
    /**
     * Constant for value 'AM'
     * Meta information extracted from the WSDL
     * - documentation: No definido
     * @return string 'AM'
     */
    const VALUE_AM = 'AM';
    /**
     * Return allowed values
     * @uses self::VALUE_DN
     * @uses self::VALUE_CR
     * @uses self::VALUE_GR
     * @uses self::VALUE_TR
     * @uses self::VALUE_MR
     * @uses self::VALUE_AM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DN,
            self::VALUE_CR,
            self::VALUE_GR,
            self::VALUE_TR,
            self::VALUE_MR,
            self::VALUE_AM,
        );
    }
}
