<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirPaymentForms EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeracion con los tipos de pago de las reservas aereo
 * - nillable: true
 * - type: tns:AirPaymentForms
 * @subpackage Enumerations
 */
class AirPaymentForms extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CYC'
     * Meta information extracted from the WSDL
     * - documentation: Billetes y Fee por Transferencia (La agencia paga mediante transferencia la reserva completa incluido el fee)
     * @return string 'CYC'
     */
    const VALUE_CYC = 'CYC';
    /**
     * Constant for value 'UYU'
     * Meta information extracted from the WSDL
     * - documentation: Billetes y Fee con Tarjeta autorizada (Se cobra tanto la reserva completa como el fee usando como medio de pago la tarjeta autorizada dada de alta en el sistema)
     * @return string 'UYU'
     */
    const VALUE_UYU = 'UYU';
    /**
     * Constant for value 'SAL'
     * Meta information extracted from the WSDL
     * - documentation: Billetes y Fee con Saldo (Pago por Saldo Agencia)
     * @return string 'SAL'
     */
    const VALUE_SAL = 'SAL';
    /**
     * Return allowed values
     * @uses self::VALUE_CYC
     * @uses self::VALUE_UYU
     * @uses self::VALUE_SAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CYC,
            self::VALUE_UYU,
            self::VALUE_SAL,
        );
    }
}
