<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con las informaciones acerca del tipo de pasajero
 * - nillable: true
 * - type: tns:AirTravelerInfo
 * @subpackage Structs
 */
class AirTravelerInfo extends AbstractStructBase
{
    /**
     * The TravelerType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de pasajero (Adulto, Niño, Bebe)
     * - minOccurs: 0
     * @var string
     */
    public $TravelerType;
    /**
     * The IsResident
     * Meta information extracted from the WSDL
     * - documentation: Si el pasajero tiene derecho a algun descuento como residente (Canarias, Baleares, Ceuta y Melilla, etc)
     * - minOccurs: 0
     * @var bool
     */
    public $IsResident;
    /**
     * Constructor method for AirTravelerInfo
     * @uses AirTravelerInfo::setTravelerType()
     * @uses AirTravelerInfo::setIsResident()
     * @param string $travelerType
     * @param bool $isResident
     */
    public function __construct($travelerType = null, $isResident = null)
    {
        $this
            ->setTravelerType($travelerType)
            ->setIsResident($isResident);
    }
    /**
     * Get TravelerType value
     * @return string|null
     */
    public function getTravelerType()
    {
        return $this->TravelerType;
    }
    /**
     * Set TravelerType value
     * @uses \EnumType\AirTravelerTypes::valueIsValid()
     * @uses \EnumType\AirTravelerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelerType
     * @return \StructType\AirTravelerInfo
     */
    public function setTravelerType($travelerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTravelerTypes::valueIsValid($travelerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTravelerTypes', is_array($travelerType) ? implode(', ', $travelerType) : var_export($travelerType, true), implode(', ', \EnumType\AirTravelerTypes::getValidValues())), __LINE__);
        }
        $this->TravelerType = $travelerType;
        return $this;
    }
    /**
     * Get IsResident value
     * @return bool|null
     */
    public function getIsResident()
    {
        return $this->IsResident;
    }
    /**
     * Set IsResident value
     * @param bool $isResident
     * @return \StructType\AirTravelerInfo
     */
    public function setIsResident($isResident = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResident) && !is_bool($isResident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResident, true), gettype($isResident)), __LINE__);
        }
        $this->IsResident = $isResident;
        return $this;
    }
}
