<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTraveler StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos completos de un pasajero
 * - nillable: true
 * - type: tns:AirTraveler
 * @subpackage Structs
 */
class AirTraveler extends AbstractStructBase
{
    /**
     * The TravelerType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de pasajero (Adulto, Niño, Bebe)
     * - minOccurs: 0
     * @var string
     */
    public $TravelerType;
    /**
     * The TravelerTitle
     * Meta information extracted from the WSDL
     * - documentation: Titulo del pasajero (Mr, Mrs, Ms)
     * - minOccurs: 0
     * @var string
     */
    public $TravelerTitle;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de documento identificativo: DNI, NIE, PAS. Obligatorio informar en la reserva Importante Tipo Obsoleto: OTR - NONE - no usar.
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The TravelerID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único del pasajero (1, 2, etc.)
     * - minOccurs: 0
     * @var int
     */
    public $TravelerID;
    /**
     * The InfantID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico del pasajero bebé acompañado (si lo hay)
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InfantID;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: Nombre del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Apellidos del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de documento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Correo electronico del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - documentation: Telefono del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de nacimiento (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The FrequentFlyerProgram
     * Meta information extracted from the WSDL
     * - documentation: Codigo de programa de pasajero frecuente
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerProgram;
    /**
     * The FrequentFlyerCardNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de tarjeta de pasajero frecuente
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerCardNumber;
    /**
     * The AdditionalBaggages
     * Meta information extracted from the WSDL
     * - documentation: Cantidad de maletas adicionales
     * - minOccurs: 0
     * @var int
     */
    public $AdditionalBaggages;
    /**
     * The IsResident
     * Meta information extracted from the WSDL
     * - documentation: Indica si es residente
     * - minOccurs: 0
     * @var bool
     */
    public $IsResident;
    /**
     * The IsResidentValidate
     * Meta information extracted from the WSDL
     * - documentation: Indica si el pasajero residente ha sido validado y debe llevar o no acreditación.
     * - minOccurs: 0
     * @var bool
     */
    public $IsResidentValidate;
    /**
     * The ResidentDocumentType
     * Meta information extracted from the WSDL
     * - documentation: Codigos de tipo de documento para pasajero frecuente DN,CR,GR,TR,MR,AM
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidentDocumentType;
    /**
     * The ResidentCityCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo de municipio para el pasajero residente
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidentCityCode;
    /**
     * The ResidentCertificateNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de certificado de pasajero residente
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidentCertificateNumber;
    /**
     * The TSAData
     * Meta information extracted from the WSDL
     * - documentation: Datos complementarios para pasajeros que vuelan a Estados Unidos
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirTravelerTSAData
     */
    public $TSAData;
    /**
     * The TicketAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del billete para este pasajero en esta reserva
     * - minOccurs: 0
     * @var float
     */
    public $TicketAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de las tasas para este pasajero
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The AgencyFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee de agencia para la reserva para este pasajero
     * - minOccurs: 0
     * @var float
     */
    public $AgencyFeeAmount;
    /**
     * The AramixFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee Aramix para la reserva para este pasajero
     * - minOccurs: 0
     * @var float
     */
    public $AramixFeeAmount;
    /**
     * The OBFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee que cobra la aerolinea por pago con tarjeta de crédito
     * - minOccurs: 0
     * @var float
     */
    public $OBFeeAmount;
    /**
     * The LstAirTravelerFlightSegmentLeg
     * Meta information extracted from the WSDL
     * - documentation: Lista de asociacion de cada pasajero con cada vuelo, en al que se puede encontrar el equipaje permitido para cada pasajero y vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTravelerFlightSegmentLeg
     */
    public $LstAirTravelerFlightSegmentLeg;
    /**
     * The LstAirTravelerAncillary
     * Meta information extracted from the WSDL
     * - documentation: Lista de asociacion de cada pasajero con cada ancillary
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTravelerAncillary
     */
    public $LstAirTravelerAncillary;
    /**
     * The ResidentName
     * Meta information extracted from the WSDL
     * - documentation: Nombre tal y como aparece en el documento de identidad: En caso de que el pasajero sea residente, se debe informar del nombre tal y como aparece en el documento para que la validación SARA, funcione correctamente. Si no se informan
     * correctamente los apellidos y el nombre como aparecen en el documento de identidad, es posible que los billetes sean cancelados tras la emisión.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidentName;
    /**
     * The ResidentSurname1
     * Meta information extracted from the WSDL
     * - documentation: Apellido 1: En caso de que el pasajero sea residente, se debe informar de los apellidos por separado para que la validación SARA, funcione correctamente. Si no se informan correctamente los apellidos y el nombre como aparecen en el
     * documento de identidad, es posible que los billetes sean cancelados tras la emisión.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidentSurname1;
    /**
     * The ResidentSurname12
     * Meta information extracted from the WSDL
     * - documentation: Apellido 2: En caso de que el pasajero sea residente, se debe informar de los apellidos por separado para que la validación SARA, funcione correctamente. Si no se informan correctamente los apellidos y el nombre como aparecen en el
     * documento de identidad, es posible que los billetes sean cancelados tras la emisión.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResidentSurname12;
    /**
     * The LstBaggageLowCostTf
     * Meta information extracted from the WSDL
     * - documentation: Lista de Equipaje seleccionado para este pasajero para reservas Travelfusion
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingBaggageLowCostTf
     */
    public $LstBaggageLowCostTf;
    /**
     * The PhoneType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de telefono Fijo, Movil
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhoneType;
    /**
     * The InternationalCodePhone
     * Meta information extracted from the WSDL
     * - documentation: Codigo internacional ej. 0034
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InternationalCodePhone;
    /**
     * The ExtensionPhone
     * Meta information extracted from the WSDL
     * - documentation: Extension del telefono
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtensionPhone;
    /**
     * The CodeAreaPhone
     * Meta information extracted from the WSDL
     * - documentation: Codigo de area, en desuso
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeAreaPhone;
    /**
     * The LstBaggageNDC
     * Meta information extracted from the WSDL
     * - documentation: Lista de equipaje seleccionado para este pasajero para reservas NDC
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingBaggageNDC
     */
    public $LstBaggageNDC;
    /**
     * Constructor method for AirTraveler
     * @uses AirTraveler::setTravelerType()
     * @uses AirTraveler::setTravelerTitle()
     * @uses AirTraveler::setDocumentType()
     * @uses AirTraveler::setTravelerID()
     * @uses AirTraveler::setInfantID()
     * @uses AirTraveler::setFirstName()
     * @uses AirTraveler::setLastName()
     * @uses AirTraveler::setDocumentNumber()
     * @uses AirTraveler::setEmail()
     * @uses AirTraveler::setPhone()
     * @uses AirTraveler::setBirthDate()
     * @uses AirTraveler::setFrequentFlyerProgram()
     * @uses AirTraveler::setFrequentFlyerCardNumber()
     * @uses AirTraveler::setAdditionalBaggages()
     * @uses AirTraveler::setIsResident()
     * @uses AirTraveler::setIsResidentValidate()
     * @uses AirTraveler::setResidentDocumentType()
     * @uses AirTraveler::setResidentCityCode()
     * @uses AirTraveler::setResidentCertificateNumber()
     * @uses AirTraveler::setTSAData()
     * @uses AirTraveler::setTicketAmount()
     * @uses AirTraveler::setTaxAmount()
     * @uses AirTraveler::setAgencyFeeAmount()
     * @uses AirTraveler::setAramixFeeAmount()
     * @uses AirTraveler::setOBFeeAmount()
     * @uses AirTraveler::setLstAirTravelerFlightSegmentLeg()
     * @uses AirTraveler::setLstAirTravelerAncillary()
     * @uses AirTraveler::setResidentName()
     * @uses AirTraveler::setResidentSurname1()
     * @uses AirTraveler::setResidentSurname12()
     * @uses AirTraveler::setLstBaggageLowCostTf()
     * @uses AirTraveler::setPhoneType()
     * @uses AirTraveler::setInternationalCodePhone()
     * @uses AirTraveler::setExtensionPhone()
     * @uses AirTraveler::setCodeAreaPhone()
     * @uses AirTraveler::setLstBaggageNDC()
     * @param string $travelerType
     * @param string $travelerTitle
     * @param string $documentType
     * @param int $travelerID
     * @param int $infantID
     * @param string $firstName
     * @param string $lastName
     * @param string $documentNumber
     * @param string $email
     * @param string $phone
     * @param string $birthDate
     * @param string $frequentFlyerProgram
     * @param string $frequentFlyerCardNumber
     * @param int $additionalBaggages
     * @param bool $isResident
     * @param bool $isResidentValidate
     * @param string $residentDocumentType
     * @param string $residentCityCode
     * @param string $residentCertificateNumber
     * @param \StructType\AirTravelerTSAData $tSAData
     * @param float $ticketAmount
     * @param float $taxAmount
     * @param float $agencyFeeAmount
     * @param float $aramixFeeAmount
     * @param float $oBFeeAmount
     * @param \ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg
     * @param \ArrayType\ArrayOfAirTravelerAncillary $lstAirTravelerAncillary
     * @param string $residentName
     * @param string $residentSurname1
     * @param string $residentSurname12
     * @param \ArrayType\ArrayOfAirBookingBaggageLowCostTf $lstBaggageLowCostTf
     * @param string $phoneType
     * @param string $internationalCodePhone
     * @param string $extensionPhone
     * @param string $codeAreaPhone
     * @param \ArrayType\ArrayOfAirBookingBaggageNDC $lstBaggageNDC
     */
    public function __construct($travelerType = null, $travelerTitle = null, $documentType = null, $travelerID = null, $infantID = null, $firstName = null, $lastName = null, $documentNumber = null, $email = null, $phone = null, $birthDate = null, $frequentFlyerProgram = null, $frequentFlyerCardNumber = null, $additionalBaggages = null, $isResident = null, $isResidentValidate = null, $residentDocumentType = null, $residentCityCode = null, $residentCertificateNumber = null, \StructType\AirTravelerTSAData $tSAData = null, $ticketAmount = null, $taxAmount = null, $agencyFeeAmount = null, $aramixFeeAmount = null, $oBFeeAmount = null, \ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg = null, \ArrayType\ArrayOfAirTravelerAncillary $lstAirTravelerAncillary = null, $residentName = null, $residentSurname1 = null, $residentSurname12 = null, \ArrayType\ArrayOfAirBookingBaggageLowCostTf $lstBaggageLowCostTf = null, $phoneType = null, $internationalCodePhone = null, $extensionPhone = null, $codeAreaPhone = null, \ArrayType\ArrayOfAirBookingBaggageNDC $lstBaggageNDC = null)
    {
        $this
            ->setTravelerType($travelerType)
            ->setTravelerTitle($travelerTitle)
            ->setDocumentType($documentType)
            ->setTravelerID($travelerID)
            ->setInfantID($infantID)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setDocumentNumber($documentNumber)
            ->setEmail($email)
            ->setPhone($phone)
            ->setBirthDate($birthDate)
            ->setFrequentFlyerProgram($frequentFlyerProgram)
            ->setFrequentFlyerCardNumber($frequentFlyerCardNumber)
            ->setAdditionalBaggages($additionalBaggages)
            ->setIsResident($isResident)
            ->setIsResidentValidate($isResidentValidate)
            ->setResidentDocumentType($residentDocumentType)
            ->setResidentCityCode($residentCityCode)
            ->setResidentCertificateNumber($residentCertificateNumber)
            ->setTSAData($tSAData)
            ->setTicketAmount($ticketAmount)
            ->setTaxAmount($taxAmount)
            ->setAgencyFeeAmount($agencyFeeAmount)
            ->setAramixFeeAmount($aramixFeeAmount)
            ->setOBFeeAmount($oBFeeAmount)
            ->setLstAirTravelerFlightSegmentLeg($lstAirTravelerFlightSegmentLeg)
            ->setLstAirTravelerAncillary($lstAirTravelerAncillary)
            ->setResidentName($residentName)
            ->setResidentSurname1($residentSurname1)
            ->setResidentSurname12($residentSurname12)
            ->setLstBaggageLowCostTf($lstBaggageLowCostTf)
            ->setPhoneType($phoneType)
            ->setInternationalCodePhone($internationalCodePhone)
            ->setExtensionPhone($extensionPhone)
            ->setCodeAreaPhone($codeAreaPhone)
            ->setLstBaggageNDC($lstBaggageNDC);
    }
    /**
     * Get TravelerType value
     * @return string|null
     */
    public function getTravelerType()
    {
        return $this->TravelerType;
    }
    /**
     * Set TravelerType value
     * @uses \EnumType\AirTravelerTypes::valueIsValid()
     * @uses \EnumType\AirTravelerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelerType
     * @return \StructType\AirTraveler
     */
    public function setTravelerType($travelerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTravelerTypes::valueIsValid($travelerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTravelerTypes', is_array($travelerType) ? implode(', ', $travelerType) : var_export($travelerType, true), implode(', ', \EnumType\AirTravelerTypes::getValidValues())), __LINE__);
        }
        $this->TravelerType = $travelerType;
        return $this;
    }
    /**
     * Get TravelerTitle value
     * @return string|null
     */
    public function getTravelerTitle()
    {
        return $this->TravelerTitle;
    }
    /**
     * Set TravelerTitle value
     * @uses \EnumType\AirTravelerTitles::valueIsValid()
     * @uses \EnumType\AirTravelerTitles::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $travelerTitle
     * @return \StructType\AirTraveler
     */
    public function setTravelerTitle($travelerTitle = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTravelerTitles::valueIsValid($travelerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTravelerTitles', is_array($travelerTitle) ? implode(', ', $travelerTitle) : var_export($travelerTitle, true), implode(', ', \EnumType\AirTravelerTitles::getValidValues())), __LINE__);
        }
        $this->TravelerTitle = $travelerTitle;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @uses \EnumType\AirTravelerDocumentTypes::valueIsValid()
     * @uses \EnumType\AirTravelerDocumentTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \StructType\AirTraveler
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTravelerDocumentTypes::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTravelerDocumentTypes', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \EnumType\AirTravelerDocumentTypes::getValidValues())), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get TravelerID value
     * @return int|null
     */
    public function getTravelerID()
    {
        return $this->TravelerID;
    }
    /**
     * Set TravelerID value
     * @param int $travelerID
     * @return \StructType\AirTraveler
     */
    public function setTravelerID($travelerID = null)
    {
        // validation for constraint: int
        if (!is_null($travelerID) && !(is_int($travelerID) || ctype_digit($travelerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerID, true), gettype($travelerID)), __LINE__);
        }
        $this->TravelerID = $travelerID;
        return $this;
    }
    /**
     * Get InfantID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInfantID()
    {
        return isset($this->InfantID) ? $this->InfantID : null;
    }
    /**
     * Set InfantID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $infantID
     * @return \StructType\AirTraveler
     */
    public function setInfantID($infantID = null)
    {
        // validation for constraint: int
        if (!is_null($infantID) && !(is_int($infantID) || ctype_digit($infantID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infantID, true), gettype($infantID)), __LINE__);
        }
        if (is_null($infantID) || (is_array($infantID) && empty($infantID))) {
            unset($this->InfantID);
        } else {
            $this->InfantID = $infantID;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\AirTraveler
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\AirTraveler
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get DocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return isset($this->DocumentNumber) ? $this->DocumentNumber : null;
    }
    /**
     * Set DocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentNumber
     * @return \StructType\AirTraveler
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        if (is_null($documentNumber) || (is_array($documentNumber) && empty($documentNumber))) {
            unset($this->DocumentNumber);
        } else {
            $this->DocumentNumber = $documentNumber;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\AirTraveler
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \StructType\AirTraveler
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get BirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->BirthDate) ? $this->BirthDate : null;
    }
    /**
     * Set BirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthDate
     * @return \StructType\AirTraveler
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->BirthDate);
        } else {
            $this->BirthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerProgram value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerProgram()
    {
        return isset($this->FrequentFlyerProgram) ? $this->FrequentFlyerProgram : null;
    }
    /**
     * Set FrequentFlyerProgram value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerProgram
     * @return \StructType\AirTraveler
     */
    public function setFrequentFlyerProgram($frequentFlyerProgram = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerProgram) && !is_string($frequentFlyerProgram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerProgram, true), gettype($frequentFlyerProgram)), __LINE__);
        }
        if (is_null($frequentFlyerProgram) || (is_array($frequentFlyerProgram) && empty($frequentFlyerProgram))) {
            unset($this->FrequentFlyerProgram);
        } else {
            $this->FrequentFlyerProgram = $frequentFlyerProgram;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerCardNumber()
    {
        return isset($this->FrequentFlyerCardNumber) ? $this->FrequentFlyerCardNumber : null;
    }
    /**
     * Set FrequentFlyerCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerCardNumber
     * @return \StructType\AirTraveler
     */
    public function setFrequentFlyerCardNumber($frequentFlyerCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerCardNumber) && !is_string($frequentFlyerCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerCardNumber, true), gettype($frequentFlyerCardNumber)), __LINE__);
        }
        if (is_null($frequentFlyerCardNumber) || (is_array($frequentFlyerCardNumber) && empty($frequentFlyerCardNumber))) {
            unset($this->FrequentFlyerCardNumber);
        } else {
            $this->FrequentFlyerCardNumber = $frequentFlyerCardNumber;
        }
        return $this;
    }
    /**
     * Get AdditionalBaggages value
     * @return int|null
     */
    public function getAdditionalBaggages()
    {
        return $this->AdditionalBaggages;
    }
    /**
     * Set AdditionalBaggages value
     * @param int $additionalBaggages
     * @return \StructType\AirTraveler
     */
    public function setAdditionalBaggages($additionalBaggages = null)
    {
        // validation for constraint: int
        if (!is_null($additionalBaggages) && !(is_int($additionalBaggages) || ctype_digit($additionalBaggages))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalBaggages, true), gettype($additionalBaggages)), __LINE__);
        }
        $this->AdditionalBaggages = $additionalBaggages;
        return $this;
    }
    /**
     * Get IsResident value
     * @return bool|null
     */
    public function getIsResident()
    {
        return $this->IsResident;
    }
    /**
     * Set IsResident value
     * @param bool $isResident
     * @return \StructType\AirTraveler
     */
    public function setIsResident($isResident = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResident) && !is_bool($isResident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResident, true), gettype($isResident)), __LINE__);
        }
        $this->IsResident = $isResident;
        return $this;
    }
    /**
     * Get IsResidentValidate value
     * @return bool|null
     */
    public function getIsResidentValidate()
    {
        return $this->IsResidentValidate;
    }
    /**
     * Set IsResidentValidate value
     * @param bool $isResidentValidate
     * @return \StructType\AirTraveler
     */
    public function setIsResidentValidate($isResidentValidate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResidentValidate) && !is_bool($isResidentValidate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResidentValidate, true), gettype($isResidentValidate)), __LINE__);
        }
        $this->IsResidentValidate = $isResidentValidate;
        return $this;
    }
    /**
     * Get ResidentDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidentDocumentType()
    {
        return isset($this->ResidentDocumentType) ? $this->ResidentDocumentType : null;
    }
    /**
     * Set ResidentDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\AirTravelerResidentDocumentTypes::valueIsValid()
     * @uses \EnumType\AirTravelerResidentDocumentTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $residentDocumentType
     * @return \StructType\AirTraveler
     */
    public function setResidentDocumentType($residentDocumentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTravelerResidentDocumentTypes::valueIsValid($residentDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTravelerResidentDocumentTypes', is_array($residentDocumentType) ? implode(', ', $residentDocumentType) : var_export($residentDocumentType, true), implode(', ', \EnumType\AirTravelerResidentDocumentTypes::getValidValues())), __LINE__);
        }
        if (is_null($residentDocumentType) || (is_array($residentDocumentType) && empty($residentDocumentType))) {
            unset($this->ResidentDocumentType);
        } else {
            $this->ResidentDocumentType = $residentDocumentType;
        }
        return $this;
    }
    /**
     * Get ResidentCityCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidentCityCode()
    {
        return isset($this->ResidentCityCode) ? $this->ResidentCityCode : null;
    }
    /**
     * Set ResidentCityCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residentCityCode
     * @return \StructType\AirTraveler
     */
    public function setResidentCityCode($residentCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($residentCityCode) && !is_string($residentCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentCityCode, true), gettype($residentCityCode)), __LINE__);
        }
        if (is_null($residentCityCode) || (is_array($residentCityCode) && empty($residentCityCode))) {
            unset($this->ResidentCityCode);
        } else {
            $this->ResidentCityCode = $residentCityCode;
        }
        return $this;
    }
    /**
     * Get ResidentCertificateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidentCertificateNumber()
    {
        return isset($this->ResidentCertificateNumber) ? $this->ResidentCertificateNumber : null;
    }
    /**
     * Set ResidentCertificateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residentCertificateNumber
     * @return \StructType\AirTraveler
     */
    public function setResidentCertificateNumber($residentCertificateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($residentCertificateNumber) && !is_string($residentCertificateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentCertificateNumber, true), gettype($residentCertificateNumber)), __LINE__);
        }
        if (is_null($residentCertificateNumber) || (is_array($residentCertificateNumber) && empty($residentCertificateNumber))) {
            unset($this->ResidentCertificateNumber);
        } else {
            $this->ResidentCertificateNumber = $residentCertificateNumber;
        }
        return $this;
    }
    /**
     * Get TSAData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirTravelerTSAData|null
     */
    public function getTSAData()
    {
        return isset($this->TSAData) ? $this->TSAData : null;
    }
    /**
     * Set TSAData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirTravelerTSAData $tSAData
     * @return \StructType\AirTraveler
     */
    public function setTSAData(\StructType\AirTravelerTSAData $tSAData = null)
    {
        if (is_null($tSAData) || (is_array($tSAData) && empty($tSAData))) {
            unset($this->TSAData);
        } else {
            $this->TSAData = $tSAData;
        }
        return $this;
    }
    /**
     * Get TicketAmount value
     * @return float|null
     */
    public function getTicketAmount()
    {
        return $this->TicketAmount;
    }
    /**
     * Set TicketAmount value
     * @param float $ticketAmount
     * @return \StructType\AirTraveler
     */
    public function setTicketAmount($ticketAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ticketAmount) && !(is_float($ticketAmount) || is_numeric($ticketAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ticketAmount, true), gettype($ticketAmount)), __LINE__);
        }
        $this->TicketAmount = $ticketAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\AirTraveler
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get AgencyFeeAmount value
     * @return float|null
     */
    public function getAgencyFeeAmount()
    {
        return $this->AgencyFeeAmount;
    }
    /**
     * Set AgencyFeeAmount value
     * @param float $agencyFeeAmount
     * @return \StructType\AirTraveler
     */
    public function setAgencyFeeAmount($agencyFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($agencyFeeAmount) && !(is_float($agencyFeeAmount) || is_numeric($agencyFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agencyFeeAmount, true), gettype($agencyFeeAmount)), __LINE__);
        }
        $this->AgencyFeeAmount = $agencyFeeAmount;
        return $this;
    }
    /**
     * Get AramixFeeAmount value
     * @return float|null
     */
    public function getAramixFeeAmount()
    {
        return $this->AramixFeeAmount;
    }
    /**
     * Set AramixFeeAmount value
     * @param float $aramixFeeAmount
     * @return \StructType\AirTraveler
     */
    public function setAramixFeeAmount($aramixFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($aramixFeeAmount) && !(is_float($aramixFeeAmount) || is_numeric($aramixFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aramixFeeAmount, true), gettype($aramixFeeAmount)), __LINE__);
        }
        $this->AramixFeeAmount = $aramixFeeAmount;
        return $this;
    }
    /**
     * Get OBFeeAmount value
     * @return float|null
     */
    public function getOBFeeAmount()
    {
        return $this->OBFeeAmount;
    }
    /**
     * Set OBFeeAmount value
     * @param float $oBFeeAmount
     * @return \StructType\AirTraveler
     */
    public function setOBFeeAmount($oBFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($oBFeeAmount) && !(is_float($oBFeeAmount) || is_numeric($oBFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oBFeeAmount, true), gettype($oBFeeAmount)), __LINE__);
        }
        $this->OBFeeAmount = $oBFeeAmount;
        return $this;
    }
    /**
     * Get LstAirTravelerFlightSegmentLeg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTravelerFlightSegmentLeg|null
     */
    public function getLstAirTravelerFlightSegmentLeg()
    {
        return isset($this->LstAirTravelerFlightSegmentLeg) ? $this->LstAirTravelerFlightSegmentLeg : null;
    }
    /**
     * Set LstAirTravelerFlightSegmentLeg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg
     * @return \StructType\AirTraveler
     */
    public function setLstAirTravelerFlightSegmentLeg(\ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg = null)
    {
        if (is_null($lstAirTravelerFlightSegmentLeg) || (is_array($lstAirTravelerFlightSegmentLeg) && empty($lstAirTravelerFlightSegmentLeg))) {
            unset($this->LstAirTravelerFlightSegmentLeg);
        } else {
            $this->LstAirTravelerFlightSegmentLeg = $lstAirTravelerFlightSegmentLeg;
        }
        return $this;
    }
    /**
     * Get LstAirTravelerAncillary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTravelerAncillary|null
     */
    public function getLstAirTravelerAncillary()
    {
        return isset($this->LstAirTravelerAncillary) ? $this->LstAirTravelerAncillary : null;
    }
    /**
     * Set LstAirTravelerAncillary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTravelerAncillary $lstAirTravelerAncillary
     * @return \StructType\AirTraveler
     */
    public function setLstAirTravelerAncillary(\ArrayType\ArrayOfAirTravelerAncillary $lstAirTravelerAncillary = null)
    {
        if (is_null($lstAirTravelerAncillary) || (is_array($lstAirTravelerAncillary) && empty($lstAirTravelerAncillary))) {
            unset($this->LstAirTravelerAncillary);
        } else {
            $this->LstAirTravelerAncillary = $lstAirTravelerAncillary;
        }
        return $this;
    }
    /**
     * Get ResidentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidentName()
    {
        return isset($this->ResidentName) ? $this->ResidentName : null;
    }
    /**
     * Set ResidentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residentName
     * @return \StructType\AirTraveler
     */
    public function setResidentName($residentName = null)
    {
        // validation for constraint: string
        if (!is_null($residentName) && !is_string($residentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentName, true), gettype($residentName)), __LINE__);
        }
        if (is_null($residentName) || (is_array($residentName) && empty($residentName))) {
            unset($this->ResidentName);
        } else {
            $this->ResidentName = $residentName;
        }
        return $this;
    }
    /**
     * Get ResidentSurname1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidentSurname1()
    {
        return isset($this->ResidentSurname1) ? $this->ResidentSurname1 : null;
    }
    /**
     * Set ResidentSurname1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residentSurname1
     * @return \StructType\AirTraveler
     */
    public function setResidentSurname1($residentSurname1 = null)
    {
        // validation for constraint: string
        if (!is_null($residentSurname1) && !is_string($residentSurname1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentSurname1, true), gettype($residentSurname1)), __LINE__);
        }
        if (is_null($residentSurname1) || (is_array($residentSurname1) && empty($residentSurname1))) {
            unset($this->ResidentSurname1);
        } else {
            $this->ResidentSurname1 = $residentSurname1;
        }
        return $this;
    }
    /**
     * Get ResidentSurname12 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResidentSurname12()
    {
        return isset($this->ResidentSurname12) ? $this->ResidentSurname12 : null;
    }
    /**
     * Set ResidentSurname12 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $residentSurname12
     * @return \StructType\AirTraveler
     */
    public function setResidentSurname12($residentSurname12 = null)
    {
        // validation for constraint: string
        if (!is_null($residentSurname12) && !is_string($residentSurname12)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentSurname12, true), gettype($residentSurname12)), __LINE__);
        }
        if (is_null($residentSurname12) || (is_array($residentSurname12) && empty($residentSurname12))) {
            unset($this->ResidentSurname12);
        } else {
            $this->ResidentSurname12 = $residentSurname12;
        }
        return $this;
    }
    /**
     * Get LstBaggageLowCostTf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingBaggageLowCostTf|null
     */
    public function getLstBaggageLowCostTf()
    {
        return isset($this->LstBaggageLowCostTf) ? $this->LstBaggageLowCostTf : null;
    }
    /**
     * Set LstBaggageLowCostTf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingBaggageLowCostTf $lstBaggageLowCostTf
     * @return \StructType\AirTraveler
     */
    public function setLstBaggageLowCostTf(\ArrayType\ArrayOfAirBookingBaggageLowCostTf $lstBaggageLowCostTf = null)
    {
        if (is_null($lstBaggageLowCostTf) || (is_array($lstBaggageLowCostTf) && empty($lstBaggageLowCostTf))) {
            unset($this->LstBaggageLowCostTf);
        } else {
            $this->LstBaggageLowCostTf = $lstBaggageLowCostTf;
        }
        return $this;
    }
    /**
     * Get PhoneType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneType()
    {
        return isset($this->PhoneType) ? $this->PhoneType : null;
    }
    /**
     * Set PhoneType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneType
     * @return \StructType\AirTraveler
     */
    public function setPhoneType($phoneType = null)
    {
        // validation for constraint: string
        if (!is_null($phoneType) && !is_string($phoneType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneType, true), gettype($phoneType)), __LINE__);
        }
        if (is_null($phoneType) || (is_array($phoneType) && empty($phoneType))) {
            unset($this->PhoneType);
        } else {
            $this->PhoneType = $phoneType;
        }
        return $this;
    }
    /**
     * Get InternationalCodePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalCodePhone()
    {
        return isset($this->InternationalCodePhone) ? $this->InternationalCodePhone : null;
    }
    /**
     * Set InternationalCodePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internationalCodePhone
     * @return \StructType\AirTraveler
     */
    public function setInternationalCodePhone($internationalCodePhone = null)
    {
        // validation for constraint: string
        if (!is_null($internationalCodePhone) && !is_string($internationalCodePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalCodePhone, true), gettype($internationalCodePhone)), __LINE__);
        }
        if (is_null($internationalCodePhone) || (is_array($internationalCodePhone) && empty($internationalCodePhone))) {
            unset($this->InternationalCodePhone);
        } else {
            $this->InternationalCodePhone = $internationalCodePhone;
        }
        return $this;
    }
    /**
     * Get ExtensionPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtensionPhone()
    {
        return isset($this->ExtensionPhone) ? $this->ExtensionPhone : null;
    }
    /**
     * Set ExtensionPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extensionPhone
     * @return \StructType\AirTraveler
     */
    public function setExtensionPhone($extensionPhone = null)
    {
        // validation for constraint: string
        if (!is_null($extensionPhone) && !is_string($extensionPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extensionPhone, true), gettype($extensionPhone)), __LINE__);
        }
        if (is_null($extensionPhone) || (is_array($extensionPhone) && empty($extensionPhone))) {
            unset($this->ExtensionPhone);
        } else {
            $this->ExtensionPhone = $extensionPhone;
        }
        return $this;
    }
    /**
     * Get CodeAreaPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeAreaPhone()
    {
        return isset($this->CodeAreaPhone) ? $this->CodeAreaPhone : null;
    }
    /**
     * Set CodeAreaPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeAreaPhone
     * @return \StructType\AirTraveler
     */
    public function setCodeAreaPhone($codeAreaPhone = null)
    {
        // validation for constraint: string
        if (!is_null($codeAreaPhone) && !is_string($codeAreaPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeAreaPhone, true), gettype($codeAreaPhone)), __LINE__);
        }
        if (is_null($codeAreaPhone) || (is_array($codeAreaPhone) && empty($codeAreaPhone))) {
            unset($this->CodeAreaPhone);
        } else {
            $this->CodeAreaPhone = $codeAreaPhone;
        }
        return $this;
    }
    /**
     * Get LstBaggageNDC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingBaggageNDC|null
     */
    public function getLstBaggageNDC()
    {
        return isset($this->LstBaggageNDC) ? $this->LstBaggageNDC : null;
    }
    /**
     * Set LstBaggageNDC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingBaggageNDC $lstBaggageNDC
     * @return \StructType\AirTraveler
     */
    public function setLstBaggageNDC(\ArrayType\ArrayOfAirBookingBaggageNDC $lstBaggageNDC = null)
    {
        if (is_null($lstBaggageNDC) || (is_array($lstBaggageNDC) && empty($lstBaggageNDC))) {
            unset($this->LstBaggageNDC);
        } else {
            $this->LstBaggageNDC = $lstBaggageNDC;
        }
        return $this;
    }
}
