<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPricedItinerary StructType
 * Meta information extracted from the WSDL
 * - documentation: Dado un itinerario dado las opciones posibles de tarifa, clase y numero de asientos disponibles
 * - nillable: true
 * - type: tns:AirPricedItinerary
 * @subpackage Structs
 */
class AirPricedItinerary extends AbstractStructBase
{
    /**
     * The ItineraryID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del itinerario correspondiente
     * - minOccurs: 0
     * @var int
     */
    public $ItineraryID;
    /**
     * The AirPricedItineraryLegs
     * Meta information extracted from the WSDL
     * - documentation: Datos de los trayectos del itinerario como la tarifa, clase, cabina, asientos disponibles, etc
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirPricedItineraryLeg
     */
    public $AirPricedItineraryLegs;
    /**
     * Constructor method for AirPricedItinerary
     * @uses AirPricedItinerary::setItineraryID()
     * @uses AirPricedItinerary::setAirPricedItineraryLegs()
     * @param int $itineraryID
     * @param \ArrayType\ArrayOfAirPricedItineraryLeg $airPricedItineraryLegs
     */
    public function __construct($itineraryID = null, \ArrayType\ArrayOfAirPricedItineraryLeg $airPricedItineraryLegs = null)
    {
        $this
            ->setItineraryID($itineraryID)
            ->setAirPricedItineraryLegs($airPricedItineraryLegs);
    }
    /**
     * Get ItineraryID value
     * @return int|null
     */
    public function getItineraryID()
    {
        return $this->ItineraryID;
    }
    /**
     * Set ItineraryID value
     * @param int $itineraryID
     * @return \StructType\AirPricedItinerary
     */
    public function setItineraryID($itineraryID = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryID) && !(is_int($itineraryID) || ctype_digit($itineraryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itineraryID, true), gettype($itineraryID)), __LINE__);
        }
        $this->ItineraryID = $itineraryID;
        return $this;
    }
    /**
     * Get AirPricedItineraryLegs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirPricedItineraryLeg|null
     */
    public function getAirPricedItineraryLegs()
    {
        return isset($this->AirPricedItineraryLegs) ? $this->AirPricedItineraryLegs : null;
    }
    /**
     * Set AirPricedItineraryLegs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirPricedItineraryLeg $airPricedItineraryLegs
     * @return \StructType\AirPricedItinerary
     */
    public function setAirPricedItineraryLegs(\ArrayType\ArrayOfAirPricedItineraryLeg $airPricedItineraryLegs = null)
    {
        if (is_null($airPricedItineraryLegs) || (is_array($airPricedItineraryLegs) && empty($airPricedItineraryLegs))) {
            unset($this->AirPricedItineraryLegs);
        } else {
            $this->AirPricedItineraryLegs = $airPricedItineraryLegs;
        }
        return $this;
    }
}
