<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItinerary StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un itinerario aereo. Un itinerario está compuesto por N Segmentos
 * - nillable: true
 * - type: tns:AirItinerary
 * @subpackage Structs
 */
class AirItinerary extends AbstractStructBase
{
    /**
     * The ItineraryID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del itinerario
     * - minOccurs: 0
     * @var int
     */
    public $ItineraryID;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de salida (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de llegada tras completar todos los trayectos del itinerario (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo IATA que identifica el Aeropuerto Destino del itinerario
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo IATA que identifica el Aeropuerto Origen del itinerario
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The AirItineraryLegs
     * Meta information extracted from the WSDL
     * - documentation: Lista de trayectos necesarios para completar un itinerario, un trayecto puede incluir una o mas paradas técnicas
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirItineraryLeg
     */
    public $AirItineraryLegs;
    /**
     * The TotalDuration
     * Meta information extracted from the WSDL
     * - documentation: Duracion en formato 02:59 que indica la cantidad total de horas y minutos necesarios para completar el itinerario
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TotalDuration;
    /**
     * The SegmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de segmento del itinerario dentro de nuestro viaje. Si es solo ida solo habrá: número de segmento 1, si es ida y vuelta habra segmento 1 y segmento 2, si es multi destino habrá de 1 a n segmentos, un segmento por cada
     * origen destino solicitado.
     * - minOccurs: 0
     * @var int
     */
    public $SegmentNumber;
    /**
     * Constructor method for AirItinerary
     * @uses AirItinerary::setItineraryID()
     * @uses AirItinerary::setDepartureDateTime()
     * @uses AirItinerary::setArrivalDateTime()
     * @uses AirItinerary::setArrivalAirportLocationCode()
     * @uses AirItinerary::setDepartureAirportLocationCode()
     * @uses AirItinerary::setAirItineraryLegs()
     * @uses AirItinerary::setTotalDuration()
     * @uses AirItinerary::setSegmentNumber()
     * @param int $itineraryID
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param string $arrivalAirportLocationCode
     * @param string $departureAirportLocationCode
     * @param \ArrayType\ArrayOfAirItineraryLeg $airItineraryLegs
     * @param string $totalDuration
     * @param int $segmentNumber
     */
    public function __construct($itineraryID = null, $departureDateTime = null, $arrivalDateTime = null, $arrivalAirportLocationCode = null, $departureAirportLocationCode = null, \ArrayType\ArrayOfAirItineraryLeg $airItineraryLegs = null, $totalDuration = null, $segmentNumber = null)
    {
        $this
            ->setItineraryID($itineraryID)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setAirItineraryLegs($airItineraryLegs)
            ->setTotalDuration($totalDuration)
            ->setSegmentNumber($segmentNumber);
    }
    /**
     * Get ItineraryID value
     * @return int|null
     */
    public function getItineraryID()
    {
        return $this->ItineraryID;
    }
    /**
     * Set ItineraryID value
     * @param int $itineraryID
     * @return \StructType\AirItinerary
     */
    public function setItineraryID($itineraryID = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryID) && !(is_int($itineraryID) || ctype_digit($itineraryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itineraryID, true), gettype($itineraryID)), __LINE__);
        }
        $this->ItineraryID = $itineraryID;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * Set DepartureDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDateTime
     * @return \StructType\AirItinerary
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return isset($this->ArrivalDateTime) ? $this->ArrivalDateTime : null;
    }
    /**
     * Set ArrivalDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalDateTime
     * @return \StructType\AirItinerary
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        if (is_null($arrivalDateTime) || (is_array($arrivalDateTime) && empty($arrivalDateTime))) {
            unset($this->ArrivalDateTime);
        } else {
            $this->ArrivalDateTime = $arrivalDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirItinerary
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirItinerary
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get AirItineraryLegs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirItineraryLeg|null
     */
    public function getAirItineraryLegs()
    {
        return isset($this->AirItineraryLegs) ? $this->AirItineraryLegs : null;
    }
    /**
     * Set AirItineraryLegs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirItineraryLeg $airItineraryLegs
     * @return \StructType\AirItinerary
     */
    public function setAirItineraryLegs(\ArrayType\ArrayOfAirItineraryLeg $airItineraryLegs = null)
    {
        if (is_null($airItineraryLegs) || (is_array($airItineraryLegs) && empty($airItineraryLegs))) {
            unset($this->AirItineraryLegs);
        } else {
            $this->AirItineraryLegs = $airItineraryLegs;
        }
        return $this;
    }
    /**
     * Get TotalDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTotalDuration()
    {
        return isset($this->TotalDuration) ? $this->TotalDuration : null;
    }
    /**
     * Set TotalDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $totalDuration
     * @return \StructType\AirItinerary
     */
    public function setTotalDuration($totalDuration = null)
    {
        // validation for constraint: string
        if (!is_null($totalDuration) && !is_string($totalDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalDuration, true), gettype($totalDuration)), __LINE__);
        }
        if (is_null($totalDuration) || (is_array($totalDuration) && empty($totalDuration))) {
            unset($this->TotalDuration);
        } else {
            $this->TotalDuration = $totalDuration;
        }
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return int|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param int $segmentNumber
     * @return \StructType\AirItinerary
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($segmentNumber) && !(is_int($segmentNumber) || ctype_digit($segmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segmentNumber, true), gettype($segmentNumber)), __LINE__);
        }
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
}
