<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirInsurancePolicy StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos de la poliza del seguro para una reserva
 * - nillable: true
 * - type: tns:AirInsurancePolicy
 * @subpackage Structs
 */
class AirInsurancePolicy extends AbstractStructBase
{
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del seguro de cancelacion
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The TotalAmountInsured
     * Meta information extracted from the WSDL
     * - documentation: Importe Asegurado
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmountInsured;
    /**
     * The PolicyNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de la poliza
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PolicyNumber;
    /**
     * The UrlCertificate
     * Meta information extracted from the WSDL
     * - documentation: Direccion Url del Certificado
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlCertificate;
    /**
     * The ReferenceCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo de Referencia
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceCode;
    /**
     * The PartnershipGrouping
     * Meta information extracted from the WSDL
     * - documentation: Asociacion de agrupacion del seguro
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartnershipGrouping;
    /**
     * The Modality
     * Meta information extracted from the WSDL
     * - documentation: Modalidad del seguro
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Modality;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - documentation: Destino donde es el seguro
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The IssueDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha de expedicion (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueDateTime;
    /**
     * The FromDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha Desde (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDateTime;
    /**
     * The ToDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha Hasta (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDateTime;
    /**
     * Constructor method for AirInsurancePolicy
     * @uses AirInsurancePolicy::setInsuranceAmount()
     * @uses AirInsurancePolicy::setTotalAmountInsured()
     * @uses AirInsurancePolicy::setPolicyNumber()
     * @uses AirInsurancePolicy::setUrlCertificate()
     * @uses AirInsurancePolicy::setReferenceCode()
     * @uses AirInsurancePolicy::setPartnershipGrouping()
     * @uses AirInsurancePolicy::setModality()
     * @uses AirInsurancePolicy::setDestination()
     * @uses AirInsurancePolicy::setIssueDateTime()
     * @uses AirInsurancePolicy::setFromDateTime()
     * @uses AirInsurancePolicy::setToDateTime()
     * @param float $insuranceAmount
     * @param float $totalAmountInsured
     * @param string $policyNumber
     * @param string $urlCertificate
     * @param string $referenceCode
     * @param string $partnershipGrouping
     * @param string $modality
     * @param string $destination
     * @param string $issueDateTime
     * @param string $fromDateTime
     * @param string $toDateTime
     */
    public function __construct($insuranceAmount = null, $totalAmountInsured = null, $policyNumber = null, $urlCertificate = null, $referenceCode = null, $partnershipGrouping = null, $modality = null, $destination = null, $issueDateTime = null, $fromDateTime = null, $toDateTime = null)
    {
        $this
            ->setInsuranceAmount($insuranceAmount)
            ->setTotalAmountInsured($totalAmountInsured)
            ->setPolicyNumber($policyNumber)
            ->setUrlCertificate($urlCertificate)
            ->setReferenceCode($referenceCode)
            ->setPartnershipGrouping($partnershipGrouping)
            ->setModality($modality)
            ->setDestination($destination)
            ->setIssueDateTime($issueDateTime)
            ->setFromDateTime($fromDateTime)
            ->setToDateTime($toDateTime);
    }
    /**
     * Get InsuranceAmount value
     * @return float|null
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \StructType\AirInsurancePolicy
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get TotalAmountInsured value
     * @return float|null
     */
    public function getTotalAmountInsured()
    {
        return $this->TotalAmountInsured;
    }
    /**
     * Set TotalAmountInsured value
     * @param float $totalAmountInsured
     * @return \StructType\AirInsurancePolicy
     */
    public function setTotalAmountInsured($totalAmountInsured = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmountInsured) && !(is_float($totalAmountInsured) || is_numeric($totalAmountInsured))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmountInsured, true), gettype($totalAmountInsured)), __LINE__);
        }
        $this->TotalAmountInsured = $totalAmountInsured;
        return $this;
    }
    /**
     * Get PolicyNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolicyNumber()
    {
        return isset($this->PolicyNumber) ? $this->PolicyNumber : null;
    }
    /**
     * Set PolicyNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $policyNumber
     * @return \StructType\AirInsurancePolicy
     */
    public function setPolicyNumber($policyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($policyNumber) && !is_string($policyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyNumber, true), gettype($policyNumber)), __LINE__);
        }
        if (is_null($policyNumber) || (is_array($policyNumber) && empty($policyNumber))) {
            unset($this->PolicyNumber);
        } else {
            $this->PolicyNumber = $policyNumber;
        }
        return $this;
    }
    /**
     * Get UrlCertificate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlCertificate()
    {
        return isset($this->UrlCertificate) ? $this->UrlCertificate : null;
    }
    /**
     * Set UrlCertificate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlCertificate
     * @return \StructType\AirInsurancePolicy
     */
    public function setUrlCertificate($urlCertificate = null)
    {
        // validation for constraint: string
        if (!is_null($urlCertificate) && !is_string($urlCertificate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlCertificate, true), gettype($urlCertificate)), __LINE__);
        }
        if (is_null($urlCertificate) || (is_array($urlCertificate) && empty($urlCertificate))) {
            unset($this->UrlCertificate);
        } else {
            $this->UrlCertificate = $urlCertificate;
        }
        return $this;
    }
    /**
     * Get ReferenceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceCode()
    {
        return isset($this->ReferenceCode) ? $this->ReferenceCode : null;
    }
    /**
     * Set ReferenceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceCode
     * @return \StructType\AirInsurancePolicy
     */
    public function setReferenceCode($referenceCode = null)
    {
        // validation for constraint: string
        if (!is_null($referenceCode) && !is_string($referenceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceCode, true), gettype($referenceCode)), __LINE__);
        }
        if (is_null($referenceCode) || (is_array($referenceCode) && empty($referenceCode))) {
            unset($this->ReferenceCode);
        } else {
            $this->ReferenceCode = $referenceCode;
        }
        return $this;
    }
    /**
     * Get PartnershipGrouping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartnershipGrouping()
    {
        return isset($this->PartnershipGrouping) ? $this->PartnershipGrouping : null;
    }
    /**
     * Set PartnershipGrouping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partnershipGrouping
     * @return \StructType\AirInsurancePolicy
     */
    public function setPartnershipGrouping($partnershipGrouping = null)
    {
        // validation for constraint: string
        if (!is_null($partnershipGrouping) && !is_string($partnershipGrouping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnershipGrouping, true), gettype($partnershipGrouping)), __LINE__);
        }
        if (is_null($partnershipGrouping) || (is_array($partnershipGrouping) && empty($partnershipGrouping))) {
            unset($this->PartnershipGrouping);
        } else {
            $this->PartnershipGrouping = $partnershipGrouping;
        }
        return $this;
    }
    /**
     * Get Modality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModality()
    {
        return isset($this->Modality) ? $this->Modality : null;
    }
    /**
     * Set Modality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modality
     * @return \StructType\AirInsurancePolicy
     */
    public function setModality($modality = null)
    {
        // validation for constraint: string
        if (!is_null($modality) && !is_string($modality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modality, true), gettype($modality)), __LINE__);
        }
        if (is_null($modality) || (is_array($modality) && empty($modality))) {
            unset($this->Modality);
        } else {
            $this->Modality = $modality;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\AirInsurancePolicy
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get IssueDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueDateTime()
    {
        return isset($this->IssueDateTime) ? $this->IssueDateTime : null;
    }
    /**
     * Set IssueDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueDateTime
     * @return \StructType\AirInsurancePolicy
     */
    public function setIssueDateTime($issueDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueDateTime) && !is_string($issueDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDateTime, true), gettype($issueDateTime)), __LINE__);
        }
        if (is_null($issueDateTime) || (is_array($issueDateTime) && empty($issueDateTime))) {
            unset($this->IssueDateTime);
        } else {
            $this->IssueDateTime = $issueDateTime;
        }
        return $this;
    }
    /**
     * Get FromDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDateTime()
    {
        return isset($this->FromDateTime) ? $this->FromDateTime : null;
    }
    /**
     * Set FromDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDateTime
     * @return \StructType\AirInsurancePolicy
     */
    public function setFromDateTime($fromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateTime) && !is_string($fromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateTime, true), gettype($fromDateTime)), __LINE__);
        }
        if (is_null($fromDateTime) || (is_array($fromDateTime) && empty($fromDateTime))) {
            unset($this->FromDateTime);
        } else {
            $this->FromDateTime = $fromDateTime;
        }
        return $this;
    }
    /**
     * Get ToDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDateTime()
    {
        return isset($this->ToDateTime) ? $this->ToDateTime : null;
    }
    /**
     * Set ToDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDateTime
     * @return \StructType\AirInsurancePolicy
     */
    public function setToDateTime($toDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($toDateTime) && !is_string($toDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateTime, true), gettype($toDateTime)), __LINE__);
        }
        if (is_null($toDateTime) || (is_array($toDateTime) && empty($toDateTime))) {
            unset($this->ToDateTime);
        } else {
            $this->ToDateTime = $toDateTime;
        }
        return $this;
    }
}
