<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFlightSegmentRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un segmento de vuelo para el request
 * - nillable: true
 * - type: tns:AirFlightSegmentRQ
 * @subpackage Structs
 */
class AirFlightSegmentRQ extends AbstractStructBase
{
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código del aeropuerto de origen
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código del aeropuerto de destino
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de salida (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDate;
    /**
     * The DepartureTime
     * Meta information extracted from the WSDL
     * - documentation: Hora de salida (formato HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureTime;
    /**
     * The DepartureIsCity
     * Meta information extracted from the WSDL
     * - documentation: Determina si es ciudad el origen del vuelo
     * - minOccurs: 0
     * @var bool
     */
    public $DepartureIsCity;
    /**
     * The ArrivalIsCity
     * Meta information extracted from the WSDL
     * - documentation: Determina si es ciudad el destino del vuelo
     * - minOccurs: 0
     * @var bool
     */
    public $ArrivalIsCity;
    /**
     * Constructor method for AirFlightSegmentRQ
     * @uses AirFlightSegmentRQ::setDepartureAirportLocationCode()
     * @uses AirFlightSegmentRQ::setArrivalAirportLocationCode()
     * @uses AirFlightSegmentRQ::setDepartureDate()
     * @uses AirFlightSegmentRQ::setDepartureTime()
     * @uses AirFlightSegmentRQ::setDepartureIsCity()
     * @uses AirFlightSegmentRQ::setArrivalIsCity()
     * @param string $departureAirportLocationCode
     * @param string $arrivalAirportLocationCode
     * @param string $departureDate
     * @param string $departureTime
     * @param bool $departureIsCity
     * @param bool $arrivalIsCity
     */
    public function __construct($departureAirportLocationCode = null, $arrivalAirportLocationCode = null, $departureDate = null, $departureTime = null, $departureIsCity = null, $arrivalIsCity = null)
    {
        $this
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setDepartureDate($departureDate)
            ->setDepartureTime($departureTime)
            ->setDepartureIsCity($departureIsCity)
            ->setArrivalIsCity($arrivalIsCity);
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirFlightSegmentRQ
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirFlightSegmentRQ
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get DepartureDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDate()
    {
        return isset($this->DepartureDate) ? $this->DepartureDate : null;
    }
    /**
     * Set DepartureDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDate
     * @return \StructType\AirFlightSegmentRQ
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        if (is_null($departureDate) || (is_array($departureDate) && empty($departureDate))) {
            unset($this->DepartureDate);
        } else {
            $this->DepartureDate = $departureDate;
        }
        return $this;
    }
    /**
     * Get DepartureTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureTime()
    {
        return isset($this->DepartureTime) ? $this->DepartureTime : null;
    }
    /**
     * Set DepartureTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureTime
     * @return \StructType\AirFlightSegmentRQ
     */
    public function setDepartureTime($departureTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureTime) && !is_string($departureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureTime, true), gettype($departureTime)), __LINE__);
        }
        if (is_null($departureTime) || (is_array($departureTime) && empty($departureTime))) {
            unset($this->DepartureTime);
        } else {
            $this->DepartureTime = $departureTime;
        }
        return $this;
    }
    /**
     * Get DepartureIsCity value
     * @return bool|null
     */
    public function getDepartureIsCity()
    {
        return $this->DepartureIsCity;
    }
    /**
     * Set DepartureIsCity value
     * @param bool $departureIsCity
     * @return \StructType\AirFlightSegmentRQ
     */
    public function setDepartureIsCity($departureIsCity = null)
    {
        // validation for constraint: boolean
        if (!is_null($departureIsCity) && !is_bool($departureIsCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($departureIsCity, true), gettype($departureIsCity)), __LINE__);
        }
        $this->DepartureIsCity = $departureIsCity;
        return $this;
    }
    /**
     * Get ArrivalIsCity value
     * @return bool|null
     */
    public function getArrivalIsCity()
    {
        return $this->ArrivalIsCity;
    }
    /**
     * Set ArrivalIsCity value
     * @param bool $arrivalIsCity
     * @return \StructType\AirFlightSegmentRQ
     */
    public function setArrivalIsCity($arrivalIsCity = null)
    {
        // validation for constraint: boolean
        if (!is_null($arrivalIsCity) && !is_bool($arrivalIsCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arrivalIsCity, true), gettype($arrivalIsCity)), __LINE__);
        }
        $this->ArrivalIsCity = $arrivalIsCity;
        return $this;
    }
}
