<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFareNote StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una nota de tarifa
 * - nillable: true
 * - type: tns:AirFareNote
 * @subpackage Structs
 */
class AirFareNote extends AbstractStructBase
{
    /**
     * The NoteCode
     * Meta information extracted from the WSDL
     * - documentation: Código de la nota
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NoteCode;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - documentation: Categoría de la nota
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Descripción de la nota
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AirFareNote
     * @uses AirFareNote::setNoteCode()
     * @uses AirFareNote::setCategory()
     * @uses AirFareNote::setDescription()
     * @param string $noteCode
     * @param string $category
     * @param string $description
     */
    public function __construct($noteCode = null, $category = null, $description = null)
    {
        $this
            ->setNoteCode($noteCode)
            ->setCategory($category)
            ->setDescription($description);
    }
    /**
     * Get NoteCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNoteCode()
    {
        return isset($this->NoteCode) ? $this->NoteCode : null;
    }
    /**
     * Set NoteCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $noteCode
     * @return \StructType\AirFareNote
     */
    public function setNoteCode($noteCode = null)
    {
        // validation for constraint: string
        if (!is_null($noteCode) && !is_string($noteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteCode, true), gettype($noteCode)), __LINE__);
        }
        if (is_null($noteCode) || (is_array($noteCode) && empty($noteCode))) {
            unset($this->NoteCode);
        } else {
            $this->NoteCode = $noteCode;
        }
        return $this;
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \StructType\AirFareNote
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirFareNote
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
