<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFareFamiliesFlightSegment StructType
 * Meta information extracted from the WSDL
 * - documentation: Estructura dónde se almacenará la información de vuelos asociada a la opción de FareFamilies
 * - nillable: true
 * - type: tns:AirFareFamiliesFlightSegment
 * @subpackage Structs
 */
class AirFareFamiliesFlightSegment extends AbstractStructBase
{
    /**
     * The FlightType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de Vuelo (ida o vuelta)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightType;
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Iata Origen del Segmento de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Iata Destino del Segmento de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The FlightSegmentLegs
     * Meta information extracted from the WSDL
     * - documentation: Estructura dónde se almacenará la información de los trayectos de vuelo asociados a la opción de FareFamilies
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirFareFamiliesFlightSegmentLeg
     */
    public $FlightSegmentLegs;
    /**
     * Constructor method for AirFareFamiliesFlightSegment
     * @uses AirFareFamiliesFlightSegment::setFlightType()
     * @uses AirFareFamiliesFlightSegment::setDepartureAirportLocationCode()
     * @uses AirFareFamiliesFlightSegment::setArrivalAirportLocationCode()
     * @uses AirFareFamiliesFlightSegment::setFlightSegmentLegs()
     * @param string $flightType
     * @param string $departureAirportLocationCode
     * @param string $arrivalAirportLocationCode
     * @param \ArrayType\ArrayOfAirFareFamiliesFlightSegmentLeg $flightSegmentLegs
     */
    public function __construct($flightType = null, $departureAirportLocationCode = null, $arrivalAirportLocationCode = null, \ArrayType\ArrayOfAirFareFamiliesFlightSegmentLeg $flightSegmentLegs = null)
    {
        $this
            ->setFlightType($flightType)
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setFlightSegmentLegs($flightSegmentLegs);
    }
    /**
     * Get FlightType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightType()
    {
        return isset($this->FlightType) ? $this->FlightType : null;
    }
    /**
     * Set FlightType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightType
     * @return \StructType\AirFareFamiliesFlightSegment
     */
    public function setFlightType($flightType = null)
    {
        // validation for constraint: string
        if (!is_null($flightType) && !is_string($flightType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightType, true), gettype($flightType)), __LINE__);
        }
        if (is_null($flightType) || (is_array($flightType) && empty($flightType))) {
            unset($this->FlightType);
        } else {
            $this->FlightType = $flightType;
        }
        return $this;
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirFareFamiliesFlightSegment
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirFareFamiliesFlightSegment
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get FlightSegmentLegs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirFareFamiliesFlightSegmentLeg|null
     */
    public function getFlightSegmentLegs()
    {
        return isset($this->FlightSegmentLegs) ? $this->FlightSegmentLegs : null;
    }
    /**
     * Set FlightSegmentLegs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirFareFamiliesFlightSegmentLeg $flightSegmentLegs
     * @return \StructType\AirFareFamiliesFlightSegment
     */
    public function setFlightSegmentLegs(\ArrayType\ArrayOfAirFareFamiliesFlightSegmentLeg $flightSegmentLegs = null)
    {
        if (is_null($flightSegmentLegs) || (is_array($flightSegmentLegs) && empty($flightSegmentLegs))) {
            unset($this->FlightSegmentLegs);
        } else {
            $this->FlightSegmentLegs = $flightSegmentLegs;
        }
        return $this;
    }
}
