<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirCreditCard StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de la tarjeta de credito para el pago de reservas LowCost
 * - nillable: true
 * - type: tns:AirCreditCard
 * @subpackage Structs
 */
class AirCreditCard extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Titular
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Numero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The Expiration
     * Meta information extracted from the WSDL
     * - documentation: Caducity
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Expiration;
    /**
     * The CV
     * Meta information extracted from the WSDL
     * - documentation: CV Codigo de verificacion
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CV;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Tipo de Tarjeta para pago de reservas low cost
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for AirCreditCard
     * @uses AirCreditCard::setName()
     * @uses AirCreditCard::setNumber()
     * @uses AirCreditCard::setExpiration()
     * @uses AirCreditCard::setCV()
     * @uses AirCreditCard::setType()
     * @param string $name
     * @param string $number
     * @param string $expiration
     * @param string $cV
     * @param string $type
     */
    public function __construct($name = null, $number = null, $expiration = null, $cV = null, $type = null)
    {
        $this
            ->setName($name)
            ->setNumber($number)
            ->setExpiration($expiration)
            ->setCV($cV)
            ->setType($type);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AirCreditCard
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\AirCreditCard
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get Expiration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiration()
    {
        return isset($this->Expiration) ? $this->Expiration : null;
    }
    /**
     * Set Expiration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiration
     * @return \StructType\AirCreditCard
     */
    public function setExpiration($expiration = null)
    {
        // validation for constraint: string
        if (!is_null($expiration) && !is_string($expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration, true), gettype($expiration)), __LINE__);
        }
        if (is_null($expiration) || (is_array($expiration) && empty($expiration))) {
            unset($this->Expiration);
        } else {
            $this->Expiration = $expiration;
        }
        return $this;
    }
    /**
     * Get CV value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCV()
    {
        return isset($this->CV) ? $this->CV : null;
    }
    /**
     * Set CV value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cV
     * @return \StructType\AirCreditCard
     */
    public function setCV($cV = null)
    {
        // validation for constraint: string
        if (!is_null($cV) && !is_string($cV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cV, true), gettype($cV)), __LINE__);
        }
        if (is_null($cV) || (is_array($cV) && empty($cV))) {
            unset($this->CV);
        } else {
            $this->CV = $cV;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\Enums_LowCostPaymentCardType::valueIsValid()
     * @uses \EnumType\Enums_LowCostPaymentCardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\AirCreditCard
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_LowCostPaymentCardType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_LowCostPaymentCardType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\Enums_LowCostPaymentCardType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
