<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirCalendarCombination StructType
 * Meta information extracted from the WSDL
 * - documentation: Estructura que almacenará datos de combinaciones posibles para una busqueda en modo calendario
 * - nillable: true
 * - type: tns:AirCalendarCombination
 * @subpackage Structs
 */
class AirCalendarCombination extends AbstractStructBase
{
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único del grupo de precios al que pertenece esta combinación
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupID;
    /**
     * The GoingDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha del vuelo de ida (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoingDate;
    /**
     * The ReturnDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha del vuelo de regreso (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReturnDate;
    /**
     * The GoingItineraryID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único del itineario de ida
     * - minOccurs: 0
     * @var int
     */
    public $GoingItineraryID;
    /**
     * The ReturnItineraryID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único del itinerario de vuelta en caso de existir
     * - minOccurs: 0
     * @var int
     */
    public $ReturnItineraryID;
    /**
     * The AgencyFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Fee agencia por billete emitido
     * - minOccurs: 0
     * @var float
     */
    public $AgencyFeeAmount;
    /**
     * The AramixFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Fee de aramix por billete emitido
     * - minOccurs: 0
     * @var float
     */
    public $AramixFeeAmount;
    /**
     * The TicketAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total del billete sin tasas ni fee OBSOLETO: Para obtener el precio, se debe obtener desde los campos de AirPricingGroups &gt;&gt; AirPricingGroup &gt;&gt; AdultTicketAmount + AdultTaxAmount + AramixFeeAmount (ejemplo para
     * adulto)
     * - minOccurs: 0
     * @var float
     */
    public $TicketAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total de las tasas OBSOLETO: Para obtener el precio, se debe obtener desde los campos de AirPricingGroups &gt;&gt; AirPricingGroup &gt;&gt; AdultTicketAmount + AdultTaxAmount + AramixFeeAmount (ejemplo para adulto)
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total de la suma de billetes, tasas y fees. OBSOLETO: Para obtener el precio, se debe obtener desde los campos de AirPricingGroups &gt;&gt; AirPricingGroup &gt;&gt; AdultTicketAmount + AdultTaxAmount + AramixFeeAmount (ejemplo
     * para adulto)
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * Constructor method for AirCalendarCombination
     * @uses AirCalendarCombination::setPricingGroupID()
     * @uses AirCalendarCombination::setGoingDate()
     * @uses AirCalendarCombination::setReturnDate()
     * @uses AirCalendarCombination::setGoingItineraryID()
     * @uses AirCalendarCombination::setReturnItineraryID()
     * @uses AirCalendarCombination::setAgencyFeeAmount()
     * @uses AirCalendarCombination::setAramixFeeAmount()
     * @uses AirCalendarCombination::setTicketAmount()
     * @uses AirCalendarCombination::setTaxAmount()
     * @uses AirCalendarCombination::setTotalAmount()
     * @param int $pricingGroupID
     * @param string $goingDate
     * @param string $returnDate
     * @param int $goingItineraryID
     * @param int $returnItineraryID
     * @param float $agencyFeeAmount
     * @param float $aramixFeeAmount
     * @param float $ticketAmount
     * @param float $taxAmount
     * @param float $totalAmount
     */
    public function __construct($pricingGroupID = null, $goingDate = null, $returnDate = null, $goingItineraryID = null, $returnItineraryID = null, $agencyFeeAmount = null, $aramixFeeAmount = null, $ticketAmount = null, $taxAmount = null, $totalAmount = null)
    {
        $this
            ->setPricingGroupID($pricingGroupID)
            ->setGoingDate($goingDate)
            ->setReturnDate($returnDate)
            ->setGoingItineraryID($goingItineraryID)
            ->setReturnItineraryID($returnItineraryID)
            ->setAgencyFeeAmount($agencyFeeAmount)
            ->setAramixFeeAmount($aramixFeeAmount)
            ->setTicketAmount($ticketAmount)
            ->setTaxAmount($taxAmount)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirCalendarCombination
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get GoingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoingDate()
    {
        return isset($this->GoingDate) ? $this->GoingDate : null;
    }
    /**
     * Set GoingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goingDate
     * @return \StructType\AirCalendarCombination
     */
    public function setGoingDate($goingDate = null)
    {
        // validation for constraint: string
        if (!is_null($goingDate) && !is_string($goingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goingDate, true), gettype($goingDate)), __LINE__);
        }
        if (is_null($goingDate) || (is_array($goingDate) && empty($goingDate))) {
            unset($this->GoingDate);
        } else {
            $this->GoingDate = $goingDate;
        }
        return $this;
    }
    /**
     * Get ReturnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnDate()
    {
        return isset($this->ReturnDate) ? $this->ReturnDate : null;
    }
    /**
     * Set ReturnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnDate
     * @return \StructType\AirCalendarCombination
     */
    public function setReturnDate($returnDate = null)
    {
        // validation for constraint: string
        if (!is_null($returnDate) && !is_string($returnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnDate, true), gettype($returnDate)), __LINE__);
        }
        if (is_null($returnDate) || (is_array($returnDate) && empty($returnDate))) {
            unset($this->ReturnDate);
        } else {
            $this->ReturnDate = $returnDate;
        }
        return $this;
    }
    /**
     * Get GoingItineraryID value
     * @return int|null
     */
    public function getGoingItineraryID()
    {
        return $this->GoingItineraryID;
    }
    /**
     * Set GoingItineraryID value
     * @param int $goingItineraryID
     * @return \StructType\AirCalendarCombination
     */
    public function setGoingItineraryID($goingItineraryID = null)
    {
        // validation for constraint: int
        if (!is_null($goingItineraryID) && !(is_int($goingItineraryID) || ctype_digit($goingItineraryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($goingItineraryID, true), gettype($goingItineraryID)), __LINE__);
        }
        $this->GoingItineraryID = $goingItineraryID;
        return $this;
    }
    /**
     * Get ReturnItineraryID value
     * @return int|null
     */
    public function getReturnItineraryID()
    {
        return $this->ReturnItineraryID;
    }
    /**
     * Set ReturnItineraryID value
     * @param int $returnItineraryID
     * @return \StructType\AirCalendarCombination
     */
    public function setReturnItineraryID($returnItineraryID = null)
    {
        // validation for constraint: int
        if (!is_null($returnItineraryID) && !(is_int($returnItineraryID) || ctype_digit($returnItineraryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnItineraryID, true), gettype($returnItineraryID)), __LINE__);
        }
        $this->ReturnItineraryID = $returnItineraryID;
        return $this;
    }
    /**
     * Get AgencyFeeAmount value
     * @return float|null
     */
    public function getAgencyFeeAmount()
    {
        return $this->AgencyFeeAmount;
    }
    /**
     * Set AgencyFeeAmount value
     * @param float $agencyFeeAmount
     * @return \StructType\AirCalendarCombination
     */
    public function setAgencyFeeAmount($agencyFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($agencyFeeAmount) && !(is_float($agencyFeeAmount) || is_numeric($agencyFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agencyFeeAmount, true), gettype($agencyFeeAmount)), __LINE__);
        }
        $this->AgencyFeeAmount = $agencyFeeAmount;
        return $this;
    }
    /**
     * Get AramixFeeAmount value
     * @return float|null
     */
    public function getAramixFeeAmount()
    {
        return $this->AramixFeeAmount;
    }
    /**
     * Set AramixFeeAmount value
     * @param float $aramixFeeAmount
     * @return \StructType\AirCalendarCombination
     */
    public function setAramixFeeAmount($aramixFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($aramixFeeAmount) && !(is_float($aramixFeeAmount) || is_numeric($aramixFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aramixFeeAmount, true), gettype($aramixFeeAmount)), __LINE__);
        }
        $this->AramixFeeAmount = $aramixFeeAmount;
        return $this;
    }
    /**
     * Get TicketAmount value
     * @return float|null
     */
    public function getTicketAmount()
    {
        return $this->TicketAmount;
    }
    /**
     * Set TicketAmount value
     * @param float $ticketAmount
     * @return \StructType\AirCalendarCombination
     */
    public function setTicketAmount($ticketAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ticketAmount) && !(is_float($ticketAmount) || is_numeric($ticketAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ticketAmount, true), gettype($ticketAmount)), __LINE__);
        }
        $this->TicketAmount = $ticketAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\AirCalendarCombination
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\AirCalendarCombination
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
}
