<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingTicketingRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con el resultado de la llamada de petición de emisitón de los billetes de una reserva
 * - nillable: true
 * - type: tns:AirBookingTicketingRS
 * @subpackage Structs
 */
class AirBookingTicketingRS extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de la reserva en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda a partir del cual estamos generando esta reserva
     * - minOccurs: 0
     * @var int
     */
    public $AvailRequestID;
    /**
     * The UniversalBookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador UniversalRecordLocator
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UniversalBookingReference;
    /**
     * The BookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador en el proveedor de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingReference;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Compañia Validadora
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The BookingAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de la reserva Actual
     * - minOccurs: 0
     * @var float
     */
    public $BookingAmount;
    /**
     * The ManagementFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Fees aplicados a la reserva
     * - minOccurs: 0
     * @var float
     */
    public $ManagementFeeAmount;
    /**
     * The AramixFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Fee Aramix por billete
     * - minOccurs: 0
     * @var float
     */
    public $AramixFeeAmount;
    /**
     * The GdsFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Fee que se informa a amadeus a la hora de establecer la forma de pago
     * - minOccurs: 0
     * @var float
     */
    public $GdsFeeAmount;
    /**
     * The BookingDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha de la reserva (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingDateTime;
    /**
     * The AmountDifference
     * Meta information extracted from the WSDL
     * - documentation: Si al retarificar se produce un cambio del importe de la reserva se especificará aquí
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifference;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de crear, editar o cancelar la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: Lista de warnings devueltos por el motor. No implican error y deberían mostrarse en la interfaz de usuario
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWarning
     */
    public $Warnings;
    /**
     * The AirBookingFlightSegments
     * Meta information extracted from the WSDL
     * - documentation: Lista de segmentos de vuelo que componen la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFlightSegment
     */
    public $AirBookingFlightSegments;
    /**
     * The AirTravelers
     * Meta information extracted from the WSDL
     * - documentation: Lista de pasajeros que componen la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTraveler
     */
    public $AirTravelers;
    /**
     * The FlightTickets
     * Meta information extracted from the WSDL
     * - documentation: Lista de los billetes emitidos, de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirFlightTicket
     */
    public $FlightTickets;
    /**
     * The TravelersInfoFares
     * Meta information extracted from the WSDL
     * - documentation: Lista con las distintas tarifas por tipo de pasajeros
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFare
     */
    public $TravelersInfoFares;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - documentation: Clase con los datos para emitir y que contendrá los datos del seguro emitido
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingInsurance
     */
    public $Insurance;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al metodo invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * The BookingStatus
     * Meta information extracted from the WSDL
     * - documentation: Codigo de estado de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingStatus;
    /**
     * The CabinBaggageTravelfusion
     * Meta information extracted from the WSDL
     * - documentation: Para el caso de que se haya seleccionado equipaje de mano y particularmente para Ryanair En esta propiedad, se almacena la opción seleccionada y es para toda la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingBaggageLowCostTf
     */
    public $CabinBaggageTravelfusion;
    /**
     * The AlternativeBookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador alternativo en reservas NDC
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativeBookingReference;
    /**
     * Constructor method for AirBookingTicketingRS
     * @uses AirBookingTicketingRS::setBookingID()
     * @uses AirBookingTicketingRS::setAvailRequestID()
     * @uses AirBookingTicketingRS::setUniversalBookingReference()
     * @uses AirBookingTicketingRS::setBookingReference()
     * @uses AirBookingTicketingRS::setMarketingCarrierCode()
     * @uses AirBookingTicketingRS::setBookingAmount()
     * @uses AirBookingTicketingRS::setManagementFeeAmount()
     * @uses AirBookingTicketingRS::setAramixFeeAmount()
     * @uses AirBookingTicketingRS::setGdsFeeAmount()
     * @uses AirBookingTicketingRS::setBookingDateTime()
     * @uses AirBookingTicketingRS::setAmountDifference()
     * @uses AirBookingTicketingRS::setError()
     * @uses AirBookingTicketingRS::setWarnings()
     * @uses AirBookingTicketingRS::setAirBookingFlightSegments()
     * @uses AirBookingTicketingRS::setAirTravelers()
     * @uses AirBookingTicketingRS::setFlightTickets()
     * @uses AirBookingTicketingRS::setTravelersInfoFares()
     * @uses AirBookingTicketingRS::setInsurance()
     * @uses AirBookingTicketingRS::setRequestID()
     * @uses AirBookingTicketingRS::setBookingStatus()
     * @uses AirBookingTicketingRS::setCabinBaggageTravelfusion()
     * @uses AirBookingTicketingRS::setAlternativeBookingReference()
     * @param int $bookingID
     * @param int $availRequestID
     * @param string $universalBookingReference
     * @param string $bookingReference
     * @param string $marketingCarrierCode
     * @param float $bookingAmount
     * @param float $managementFeeAmount
     * @param float $aramixFeeAmount
     * @param float $gdsFeeAmount
     * @param string $bookingDateTime
     * @param float $amountDifference
     * @param \StructType\ResponseError $error
     * @param \ArrayType\ArrayOfWarning $warnings
     * @param \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments
     * @param \ArrayType\ArrayOfAirTraveler $airTravelers
     * @param \ArrayType\ArrayOfAirFlightTicket $flightTickets
     * @param \ArrayType\ArrayOfAirBookingFare $travelersInfoFares
     * @param \StructType\AirBookingInsurance $insurance
     * @param int $requestID
     * @param string $bookingStatus
     * @param \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion
     * @param string $alternativeBookingReference
     */
    public function __construct($bookingID = null, $availRequestID = null, $universalBookingReference = null, $bookingReference = null, $marketingCarrierCode = null, $bookingAmount = null, $managementFeeAmount = null, $aramixFeeAmount = null, $gdsFeeAmount = null, $bookingDateTime = null, $amountDifference = null, \StructType\ResponseError $error = null, \ArrayType\ArrayOfWarning $warnings = null, \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments = null, \ArrayType\ArrayOfAirTraveler $airTravelers = null, \ArrayType\ArrayOfAirFlightTicket $flightTickets = null, \ArrayType\ArrayOfAirBookingFare $travelersInfoFares = null, \StructType\AirBookingInsurance $insurance = null, $requestID = null, $bookingStatus = null, \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion = null, $alternativeBookingReference = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setAvailRequestID($availRequestID)
            ->setUniversalBookingReference($universalBookingReference)
            ->setBookingReference($bookingReference)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setBookingAmount($bookingAmount)
            ->setManagementFeeAmount($managementFeeAmount)
            ->setAramixFeeAmount($aramixFeeAmount)
            ->setGdsFeeAmount($gdsFeeAmount)
            ->setBookingDateTime($bookingDateTime)
            ->setAmountDifference($amountDifference)
            ->setError($error)
            ->setWarnings($warnings)
            ->setAirBookingFlightSegments($airBookingFlightSegments)
            ->setAirTravelers($airTravelers)
            ->setFlightTickets($flightTickets)
            ->setTravelersInfoFares($travelersInfoFares)
            ->setInsurance($insurance)
            ->setRequestID($requestID)
            ->setBookingStatus($bookingStatus)
            ->setCabinBaggageTravelfusion($cabinBaggageTravelfusion)
            ->setAlternativeBookingReference($alternativeBookingReference);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingTicketingRS
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirBookingTicketingRS
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get UniversalBookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUniversalBookingReference()
    {
        return isset($this->UniversalBookingReference) ? $this->UniversalBookingReference : null;
    }
    /**
     * Set UniversalBookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $universalBookingReference
     * @return \StructType\AirBookingTicketingRS
     */
    public function setUniversalBookingReference($universalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($universalBookingReference) && !is_string($universalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($universalBookingReference, true), gettype($universalBookingReference)), __LINE__);
        }
        if (is_null($universalBookingReference) || (is_array($universalBookingReference) && empty($universalBookingReference))) {
            unset($this->UniversalBookingReference);
        } else {
            $this->UniversalBookingReference = $universalBookingReference;
        }
        return $this;
    }
    /**
     * Get BookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingReference()
    {
        return isset($this->BookingReference) ? $this->BookingReference : null;
    }
    /**
     * Set BookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingReference
     * @return \StructType\AirBookingTicketingRS
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        if (is_null($bookingReference) || (is_array($bookingReference) && empty($bookingReference))) {
            unset($this->BookingReference);
        } else {
            $this->BookingReference = $bookingReference;
        }
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return isset($this->MarketingCarrierCode) ? $this->MarketingCarrierCode : null;
    }
    /**
     * Set MarketingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingCarrierCode
     * @return \StructType\AirBookingTicketingRS
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        if (is_null($marketingCarrierCode) || (is_array($marketingCarrierCode) && empty($marketingCarrierCode))) {
            unset($this->MarketingCarrierCode);
        } else {
            $this->MarketingCarrierCode = $marketingCarrierCode;
        }
        return $this;
    }
    /**
     * Get BookingAmount value
     * @return float|null
     */
    public function getBookingAmount()
    {
        return $this->BookingAmount;
    }
    /**
     * Set BookingAmount value
     * @param float $bookingAmount
     * @return \StructType\AirBookingTicketingRS
     */
    public function setBookingAmount($bookingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bookingAmount) && !(is_float($bookingAmount) || is_numeric($bookingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingAmount, true), gettype($bookingAmount)), __LINE__);
        }
        $this->BookingAmount = $bookingAmount;
        return $this;
    }
    /**
     * Get ManagementFeeAmount value
     * @return float|null
     */
    public function getManagementFeeAmount()
    {
        return $this->ManagementFeeAmount;
    }
    /**
     * Set ManagementFeeAmount value
     * @param float $managementFeeAmount
     * @return \StructType\AirBookingTicketingRS
     */
    public function setManagementFeeAmount($managementFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($managementFeeAmount) && !(is_float($managementFeeAmount) || is_numeric($managementFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($managementFeeAmount, true), gettype($managementFeeAmount)), __LINE__);
        }
        $this->ManagementFeeAmount = $managementFeeAmount;
        return $this;
    }
    /**
     * Get AramixFeeAmount value
     * @return float|null
     */
    public function getAramixFeeAmount()
    {
        return $this->AramixFeeAmount;
    }
    /**
     * Set AramixFeeAmount value
     * @param float $aramixFeeAmount
     * @return \StructType\AirBookingTicketingRS
     */
    public function setAramixFeeAmount($aramixFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($aramixFeeAmount) && !(is_float($aramixFeeAmount) || is_numeric($aramixFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aramixFeeAmount, true), gettype($aramixFeeAmount)), __LINE__);
        }
        $this->AramixFeeAmount = $aramixFeeAmount;
        return $this;
    }
    /**
     * Get GdsFeeAmount value
     * @return float|null
     */
    public function getGdsFeeAmount()
    {
        return $this->GdsFeeAmount;
    }
    /**
     * Set GdsFeeAmount value
     * @param float $gdsFeeAmount
     * @return \StructType\AirBookingTicketingRS
     */
    public function setGdsFeeAmount($gdsFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($gdsFeeAmount) && !(is_float($gdsFeeAmount) || is_numeric($gdsFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gdsFeeAmount, true), gettype($gdsFeeAmount)), __LINE__);
        }
        $this->GdsFeeAmount = $gdsFeeAmount;
        return $this;
    }
    /**
     * Get BookingDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingDateTime()
    {
        return isset($this->BookingDateTime) ? $this->BookingDateTime : null;
    }
    /**
     * Set BookingDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingDateTime
     * @return \StructType\AirBookingTicketingRS
     */
    public function setBookingDateTime($bookingDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateTime) && !is_string($bookingDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateTime, true), gettype($bookingDateTime)), __LINE__);
        }
        if (is_null($bookingDateTime) || (is_array($bookingDateTime) && empty($bookingDateTime))) {
            unset($this->BookingDateTime);
        } else {
            $this->BookingDateTime = $bookingDateTime;
        }
        return $this;
    }
    /**
     * Get AmountDifference value
     * @return float|null
     */
    public function getAmountDifference()
    {
        return $this->AmountDifference;
    }
    /**
     * Set AmountDifference value
     * @param float $amountDifference
     * @return \StructType\AirBookingTicketingRS
     */
    public function setAmountDifference($amountDifference = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifference) && !(is_float($amountDifference) || is_numeric($amountDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifference, true), gettype($amountDifference)), __LINE__);
        }
        $this->AmountDifference = $amountDifference;
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingTicketingRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWarning|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWarning $warnings
     * @return \StructType\AirBookingTicketingRS
     */
    public function setWarnings(\ArrayType\ArrayOfWarning $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get AirBookingFlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFlightSegment|null
     */
    public function getAirBookingFlightSegments()
    {
        return isset($this->AirBookingFlightSegments) ? $this->AirBookingFlightSegments : null;
    }
    /**
     * Set AirBookingFlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments
     * @return \StructType\AirBookingTicketingRS
     */
    public function setAirBookingFlightSegments(\ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments = null)
    {
        if (is_null($airBookingFlightSegments) || (is_array($airBookingFlightSegments) && empty($airBookingFlightSegments))) {
            unset($this->AirBookingFlightSegments);
        } else {
            $this->AirBookingFlightSegments = $airBookingFlightSegments;
        }
        return $this;
    }
    /**
     * Get AirTravelers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTraveler|null
     */
    public function getAirTravelers()
    {
        return isset($this->AirTravelers) ? $this->AirTravelers : null;
    }
    /**
     * Set AirTravelers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTraveler $airTravelers
     * @return \StructType\AirBookingTicketingRS
     */
    public function setAirTravelers(\ArrayType\ArrayOfAirTraveler $airTravelers = null)
    {
        if (is_null($airTravelers) || (is_array($airTravelers) && empty($airTravelers))) {
            unset($this->AirTravelers);
        } else {
            $this->AirTravelers = $airTravelers;
        }
        return $this;
    }
    /**
     * Get FlightTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirFlightTicket|null
     */
    public function getFlightTickets()
    {
        return isset($this->FlightTickets) ? $this->FlightTickets : null;
    }
    /**
     * Set FlightTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirFlightTicket $flightTickets
     * @return \StructType\AirBookingTicketingRS
     */
    public function setFlightTickets(\ArrayType\ArrayOfAirFlightTicket $flightTickets = null)
    {
        if (is_null($flightTickets) || (is_array($flightTickets) && empty($flightTickets))) {
            unset($this->FlightTickets);
        } else {
            $this->FlightTickets = $flightTickets;
        }
        return $this;
    }
    /**
     * Get TravelersInfoFares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFare|null
     */
    public function getTravelersInfoFares()
    {
        return isset($this->TravelersInfoFares) ? $this->TravelersInfoFares : null;
    }
    /**
     * Set TravelersInfoFares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFare $travelersInfoFares
     * @return \StructType\AirBookingTicketingRS
     */
    public function setTravelersInfoFares(\ArrayType\ArrayOfAirBookingFare $travelersInfoFares = null)
    {
        if (is_null($travelersInfoFares) || (is_array($travelersInfoFares) && empty($travelersInfoFares))) {
            unset($this->TravelersInfoFares);
        } else {
            $this->TravelersInfoFares = $travelersInfoFares;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingInsurance|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingInsurance $insurance
     * @return \StructType\AirBookingTicketingRS
     */
    public function setInsurance(\StructType\AirBookingInsurance $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirBookingTicketingRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get BookingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingStatus()
    {
        return isset($this->BookingStatus) ? $this->BookingStatus : null;
    }
    /**
     * Set BookingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingStatus
     * @return \StructType\AirBookingTicketingRS
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bookingStatus) && !is_string($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingStatus, true), gettype($bookingStatus)), __LINE__);
        }
        if (is_null($bookingStatus) || (is_array($bookingStatus) && empty($bookingStatus))) {
            unset($this->BookingStatus);
        } else {
            $this->BookingStatus = $bookingStatus;
        }
        return $this;
    }
    /**
     * Get CabinBaggageTravelfusion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingBaggageLowCostTf|null
     */
    public function getCabinBaggageTravelfusion()
    {
        return isset($this->CabinBaggageTravelfusion) ? $this->CabinBaggageTravelfusion : null;
    }
    /**
     * Set CabinBaggageTravelfusion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion
     * @return \StructType\AirBookingTicketingRS
     */
    public function setCabinBaggageTravelfusion(\StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion = null)
    {
        if (is_null($cabinBaggageTravelfusion) || (is_array($cabinBaggageTravelfusion) && empty($cabinBaggageTravelfusion))) {
            unset($this->CabinBaggageTravelfusion);
        } else {
            $this->CabinBaggageTravelfusion = $cabinBaggageTravelfusion;
        }
        return $this;
    }
    /**
     * Get AlternativeBookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativeBookingReference()
    {
        return isset($this->AlternativeBookingReference) ? $this->AlternativeBookingReference : null;
    }
    /**
     * Set AlternativeBookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativeBookingReference
     * @return \StructType\AirBookingTicketingRS
     */
    public function setAlternativeBookingReference($alternativeBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeBookingReference) && !is_string($alternativeBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternativeBookingReference, true), gettype($alternativeBookingReference)), __LINE__);
        }
        if (is_null($alternativeBookingReference) || (is_array($alternativeBookingReference) && empty($alternativeBookingReference))) {
            unset($this->AlternativeBookingReference);
        } else {
            $this->AlternativeBookingReference = $alternativeBookingReference;
        }
        return $this;
    }
}
