<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingSearchItem StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos de cada una de las reservas encontradas en la búsqueda
 * - nillable: true
 * - type: tns:AirBookingSearchItem
 * @subpackage Structs
 */
class AirBookingSearchItem extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la reseva
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The IATA
     * Meta information extracted from the WSDL
     * - documentation: Codigo de la Aerolinea
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IATA;
    /**
     * The BookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador en el proveedor de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingReference;
    /**
     * The BookingStatus
     * Meta information extracted from the WSDL
     * - documentation: Estado de la Reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingStatus;
    /**
     * The BookingDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de la Reserva (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingDateTime;
    /**
     * The DeadLineDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha limite de la reserva (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeadLineDate;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total de la Reserva
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * The CancellationInsuranceAmount
     * Meta information extracted from the WSDL
     * - documentation: Impore del seguro de cancelacion
     * - minOccurs: 0
     * @var float
     */
    public $CancellationInsuranceAmount;
    /**
     * The CancellationInsurance
     * Meta information extracted from the WSDL
     * - documentation: Indica si tiene o no seguro de cancelacion
     * - minOccurs: 0
     * @var bool
     */
    public $CancellationInsurance;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - documentation: Forma de pago de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentForm;
    /**
     * The FirstPassenger
     * Meta information extracted from the WSDL
     * - documentation: Primer Pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstPassenger;
    /**
     * Constructor method for AirBookingSearchItem
     * @uses AirBookingSearchItem::setBookingID()
     * @uses AirBookingSearchItem::setIATA()
     * @uses AirBookingSearchItem::setBookingReference()
     * @uses AirBookingSearchItem::setBookingStatus()
     * @uses AirBookingSearchItem::setBookingDateTime()
     * @uses AirBookingSearchItem::setDeadLineDate()
     * @uses AirBookingSearchItem::setTotalAmount()
     * @uses AirBookingSearchItem::setCancellationInsuranceAmount()
     * @uses AirBookingSearchItem::setCancellationInsurance()
     * @uses AirBookingSearchItem::setPaymentForm()
     * @uses AirBookingSearchItem::setFirstPassenger()
     * @param int $bookingID
     * @param string $iATA
     * @param string $bookingReference
     * @param string $bookingStatus
     * @param string $bookingDateTime
     * @param string $deadLineDate
     * @param float $totalAmount
     * @param float $cancellationInsuranceAmount
     * @param bool $cancellationInsurance
     * @param string $paymentForm
     * @param string $firstPassenger
     */
    public function __construct($bookingID = null, $iATA = null, $bookingReference = null, $bookingStatus = null, $bookingDateTime = null, $deadLineDate = null, $totalAmount = null, $cancellationInsuranceAmount = null, $cancellationInsurance = null, $paymentForm = null, $firstPassenger = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setIATA($iATA)
            ->setBookingReference($bookingReference)
            ->setBookingStatus($bookingStatus)
            ->setBookingDateTime($bookingDateTime)
            ->setDeadLineDate($deadLineDate)
            ->setTotalAmount($totalAmount)
            ->setCancellationInsuranceAmount($cancellationInsuranceAmount)
            ->setCancellationInsurance($cancellationInsurance)
            ->setPaymentForm($paymentForm)
            ->setFirstPassenger($firstPassenger);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingSearchItem
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get IATA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIATA()
    {
        return isset($this->IATA) ? $this->IATA : null;
    }
    /**
     * Set IATA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iATA
     * @return \StructType\AirBookingSearchItem
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA, true), gettype($iATA)), __LINE__);
        }
        if (is_null($iATA) || (is_array($iATA) && empty($iATA))) {
            unset($this->IATA);
        } else {
            $this->IATA = $iATA;
        }
        return $this;
    }
    /**
     * Get BookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingReference()
    {
        return isset($this->BookingReference) ? $this->BookingReference : null;
    }
    /**
     * Set BookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingReference
     * @return \StructType\AirBookingSearchItem
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        if (is_null($bookingReference) || (is_array($bookingReference) && empty($bookingReference))) {
            unset($this->BookingReference);
        } else {
            $this->BookingReference = $bookingReference;
        }
        return $this;
    }
    /**
     * Get BookingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingStatus()
    {
        return isset($this->BookingStatus) ? $this->BookingStatus : null;
    }
    /**
     * Set BookingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingStatus
     * @return \StructType\AirBookingSearchItem
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bookingStatus) && !is_string($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingStatus, true), gettype($bookingStatus)), __LINE__);
        }
        if (is_null($bookingStatus) || (is_array($bookingStatus) && empty($bookingStatus))) {
            unset($this->BookingStatus);
        } else {
            $this->BookingStatus = $bookingStatus;
        }
        return $this;
    }
    /**
     * Get BookingDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingDateTime()
    {
        return isset($this->BookingDateTime) ? $this->BookingDateTime : null;
    }
    /**
     * Set BookingDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingDateTime
     * @return \StructType\AirBookingSearchItem
     */
    public function setBookingDateTime($bookingDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateTime) && !is_string($bookingDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateTime, true), gettype($bookingDateTime)), __LINE__);
        }
        if (is_null($bookingDateTime) || (is_array($bookingDateTime) && empty($bookingDateTime))) {
            unset($this->BookingDateTime);
        } else {
            $this->BookingDateTime = $bookingDateTime;
        }
        return $this;
    }
    /**
     * Get DeadLineDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeadLineDate()
    {
        return isset($this->DeadLineDate) ? $this->DeadLineDate : null;
    }
    /**
     * Set DeadLineDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deadLineDate
     * @return \StructType\AirBookingSearchItem
     */
    public function setDeadLineDate($deadLineDate = null)
    {
        // validation for constraint: string
        if (!is_null($deadLineDate) && !is_string($deadLineDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deadLineDate, true), gettype($deadLineDate)), __LINE__);
        }
        if (is_null($deadLineDate) || (is_array($deadLineDate) && empty($deadLineDate))) {
            unset($this->DeadLineDate);
        } else {
            $this->DeadLineDate = $deadLineDate;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\AirBookingSearchItem
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get CancellationInsuranceAmount value
     * @return float|null
     */
    public function getCancellationInsuranceAmount()
    {
        return $this->CancellationInsuranceAmount;
    }
    /**
     * Set CancellationInsuranceAmount value
     * @param float $cancellationInsuranceAmount
     * @return \StructType\AirBookingSearchItem
     */
    public function setCancellationInsuranceAmount($cancellationInsuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationInsuranceAmount) && !(is_float($cancellationInsuranceAmount) || is_numeric($cancellationInsuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationInsuranceAmount, true), gettype($cancellationInsuranceAmount)), __LINE__);
        }
        $this->CancellationInsuranceAmount = $cancellationInsuranceAmount;
        return $this;
    }
    /**
     * Get CancellationInsurance value
     * @return bool|null
     */
    public function getCancellationInsurance()
    {
        return $this->CancellationInsurance;
    }
    /**
     * Set CancellationInsurance value
     * @param bool $cancellationInsurance
     * @return \StructType\AirBookingSearchItem
     */
    public function setCancellationInsurance($cancellationInsurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellationInsurance) && !is_bool($cancellationInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellationInsurance, true), gettype($cancellationInsurance)), __LINE__);
        }
        $this->CancellationInsurance = $cancellationInsurance;
        return $this;
    }
    /**
     * Get PaymentForm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentForm()
    {
        return isset($this->PaymentForm) ? $this->PaymentForm : null;
    }
    /**
     * Set PaymentForm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentForm
     * @return \StructType\AirBookingSearchItem
     */
    public function setPaymentForm($paymentForm = null)
    {
        // validation for constraint: string
        if (!is_null($paymentForm) && !is_string($paymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentForm, true), gettype($paymentForm)), __LINE__);
        }
        if (is_null($paymentForm) || (is_array($paymentForm) && empty($paymentForm))) {
            unset($this->PaymentForm);
        } else {
            $this->PaymentForm = $paymentForm;
        }
        return $this;
    }
    /**
     * Get FirstPassenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstPassenger()
    {
        return isset($this->FirstPassenger) ? $this->FirstPassenger : null;
    }
    /**
     * Set FirstPassenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstPassenger
     * @return \StructType\AirBookingSearchItem
     */
    public function setFirstPassenger($firstPassenger = null)
    {
        // validation for constraint: string
        if (!is_null($firstPassenger) && !is_string($firstPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstPassenger, true), gettype($firstPassenger)), __LINE__);
        }
        if (is_null($firstPassenger) || (is_array($firstPassenger) && empty($firstPassenger))) {
            unset($this->FirstPassenger);
        } else {
            $this->FirstPassenger = $firstPassenger;
        }
        return $this;
    }
}
