<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingPreCheckNDCRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que contiene información de maletas, parámetros obligatorios dependiendo de aerolinea...
 * - nillable: true
 * - type: tns:AirBookingPreCheckNDCRS
 * @subpackage Structs
 */
class AirBookingPreCheckNDCRS extends AbstractStructBase
{
    /**
     * The PreCheckRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al método invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $PreCheckRequestID;
    /**
     * The ListAirBookingBaggage
     * Meta information extracted from the WSDL
     * - documentation: Listado de tipo de equipaje disponible para la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingBaggageNDC
     */
    public $ListAirBookingBaggage;
    /**
     * The EmisionInmediata
     * Meta information extracted from the WSDL
     * - documentation: Informa si la reserva es de Emision Inmediata (Se emitirán los billetes junto al proceso de creación de la reserva)
     * - minOccurs: 0
     * @var bool
     */
    public $EmisionInmediata;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de realizar el prechequeo
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * The RefExterna
     * Meta information extracted from the WSDL
     * - documentation: RefExterna de AirReserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefExterna;
    /**
     * Constructor method for AirBookingPreCheckNDCRS
     * @uses AirBookingPreCheckNDCRS::setPreCheckRequestID()
     * @uses AirBookingPreCheckNDCRS::setListAirBookingBaggage()
     * @uses AirBookingPreCheckNDCRS::setEmisionInmediata()
     * @uses AirBookingPreCheckNDCRS::setError()
     * @uses AirBookingPreCheckNDCRS::setRefExterna()
     * @param int $preCheckRequestID
     * @param \ArrayType\ArrayOfAirBookingBaggageNDC $listAirBookingBaggage
     * @param bool $emisionInmediata
     * @param \StructType\ResponseError $error
     * @param string $refExterna
     */
    public function __construct($preCheckRequestID = null, \ArrayType\ArrayOfAirBookingBaggageNDC $listAirBookingBaggage = null, $emisionInmediata = null, \StructType\ResponseError $error = null, $refExterna = null)
    {
        $this
            ->setPreCheckRequestID($preCheckRequestID)
            ->setListAirBookingBaggage($listAirBookingBaggage)
            ->setEmisionInmediata($emisionInmediata)
            ->setError($error)
            ->setRefExterna($refExterna);
    }
    /**
     * Get PreCheckRequestID value
     * @return int|null
     */
    public function getPreCheckRequestID()
    {
        return $this->PreCheckRequestID;
    }
    /**
     * Set PreCheckRequestID value
     * @param int $preCheckRequestID
     * @return \StructType\AirBookingPreCheckNDCRS
     */
    public function setPreCheckRequestID($preCheckRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($preCheckRequestID) && !(is_int($preCheckRequestID) || ctype_digit($preCheckRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preCheckRequestID, true), gettype($preCheckRequestID)), __LINE__);
        }
        $this->PreCheckRequestID = $preCheckRequestID;
        return $this;
    }
    /**
     * Get ListAirBookingBaggage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingBaggageNDC|null
     */
    public function getListAirBookingBaggage()
    {
        return isset($this->ListAirBookingBaggage) ? $this->ListAirBookingBaggage : null;
    }
    /**
     * Set ListAirBookingBaggage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingBaggageNDC $listAirBookingBaggage
     * @return \StructType\AirBookingPreCheckNDCRS
     */
    public function setListAirBookingBaggage(\ArrayType\ArrayOfAirBookingBaggageNDC $listAirBookingBaggage = null)
    {
        if (is_null($listAirBookingBaggage) || (is_array($listAirBookingBaggage) && empty($listAirBookingBaggage))) {
            unset($this->ListAirBookingBaggage);
        } else {
            $this->ListAirBookingBaggage = $listAirBookingBaggage;
        }
        return $this;
    }
    /**
     * Get EmisionInmediata value
     * @return bool|null
     */
    public function getEmisionInmediata()
    {
        return $this->EmisionInmediata;
    }
    /**
     * Set EmisionInmediata value
     * @param bool $emisionInmediata
     * @return \StructType\AirBookingPreCheckNDCRS
     */
    public function setEmisionInmediata($emisionInmediata = null)
    {
        // validation for constraint: boolean
        if (!is_null($emisionInmediata) && !is_bool($emisionInmediata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emisionInmediata, true), gettype($emisionInmediata)), __LINE__);
        }
        $this->EmisionInmediata = $emisionInmediata;
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingPreCheckNDCRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get RefExterna value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefExterna()
    {
        return isset($this->RefExterna) ? $this->RefExterna : null;
    }
    /**
     * Set RefExterna value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refExterna
     * @return \StructType\AirBookingPreCheckNDCRS
     */
    public function setRefExterna($refExterna = null)
    {
        // validation for constraint: string
        if (!is_null($refExterna) && !is_string($refExterna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refExterna, true), gettype($refExterna)), __LINE__);
        }
        if (is_null($refExterna) || (is_array($refExterna) && empty($refExterna))) {
            unset($this->RefExterna);
        } else {
            $this->RefExterna = $refExterna;
        }
        return $this;
    }
}
