<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingPreCheckNDC StructType
 * @subpackage Structs
 */
class AirBookingPreCheckNDC extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The abPrecheckRQ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingPreCheckNDCRQ
     */
    public $abPrecheckRQ;
    /**
     * Constructor method for AirBookingPreCheckNDC
     * @uses AirBookingPreCheckNDC::setCredentials()
     * @uses AirBookingPreCheckNDC::setAbPrecheckRQ()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param \StructType\AirBookingPreCheckNDCRQ $abPrecheckRQ
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, \StructType\AirBookingPreCheckNDCRQ $abPrecheckRQ = null)
    {
        $this
            ->setCredentials($credentials)
            ->setAbPrecheckRQ($abPrecheckRQ);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingPreCheckNDC
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get abPrecheckRQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingPreCheckNDCRQ|null
     */
    public function getAbPrecheckRQ()
    {
        return isset($this->abPrecheckRQ) ? $this->abPrecheckRQ : null;
    }
    /**
     * Set abPrecheckRQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingPreCheckNDCRQ $abPrecheckRQ
     * @return \StructType\AirBookingPreCheckNDC
     */
    public function setAbPrecheckRQ(\StructType\AirBookingPreCheckNDCRQ $abPrecheckRQ = null)
    {
        if (is_null($abPrecheckRQ) || (is_array($abPrecheckRQ) && empty($abPrecheckRQ))) {
            unset($this->abPrecheckRQ);
        } else {
            $this->abPrecheckRQ = $abPrecheckRQ;
        }
        return $this;
    }
}
