<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingInsurance StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos necesarios para la emision del seguro.
 * - nillable: true
 * - type: tns:AirBookingInsurance
 * @subpackage Structs
 */
class AirBookingInsurance extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de la reserva en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda a partir del cual estamos generando esta reserva
     * - minOccurs: 0
     * @var int
     */
    public $AvailRequestID;
    /**
     * The BookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador en el proveedor de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingReference;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha de salida (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The TicketsIssuedDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha de Emision de los billetes (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketsIssuedDateTime;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Importe de la reserva
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del seguro de cancelacion
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de crear, editar o cancelar la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * The InsurancePolicy
     * Meta information extracted from the WSDL
     * - documentation: Poliza del Seguro
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirInsurancePolicy
     */
    public $InsurancePolicy;
    /**
     * Constructor method for AirBookingInsurance
     * @uses AirBookingInsurance::setBookingID()
     * @uses AirBookingInsurance::setAvailRequestID()
     * @uses AirBookingInsurance::setBookingReference()
     * @uses AirBookingInsurance::setDepartureDateTime()
     * @uses AirBookingInsurance::setTicketsIssuedDateTime()
     * @uses AirBookingInsurance::setAmount()
     * @uses AirBookingInsurance::setInsuranceAmount()
     * @uses AirBookingInsurance::setError()
     * @uses AirBookingInsurance::setInsurancePolicy()
     * @param int $bookingID
     * @param int $availRequestID
     * @param string $bookingReference
     * @param string $departureDateTime
     * @param string $ticketsIssuedDateTime
     * @param float $amount
     * @param float $insuranceAmount
     * @param \StructType\ResponseError $error
     * @param \StructType\AirInsurancePolicy $insurancePolicy
     */
    public function __construct($bookingID = null, $availRequestID = null, $bookingReference = null, $departureDateTime = null, $ticketsIssuedDateTime = null, $amount = null, $insuranceAmount = null, \StructType\ResponseError $error = null, \StructType\AirInsurancePolicy $insurancePolicy = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setAvailRequestID($availRequestID)
            ->setBookingReference($bookingReference)
            ->setDepartureDateTime($departureDateTime)
            ->setTicketsIssuedDateTime($ticketsIssuedDateTime)
            ->setAmount($amount)
            ->setInsuranceAmount($insuranceAmount)
            ->setError($error)
            ->setInsurancePolicy($insurancePolicy);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingInsurance
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirBookingInsurance
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get BookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingReference()
    {
        return isset($this->BookingReference) ? $this->BookingReference : null;
    }
    /**
     * Set BookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingReference
     * @return \StructType\AirBookingInsurance
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        if (is_null($bookingReference) || (is_array($bookingReference) && empty($bookingReference))) {
            unset($this->BookingReference);
        } else {
            $this->BookingReference = $bookingReference;
        }
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * Set DepartureDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDateTime
     * @return \StructType\AirBookingInsurance
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get TicketsIssuedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketsIssuedDateTime()
    {
        return isset($this->TicketsIssuedDateTime) ? $this->TicketsIssuedDateTime : null;
    }
    /**
     * Set TicketsIssuedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketsIssuedDateTime
     * @return \StructType\AirBookingInsurance
     */
    public function setTicketsIssuedDateTime($ticketsIssuedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($ticketsIssuedDateTime) && !is_string($ticketsIssuedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketsIssuedDateTime, true), gettype($ticketsIssuedDateTime)), __LINE__);
        }
        if (is_null($ticketsIssuedDateTime) || (is_array($ticketsIssuedDateTime) && empty($ticketsIssuedDateTime))) {
            unset($this->TicketsIssuedDateTime);
        } else {
            $this->TicketsIssuedDateTime = $ticketsIssuedDateTime;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AirBookingInsurance
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float|null
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \StructType\AirBookingInsurance
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingInsurance
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get InsurancePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirInsurancePolicy|null
     */
    public function getInsurancePolicy()
    {
        return isset($this->InsurancePolicy) ? $this->InsurancePolicy : null;
    }
    /**
     * Set InsurancePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirInsurancePolicy $insurancePolicy
     * @return \StructType\AirBookingInsurance
     */
    public function setInsurancePolicy(\StructType\AirInsurancePolicy $insurancePolicy = null)
    {
        if (is_null($insurancePolicy) || (is_array($insurancePolicy) && empty($insurancePolicy))) {
            unset($this->InsurancePolicy);
        } else {
            $this->InsurancePolicy = $insurancePolicy;
        }
        return $this;
    }
}
