<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingImportRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada para importar una reservas de aereo a nuestro sistema *** No activado para todos los clientes
 * - nillable: true
 * - type: tns:AirBookingImportRQ
 * @subpackage Structs
 */
class AirBookingImportRQ extends AbstractStructBase
{
    /**
     * The AgencyID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la agencia de la reserva a importar
     * - minOccurs: 0
     * @var int
     */
    public $AgencyID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del usuario de la agencia de la reserva a importar
     * - minOccurs: 0
     * @var int
     */
    public $UserID;
    /**
     * The Locator
     * Meta information extracted from the WSDL
     * - documentation: Localizador de la Reserva a importar
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Locator;
    /**
     * Constructor method for AirBookingImportRQ
     * @uses AirBookingImportRQ::setAgencyID()
     * @uses AirBookingImportRQ::setUserID()
     * @uses AirBookingImportRQ::setLocator()
     * @param int $agencyID
     * @param int $userID
     * @param string $locator
     */
    public function __construct($agencyID = null, $userID = null, $locator = null)
    {
        $this
            ->setAgencyID($agencyID)
            ->setUserID($userID)
            ->setLocator($locator);
    }
    /**
     * Get AgencyID value
     * @return int|null
     */
    public function getAgencyID()
    {
        return $this->AgencyID;
    }
    /**
     * Set AgencyID value
     * @param int $agencyID
     * @return \StructType\AirBookingImportRQ
     */
    public function setAgencyID($agencyID = null)
    {
        // validation for constraint: int
        if (!is_null($agencyID) && !(is_int($agencyID) || ctype_digit($agencyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyID, true), gettype($agencyID)), __LINE__);
        }
        $this->AgencyID = $agencyID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\AirBookingImportRQ
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Locator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocator()
    {
        return isset($this->Locator) ? $this->Locator : null;
    }
    /**
     * Set Locator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locator
     * @return \StructType\AirBookingImportRQ
     */
    public function setLocator($locator = null)
    {
        // validation for constraint: string
        if (!is_null($locator) && !is_string($locator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locator, true), gettype($locator)), __LINE__);
        }
        if (is_null($locator) || (is_array($locator) && empty($locator))) {
            unset($this->Locator);
        } else {
            $this->Locator = $locator;
        }
        return $this;
    }
}
