<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingImport StructType
 * @subpackage Structs
 */
class AirBookingImport extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The airBookingImportRQ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingImportRQ
     */
    public $airBookingImportRQ;
    /**
     * Constructor method for AirBookingImport
     * @uses AirBookingImport::setCredentials()
     * @uses AirBookingImport::setAirBookingImportRQ()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param \StructType\AirBookingImportRQ $airBookingImportRQ
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, \StructType\AirBookingImportRQ $airBookingImportRQ = null)
    {
        $this
            ->setCredentials($credentials)
            ->setAirBookingImportRQ($airBookingImportRQ);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingImport
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get airBookingImportRQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingImportRQ|null
     */
    public function getAirBookingImportRQ()
    {
        return isset($this->airBookingImportRQ) ? $this->airBookingImportRQ : null;
    }
    /**
     * Set airBookingImportRQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingImportRQ $airBookingImportRQ
     * @return \StructType\AirBookingImport
     */
    public function setAirBookingImportRQ(\StructType\AirBookingImportRQ $airBookingImportRQ = null)
    {
        if (is_null($airBookingImportRQ) || (is_array($airBookingImportRQ) && empty($airBookingImportRQ))) {
            unset($this->airBookingImportRQ);
        } else {
            $this->airBookingImportRQ = $airBookingImportRQ;
        }
        return $this;
    }
}
