<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingFlightSegmentLeg StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un trayecto de vuelo de un segmento.
 * - nillable: true
 * - type: tns:AirBookingFlightSegmentLeg
 * @subpackage Structs
 */
class AirBookingFlightSegmentLeg extends AbstractStructBase
{
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código del aeropuerto de origen
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código del aeropuerto de destino
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de salida (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de llegada (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: Número de vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The OperatingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Código de la compañia que opera el vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrierCode;
    /**
     * The ArrivalAirportTerminal
     * Meta information extracted from the WSDL
     * - documentation: Terminal del aeropuerto de llegada
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportTerminal;
    /**
     * The DepartureAirportTerminal
     * Meta information extracted from the WSDL
     * - documentation: Terminal del aeropuerto de salida
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportTerminal;
    /**
     * The AircraftType
     * Meta information extracted from the WSDL
     * - documentation: Modelo del avion del vuelo, ejemplo "320" = Airbus 320
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftType;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de cabina, puede ser Economy, Business o Firts Class
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinType;
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - documentation: Clase dentro de la cabina. Está definida por una letra y no hay una regla standar para todas las compañias, para conocer que letra corresponde a que cabina.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClass;
    /**
     * The FareCode
     * Meta information extracted from the WSDL
     * - documentation: El codigo de tarifa con la que se emite la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareCode;
    /**
     * The FareType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de tarifa (pública o negociada)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareType;
    /**
     * The ETicket
     * Meta information extracted from the WSDL
     * - documentation: Indica si permite billete electronico y con los GDS siempre es verdadero
     * - minOccurs: 0
     * @var bool
     */
    public $ETicket;
    /**
     * The AllowedBaggage
     * Meta information extracted from the WSDL
     * - documentation: Equipaje permitido en este vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingAllowedBaggage
     */
    public $AllowedBaggage;
    /**
     * The TechnicalStops
     * Meta information extracted from the WSDL
     * - documentation: Paradas tecnicas del trayecto
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTechnicalStop
     */
    public $TechnicalStops;
    /**
     * The IDAirBookingFlightSegmentLeg
     * Meta information extracted from the WSDL
     * - documentation: Identificador del trayecto
     * - minOccurs: 0
     * @var int
     */
    public $IDAirBookingFlightSegmentLeg;
    /**
     * The EstimatedFlightTime
     * Meta information extracted from the WSDL
     * - documentation: Duracion del vuelo aproximada en minutos
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EstimatedFlightTime;
    /**
     * Constructor method for AirBookingFlightSegmentLeg
     * @uses AirBookingFlightSegmentLeg::setDepartureAirportLocationCode()
     * @uses AirBookingFlightSegmentLeg::setArrivalAirportLocationCode()
     * @uses AirBookingFlightSegmentLeg::setDepartureDateTime()
     * @uses AirBookingFlightSegmentLeg::setArrivalDateTime()
     * @uses AirBookingFlightSegmentLeg::setFlightNumber()
     * @uses AirBookingFlightSegmentLeg::setOperatingCarrierCode()
     * @uses AirBookingFlightSegmentLeg::setArrivalAirportTerminal()
     * @uses AirBookingFlightSegmentLeg::setDepartureAirportTerminal()
     * @uses AirBookingFlightSegmentLeg::setAircraftType()
     * @uses AirBookingFlightSegmentLeg::setCabinType()
     * @uses AirBookingFlightSegmentLeg::setCabinClass()
     * @uses AirBookingFlightSegmentLeg::setFareCode()
     * @uses AirBookingFlightSegmentLeg::setFareType()
     * @uses AirBookingFlightSegmentLeg::setETicket()
     * @uses AirBookingFlightSegmentLeg::setAllowedBaggage()
     * @uses AirBookingFlightSegmentLeg::setTechnicalStops()
     * @uses AirBookingFlightSegmentLeg::setIDAirBookingFlightSegmentLeg()
     * @uses AirBookingFlightSegmentLeg::setEstimatedFlightTime()
     * @param string $departureAirportLocationCode
     * @param string $arrivalAirportLocationCode
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param string $flightNumber
     * @param string $operatingCarrierCode
     * @param string $arrivalAirportTerminal
     * @param string $departureAirportTerminal
     * @param string $aircraftType
     * @param string $cabinType
     * @param string $cabinClass
     * @param string $fareCode
     * @param string $fareType
     * @param bool $eTicket
     * @param \StructType\AirBookingAllowedBaggage $allowedBaggage
     * @param \ArrayType\ArrayOfAirTechnicalStop $technicalStops
     * @param int $iDAirBookingFlightSegmentLeg
     * @param int $estimatedFlightTime
     */
    public function __construct($departureAirportLocationCode = null, $arrivalAirportLocationCode = null, $departureDateTime = null, $arrivalDateTime = null, $flightNumber = null, $operatingCarrierCode = null, $arrivalAirportTerminal = null, $departureAirportTerminal = null, $aircraftType = null, $cabinType = null, $cabinClass = null, $fareCode = null, $fareType = null, $eTicket = null, \StructType\AirBookingAllowedBaggage $allowedBaggage = null, \ArrayType\ArrayOfAirTechnicalStop $technicalStops = null, $iDAirBookingFlightSegmentLeg = null, $estimatedFlightTime = null)
    {
        $this
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFlightNumber($flightNumber)
            ->setOperatingCarrierCode($operatingCarrierCode)
            ->setArrivalAirportTerminal($arrivalAirportTerminal)
            ->setDepartureAirportTerminal($departureAirportTerminal)
            ->setAircraftType($aircraftType)
            ->setCabinType($cabinType)
            ->setCabinClass($cabinClass)
            ->setFareCode($fareCode)
            ->setFareType($fareType)
            ->setETicket($eTicket)
            ->setAllowedBaggage($allowedBaggage)
            ->setTechnicalStops($technicalStops)
            ->setIDAirBookingFlightSegmentLeg($iDAirBookingFlightSegmentLeg)
            ->setEstimatedFlightTime($estimatedFlightTime);
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * Set DepartureDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDateTime
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return isset($this->ArrivalDateTime) ? $this->ArrivalDateTime : null;
    }
    /**
     * Set ArrivalDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalDateTime
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        if (is_null($arrivalDateTime) || (is_array($arrivalDateTime) && empty($arrivalDateTime))) {
            unset($this->ArrivalDateTime);
        } else {
            $this->ArrivalDateTime = $arrivalDateTime;
        }
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get OperatingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrierCode()
    {
        return isset($this->OperatingCarrierCode) ? $this->OperatingCarrierCode : null;
    }
    /**
     * Set OperatingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrierCode
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setOperatingCarrierCode($operatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierCode) && !is_string($operatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierCode, true), gettype($operatingCarrierCode)), __LINE__);
        }
        if (is_null($operatingCarrierCode) || (is_array($operatingCarrierCode) && empty($operatingCarrierCode))) {
            unset($this->OperatingCarrierCode);
        } else {
            $this->OperatingCarrierCode = $operatingCarrierCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportTerminal()
    {
        return isset($this->ArrivalAirportTerminal) ? $this->ArrivalAirportTerminal : null;
    }
    /**
     * Set ArrivalAirportTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportTerminal
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setArrivalAirportTerminal($arrivalAirportTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportTerminal) && !is_string($arrivalAirportTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportTerminal, true), gettype($arrivalAirportTerminal)), __LINE__);
        }
        if (is_null($arrivalAirportTerminal) || (is_array($arrivalAirportTerminal) && empty($arrivalAirportTerminal))) {
            unset($this->ArrivalAirportTerminal);
        } else {
            $this->ArrivalAirportTerminal = $arrivalAirportTerminal;
        }
        return $this;
    }
    /**
     * Get DepartureAirportTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportTerminal()
    {
        return isset($this->DepartureAirportTerminal) ? $this->DepartureAirportTerminal : null;
    }
    /**
     * Set DepartureAirportTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportTerminal
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setDepartureAirportTerminal($departureAirportTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportTerminal) && !is_string($departureAirportTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportTerminal, true), gettype($departureAirportTerminal)), __LINE__);
        }
        if (is_null($departureAirportTerminal) || (is_array($departureAirportTerminal) && empty($departureAirportTerminal))) {
            unset($this->DepartureAirportTerminal);
        } else {
            $this->DepartureAirportTerminal = $departureAirportTerminal;
        }
        return $this;
    }
    /**
     * Get AircraftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftType()
    {
        return isset($this->AircraftType) ? $this->AircraftType : null;
    }
    /**
     * Set AircraftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftType
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setAircraftType($aircraftType = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftType) && !is_string($aircraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftType, true), gettype($aircraftType)), __LINE__);
        }
        if (is_null($aircraftType) || (is_array($aircraftType) && empty($aircraftType))) {
            unset($this->AircraftType);
        } else {
            $this->AircraftType = $aircraftType;
        }
        return $this;
    }
    /**
     * Get CabinType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinType()
    {
        return isset($this->CabinType) ? $this->CabinType : null;
    }
    /**
     * Set CabinType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinType
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: string
        if (!is_null($cabinType) && !is_string($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinType, true), gettype($cabinType)), __LINE__);
        }
        if (is_null($cabinType) || (is_array($cabinType) && empty($cabinType))) {
            unset($this->CabinType);
        } else {
            $this->CabinType = $cabinType;
        }
        return $this;
    }
    /**
     * Get CabinClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClass()
    {
        return isset($this->CabinClass) ? $this->CabinClass : null;
    }
    /**
     * Set CabinClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinClass
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinClass, true), gettype($cabinClass)), __LINE__);
        }
        if (is_null($cabinClass) || (is_array($cabinClass) && empty($cabinClass))) {
            unset($this->CabinClass);
        } else {
            $this->CabinClass = $cabinClass;
        }
        return $this;
    }
    /**
     * Get FareCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareCode()
    {
        return isset($this->FareCode) ? $this->FareCode : null;
    }
    /**
     * Set FareCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareCode
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setFareCode($fareCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareCode) && !is_string($fareCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCode, true), gettype($fareCode)), __LINE__);
        }
        if (is_null($fareCode) || (is_array($fareCode) && empty($fareCode))) {
            unset($this->FareCode);
        } else {
            $this->FareCode = $fareCode;
        }
        return $this;
    }
    /**
     * Get FareType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareType()
    {
        return isset($this->FareType) ? $this->FareType : null;
    }
    /**
     * Set FareType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareType
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareType, true), gettype($fareType)), __LINE__);
        }
        if (is_null($fareType) || (is_array($fareType) && empty($fareType))) {
            unset($this->FareType);
        } else {
            $this->FareType = $fareType;
        }
        return $this;
    }
    /**
     * Get ETicket value
     * @return bool|null
     */
    public function getETicket()
    {
        return $this->ETicket;
    }
    /**
     * Set ETicket value
     * @param bool $eTicket
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setETicket($eTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($eTicket) && !is_bool($eTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eTicket, true), gettype($eTicket)), __LINE__);
        }
        $this->ETicket = $eTicket;
        return $this;
    }
    /**
     * Get AllowedBaggage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingAllowedBaggage|null
     */
    public function getAllowedBaggage()
    {
        return isset($this->AllowedBaggage) ? $this->AllowedBaggage : null;
    }
    /**
     * Set AllowedBaggage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingAllowedBaggage $allowedBaggage
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setAllowedBaggage(\StructType\AirBookingAllowedBaggage $allowedBaggage = null)
    {
        if (is_null($allowedBaggage) || (is_array($allowedBaggage) && empty($allowedBaggage))) {
            unset($this->AllowedBaggage);
        } else {
            $this->AllowedBaggage = $allowedBaggage;
        }
        return $this;
    }
    /**
     * Get TechnicalStops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTechnicalStop|null
     */
    public function getTechnicalStops()
    {
        return isset($this->TechnicalStops) ? $this->TechnicalStops : null;
    }
    /**
     * Set TechnicalStops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTechnicalStop $technicalStops
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setTechnicalStops(\ArrayType\ArrayOfAirTechnicalStop $technicalStops = null)
    {
        if (is_null($technicalStops) || (is_array($technicalStops) && empty($technicalStops))) {
            unset($this->TechnicalStops);
        } else {
            $this->TechnicalStops = $technicalStops;
        }
        return $this;
    }
    /**
     * Get IDAirBookingFlightSegmentLeg value
     * @return int|null
     */
    public function getIDAirBookingFlightSegmentLeg()
    {
        return $this->IDAirBookingFlightSegmentLeg;
    }
    /**
     * Set IDAirBookingFlightSegmentLeg value
     * @param int $iDAirBookingFlightSegmentLeg
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setIDAirBookingFlightSegmentLeg($iDAirBookingFlightSegmentLeg = null)
    {
        // validation for constraint: int
        if (!is_null($iDAirBookingFlightSegmentLeg) && !(is_int($iDAirBookingFlightSegmentLeg) || ctype_digit($iDAirBookingFlightSegmentLeg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAirBookingFlightSegmentLeg, true), gettype($iDAirBookingFlightSegmentLeg)), __LINE__);
        }
        $this->IDAirBookingFlightSegmentLeg = $iDAirBookingFlightSegmentLeg;
        return $this;
    }
    /**
     * Get EstimatedFlightTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEstimatedFlightTime()
    {
        return isset($this->EstimatedFlightTime) ? $this->EstimatedFlightTime : null;
    }
    /**
     * Set EstimatedFlightTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $estimatedFlightTime
     * @return \StructType\AirBookingFlightSegmentLeg
     */
    public function setEstimatedFlightTime($estimatedFlightTime = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedFlightTime) && !(is_int($estimatedFlightTime) || ctype_digit($estimatedFlightTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedFlightTime, true), gettype($estimatedFlightTime)), __LINE__);
        }
        if (is_null($estimatedFlightTime) || (is_array($estimatedFlightTime) && empty($estimatedFlightTime))) {
            unset($this->EstimatedFlightTime);
        } else {
            $this->EstimatedFlightTime = $estimatedFlightTime;
        }
        return $this;
    }
}
