<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingCheckFeeLowCostTf StructType
 * @subpackage Structs
 */
class AirBookingCheckFeeLowCostTf extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The airBookingRQ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingRQ
     */
    public $airBookingRQ;
    /**
     * Constructor method for AirBookingCheckFeeLowCostTf
     * @uses AirBookingCheckFeeLowCostTf::setCredentials()
     * @uses AirBookingCheckFeeLowCostTf::setAirBookingRQ()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param \StructType\AirBookingRQ $airBookingRQ
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, \StructType\AirBookingRQ $airBookingRQ = null)
    {
        $this
            ->setCredentials($credentials)
            ->setAirBookingRQ($airBookingRQ);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingCheckFeeLowCostTf
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get airBookingRQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingRQ|null
     */
    public function getAirBookingRQ()
    {
        return isset($this->airBookingRQ) ? $this->airBookingRQ : null;
    }
    /**
     * Set airBookingRQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingRQ $airBookingRQ
     * @return \StructType\AirBookingCheckFeeLowCostTf
     */
    public function setAirBookingRQ(\StructType\AirBookingRQ $airBookingRQ = null)
    {
        if (is_null($airBookingRQ) || (is_array($airBookingRQ) && empty($airBookingRQ))) {
            unset($this->airBookingRQ);
        } else {
            $this->airBookingRQ = $airBookingRQ;
        }
        return $this;
    }
}
