<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBooking StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una reserva de uno o más billetes aereos
 * - nillable: true
 * - type: tns:AirBooking
 * @subpackage Structs
 */
class AirBooking extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de la reserva en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda a partir del cual estamos generando esta reserva
     * - minOccurs: 0
     * @var int
     */
    public $AvailRequestID;
    /**
     * The BookingRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la peticion al web service que origina la reserva.
     * - minOccurs: 0
     * @var int
     */
    public $BookingRequestID;
    /**
     * The BookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador en el proveedor de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingReference;
    /**
     * The AirTravelers
     * Meta information extracted from the WSDL
     * - documentation: Lista de pasajeros que componen la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTraveler
     */
    public $AirTravelers;
    /**
     * The AirBookingNotes
     * Meta information extracted from the WSDL
     * - documentation: Lista de las notas de tarifas recuperadas junto a la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingNote
     */
    public $AirBookingNotes;
    /**
     * The BookingDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha en que se realiza la reserva (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingDateTime;
    /**
     * The TicketIssueDateLimit
     * Meta information extracted from the WSDL
     * - documentation: Fecha límite de emisión de los billetes de la reserva, informada por el proveedor (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketIssueDateLimit;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Compañia con la que se venden y emiten los billetes de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The CancellationInsurance
     * Meta information extracted from the WSDL
     * - documentation: Indica si se desea contratar el seguro de cancelación junto con la reserva
     * - minOccurs: 0
     * @var bool
     */
    public $CancellationInsurance;
    /**
     * The CancellationInsuranceAmount
     * Meta information extracted from the WSDL
     * - documentation: Indica el importe del seguro de cancelación
     * - minOccurs: 0
     * @var float
     */
    public $CancellationInsuranceAmount;
    /**
     * The AgentEmail
     * Meta information extracted from the WSDL
     * - documentation: Email del agente que recibirá una copia de la reserva en cada cambio de estado
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentEmail;
    /**
     * The DestinationContactPhone
     * Meta information extracted from the WSDL
     * - documentation: Telefono de contacto en destino del pasajero responsable de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationContactPhone;
    /**
     * The BookingStatus
     * Meta information extracted from the WSDL
     * - documentation: Codigo de estado de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingStatus;
    /**
     * The AmountDifference
     * Meta information extracted from the WSDL
     * - documentation: Si al retarificar se produce un cambio del importe de la reserva se especificará aquí
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifference;
    /**
     * The AirBookingFlightSegments
     * Meta information extracted from the WSDL
     * - documentation: Lista de segmentos de vuelo que componen la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFlightSegment
     */
    public $AirBookingFlightSegments;
    /**
     * The TravelersInfoFares
     * Meta information extracted from the WSDL
     * - documentation: Lista con las distintas tarifas por tipo de pasajeros
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFare
     */
    public $TravelersInfoFares;
    /**
     * The FlightTickets
     * Meta information extracted from the WSDL
     * - documentation: Lista de los billetes emitidos, de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirFlightTicket
     */
    public $FlightTickets;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: Lista de warnings devueltos por el motor. No implican error y deberían mostrarse en la interfaz de usuario
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWarning
     */
    public $Warnings;
    /**
     * The TotalAgencyAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total neto agencia para la reserva. Propiedad calculada en base a la suma de precios por pasajero.
     * - minOccurs: 0
     * @var float
     */
    public $TotalAgencyAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total reserva incluido fees. Propiedad calculada en base a la suma de precios por pasajero.
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - documentation: Lista de mensajes devueltos por el motor: Mensaje de Tour Operacion y mensajes por farebasis y aerolinea
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Messages;
    /**
     * The LuggageRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al método dónde se obtienen los equipajes, campos obligatorios dinámicos
     * - minOccurs: 0
     * @var int
     */
    public $LuggageRequestID;
    /**
     * The CabinBaggageTravelfusion
     * Meta information extracted from the WSDL
     * - documentation: Para el caso de que se haya seleccionado equipaje de mano y particularmente para Ryanair En esta propiedad, se almacena la opción seleccionada y es para toda la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingBaggageLowCostTf
     */
    public $CabinBaggageTravelfusion;
    /**
     * The PreCheckNDCIdPeticion
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion a PreCheckNDC
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PreCheckNDCIdPeticion;
    /**
     * The FareFamiliesBooking
     * Meta information extracted from the WSDL
     * - documentation: Indica si se han contratado FareFamilies
     * - minOccurs: 0
     * @var bool
     */
    public $FareFamiliesBooking;
    /**
     * The FareFamiliesDetails
     * Meta information extracted from the WSDL
     * - documentation: Contiene la información de las FareFamilies (descripción de la misma por segmento y servicios asociados)
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFareFamilies
     */
    public $FareFamiliesDetails;
    /**
     * The AlternativeBookingReference
     * Meta information extracted from the WSDL
     * - documentation: Localizador alternativo en reservas NDC
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativeBookingReference;
    /**
     * Constructor method for AirBooking
     * @uses AirBooking::setBookingID()
     * @uses AirBooking::setAvailRequestID()
     * @uses AirBooking::setBookingRequestID()
     * @uses AirBooking::setBookingReference()
     * @uses AirBooking::setAirTravelers()
     * @uses AirBooking::setAirBookingNotes()
     * @uses AirBooking::setBookingDateTime()
     * @uses AirBooking::setTicketIssueDateLimit()
     * @uses AirBooking::setMarketingCarrierCode()
     * @uses AirBooking::setCancellationInsurance()
     * @uses AirBooking::setCancellationInsuranceAmount()
     * @uses AirBooking::setAgentEmail()
     * @uses AirBooking::setDestinationContactPhone()
     * @uses AirBooking::setBookingStatus()
     * @uses AirBooking::setAmountDifference()
     * @uses AirBooking::setAirBookingFlightSegments()
     * @uses AirBooking::setTravelersInfoFares()
     * @uses AirBooking::setFlightTickets()
     * @uses AirBooking::setWarnings()
     * @uses AirBooking::setTotalAgencyAmount()
     * @uses AirBooking::setTotalAmount()
     * @uses AirBooking::setMessages()
     * @uses AirBooking::setLuggageRequestID()
     * @uses AirBooking::setCabinBaggageTravelfusion()
     * @uses AirBooking::setPreCheckNDCIdPeticion()
     * @uses AirBooking::setFareFamiliesBooking()
     * @uses AirBooking::setFareFamiliesDetails()
     * @uses AirBooking::setAlternativeBookingReference()
     * @param int $bookingID
     * @param int $availRequestID
     * @param int $bookingRequestID
     * @param string $bookingReference
     * @param \ArrayType\ArrayOfAirTraveler $airTravelers
     * @param \ArrayType\ArrayOfAirBookingNote $airBookingNotes
     * @param string $bookingDateTime
     * @param string $ticketIssueDateLimit
     * @param string $marketingCarrierCode
     * @param bool $cancellationInsurance
     * @param float $cancellationInsuranceAmount
     * @param string $agentEmail
     * @param string $destinationContactPhone
     * @param string $bookingStatus
     * @param float $amountDifference
     * @param \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments
     * @param \ArrayType\ArrayOfAirBookingFare $travelersInfoFares
     * @param \ArrayType\ArrayOfAirFlightTicket $flightTickets
     * @param \ArrayType\ArrayOfWarning $warnings
     * @param float $totalAgencyAmount
     * @param float $totalAmount
     * @param \ArrayType\ArrayOfstring $messages
     * @param int $luggageRequestID
     * @param \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion
     * @param int $preCheckNDCIdPeticion
     * @param bool $fareFamiliesBooking
     * @param \ArrayType\ArrayOfAirBookingFareFamilies $fareFamiliesDetails
     * @param string $alternativeBookingReference
     */
    public function __construct($bookingID = null, $availRequestID = null, $bookingRequestID = null, $bookingReference = null, \ArrayType\ArrayOfAirTraveler $airTravelers = null, \ArrayType\ArrayOfAirBookingNote $airBookingNotes = null, $bookingDateTime = null, $ticketIssueDateLimit = null, $marketingCarrierCode = null, $cancellationInsurance = null, $cancellationInsuranceAmount = null, $agentEmail = null, $destinationContactPhone = null, $bookingStatus = null, $amountDifference = null, \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments = null, \ArrayType\ArrayOfAirBookingFare $travelersInfoFares = null, \ArrayType\ArrayOfAirFlightTicket $flightTickets = null, \ArrayType\ArrayOfWarning $warnings = null, $totalAgencyAmount = null, $totalAmount = null, \ArrayType\ArrayOfstring $messages = null, $luggageRequestID = null, \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion = null, $preCheckNDCIdPeticion = null, $fareFamiliesBooking = null, \ArrayType\ArrayOfAirBookingFareFamilies $fareFamiliesDetails = null, $alternativeBookingReference = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setAvailRequestID($availRequestID)
            ->setBookingRequestID($bookingRequestID)
            ->setBookingReference($bookingReference)
            ->setAirTravelers($airTravelers)
            ->setAirBookingNotes($airBookingNotes)
            ->setBookingDateTime($bookingDateTime)
            ->setTicketIssueDateLimit($ticketIssueDateLimit)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setCancellationInsurance($cancellationInsurance)
            ->setCancellationInsuranceAmount($cancellationInsuranceAmount)
            ->setAgentEmail($agentEmail)
            ->setDestinationContactPhone($destinationContactPhone)
            ->setBookingStatus($bookingStatus)
            ->setAmountDifference($amountDifference)
            ->setAirBookingFlightSegments($airBookingFlightSegments)
            ->setTravelersInfoFares($travelersInfoFares)
            ->setFlightTickets($flightTickets)
            ->setWarnings($warnings)
            ->setTotalAgencyAmount($totalAgencyAmount)
            ->setTotalAmount($totalAmount)
            ->setMessages($messages)
            ->setLuggageRequestID($luggageRequestID)
            ->setCabinBaggageTravelfusion($cabinBaggageTravelfusion)
            ->setPreCheckNDCIdPeticion($preCheckNDCIdPeticion)
            ->setFareFamiliesBooking($fareFamiliesBooking)
            ->setFareFamiliesDetails($fareFamiliesDetails)
            ->setAlternativeBookingReference($alternativeBookingReference);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBooking
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirBooking
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get BookingRequestID value
     * @return int|null
     */
    public function getBookingRequestID()
    {
        return $this->BookingRequestID;
    }
    /**
     * Set BookingRequestID value
     * @param int $bookingRequestID
     * @return \StructType\AirBooking
     */
    public function setBookingRequestID($bookingRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingRequestID) && !(is_int($bookingRequestID) || ctype_digit($bookingRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingRequestID, true), gettype($bookingRequestID)), __LINE__);
        }
        $this->BookingRequestID = $bookingRequestID;
        return $this;
    }
    /**
     * Get BookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingReference()
    {
        return isset($this->BookingReference) ? $this->BookingReference : null;
    }
    /**
     * Set BookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingReference
     * @return \StructType\AirBooking
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        if (is_null($bookingReference) || (is_array($bookingReference) && empty($bookingReference))) {
            unset($this->BookingReference);
        } else {
            $this->BookingReference = $bookingReference;
        }
        return $this;
    }
    /**
     * Get AirTravelers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTraveler|null
     */
    public function getAirTravelers()
    {
        return isset($this->AirTravelers) ? $this->AirTravelers : null;
    }
    /**
     * Set AirTravelers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTraveler $airTravelers
     * @return \StructType\AirBooking
     */
    public function setAirTravelers(\ArrayType\ArrayOfAirTraveler $airTravelers = null)
    {
        if (is_null($airTravelers) || (is_array($airTravelers) && empty($airTravelers))) {
            unset($this->AirTravelers);
        } else {
            $this->AirTravelers = $airTravelers;
        }
        return $this;
    }
    /**
     * Get AirBookingNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingNote|null
     */
    public function getAirBookingNotes()
    {
        return isset($this->AirBookingNotes) ? $this->AirBookingNotes : null;
    }
    /**
     * Set AirBookingNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingNote $airBookingNotes
     * @return \StructType\AirBooking
     */
    public function setAirBookingNotes(\ArrayType\ArrayOfAirBookingNote $airBookingNotes = null)
    {
        if (is_null($airBookingNotes) || (is_array($airBookingNotes) && empty($airBookingNotes))) {
            unset($this->AirBookingNotes);
        } else {
            $this->AirBookingNotes = $airBookingNotes;
        }
        return $this;
    }
    /**
     * Get BookingDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingDateTime()
    {
        return isset($this->BookingDateTime) ? $this->BookingDateTime : null;
    }
    /**
     * Set BookingDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingDateTime
     * @return \StructType\AirBooking
     */
    public function setBookingDateTime($bookingDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDateTime) && !is_string($bookingDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDateTime, true), gettype($bookingDateTime)), __LINE__);
        }
        if (is_null($bookingDateTime) || (is_array($bookingDateTime) && empty($bookingDateTime))) {
            unset($this->BookingDateTime);
        } else {
            $this->BookingDateTime = $bookingDateTime;
        }
        return $this;
    }
    /**
     * Get TicketIssueDateLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketIssueDateLimit()
    {
        return isset($this->TicketIssueDateLimit) ? $this->TicketIssueDateLimit : null;
    }
    /**
     * Set TicketIssueDateLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketIssueDateLimit
     * @return \StructType\AirBooking
     */
    public function setTicketIssueDateLimit($ticketIssueDateLimit = null)
    {
        // validation for constraint: string
        if (!is_null($ticketIssueDateLimit) && !is_string($ticketIssueDateLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketIssueDateLimit, true), gettype($ticketIssueDateLimit)), __LINE__);
        }
        if (is_null($ticketIssueDateLimit) || (is_array($ticketIssueDateLimit) && empty($ticketIssueDateLimit))) {
            unset($this->TicketIssueDateLimit);
        } else {
            $this->TicketIssueDateLimit = $ticketIssueDateLimit;
        }
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return isset($this->MarketingCarrierCode) ? $this->MarketingCarrierCode : null;
    }
    /**
     * Set MarketingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingCarrierCode
     * @return \StructType\AirBooking
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        if (is_null($marketingCarrierCode) || (is_array($marketingCarrierCode) && empty($marketingCarrierCode))) {
            unset($this->MarketingCarrierCode);
        } else {
            $this->MarketingCarrierCode = $marketingCarrierCode;
        }
        return $this;
    }
    /**
     * Get CancellationInsurance value
     * @return bool|null
     */
    public function getCancellationInsurance()
    {
        return $this->CancellationInsurance;
    }
    /**
     * Set CancellationInsurance value
     * @param bool $cancellationInsurance
     * @return \StructType\AirBooking
     */
    public function setCancellationInsurance($cancellationInsurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellationInsurance) && !is_bool($cancellationInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellationInsurance, true), gettype($cancellationInsurance)), __LINE__);
        }
        $this->CancellationInsurance = $cancellationInsurance;
        return $this;
    }
    /**
     * Get CancellationInsuranceAmount value
     * @return float|null
     */
    public function getCancellationInsuranceAmount()
    {
        return $this->CancellationInsuranceAmount;
    }
    /**
     * Set CancellationInsuranceAmount value
     * @param float $cancellationInsuranceAmount
     * @return \StructType\AirBooking
     */
    public function setCancellationInsuranceAmount($cancellationInsuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cancellationInsuranceAmount) && !(is_float($cancellationInsuranceAmount) || is_numeric($cancellationInsuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cancellationInsuranceAmount, true), gettype($cancellationInsuranceAmount)), __LINE__);
        }
        $this->CancellationInsuranceAmount = $cancellationInsuranceAmount;
        return $this;
    }
    /**
     * Get AgentEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentEmail()
    {
        return isset($this->AgentEmail) ? $this->AgentEmail : null;
    }
    /**
     * Set AgentEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentEmail
     * @return \StructType\AirBooking
     */
    public function setAgentEmail($agentEmail = null)
    {
        // validation for constraint: string
        if (!is_null($agentEmail) && !is_string($agentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentEmail, true), gettype($agentEmail)), __LINE__);
        }
        if (is_null($agentEmail) || (is_array($agentEmail) && empty($agentEmail))) {
            unset($this->AgentEmail);
        } else {
            $this->AgentEmail = $agentEmail;
        }
        return $this;
    }
    /**
     * Get DestinationContactPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationContactPhone()
    {
        return isset($this->DestinationContactPhone) ? $this->DestinationContactPhone : null;
    }
    /**
     * Set DestinationContactPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationContactPhone
     * @return \StructType\AirBooking
     */
    public function setDestinationContactPhone($destinationContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationContactPhone) && !is_string($destinationContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationContactPhone, true), gettype($destinationContactPhone)), __LINE__);
        }
        if (is_null($destinationContactPhone) || (is_array($destinationContactPhone) && empty($destinationContactPhone))) {
            unset($this->DestinationContactPhone);
        } else {
            $this->DestinationContactPhone = $destinationContactPhone;
        }
        return $this;
    }
    /**
     * Get BookingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingStatus()
    {
        return isset($this->BookingStatus) ? $this->BookingStatus : null;
    }
    /**
     * Set BookingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingStatus
     * @return \StructType\AirBooking
     */
    public function setBookingStatus($bookingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($bookingStatus) && !is_string($bookingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingStatus, true), gettype($bookingStatus)), __LINE__);
        }
        if (is_null($bookingStatus) || (is_array($bookingStatus) && empty($bookingStatus))) {
            unset($this->BookingStatus);
        } else {
            $this->BookingStatus = $bookingStatus;
        }
        return $this;
    }
    /**
     * Get AmountDifference value
     * @return float|null
     */
    public function getAmountDifference()
    {
        return $this->AmountDifference;
    }
    /**
     * Set AmountDifference value
     * @param float $amountDifference
     * @return \StructType\AirBooking
     */
    public function setAmountDifference($amountDifference = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifference) && !(is_float($amountDifference) || is_numeric($amountDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifference, true), gettype($amountDifference)), __LINE__);
        }
        $this->AmountDifference = $amountDifference;
        return $this;
    }
    /**
     * Get AirBookingFlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFlightSegment|null
     */
    public function getAirBookingFlightSegments()
    {
        return isset($this->AirBookingFlightSegments) ? $this->AirBookingFlightSegments : null;
    }
    /**
     * Set AirBookingFlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments
     * @return \StructType\AirBooking
     */
    public function setAirBookingFlightSegments(\ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments = null)
    {
        if (is_null($airBookingFlightSegments) || (is_array($airBookingFlightSegments) && empty($airBookingFlightSegments))) {
            unset($this->AirBookingFlightSegments);
        } else {
            $this->AirBookingFlightSegments = $airBookingFlightSegments;
        }
        return $this;
    }
    /**
     * Get TravelersInfoFares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFare|null
     */
    public function getTravelersInfoFares()
    {
        return isset($this->TravelersInfoFares) ? $this->TravelersInfoFares : null;
    }
    /**
     * Set TravelersInfoFares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFare $travelersInfoFares
     * @return \StructType\AirBooking
     */
    public function setTravelersInfoFares(\ArrayType\ArrayOfAirBookingFare $travelersInfoFares = null)
    {
        if (is_null($travelersInfoFares) || (is_array($travelersInfoFares) && empty($travelersInfoFares))) {
            unset($this->TravelersInfoFares);
        } else {
            $this->TravelersInfoFares = $travelersInfoFares;
        }
        return $this;
    }
    /**
     * Get FlightTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirFlightTicket|null
     */
    public function getFlightTickets()
    {
        return isset($this->FlightTickets) ? $this->FlightTickets : null;
    }
    /**
     * Set FlightTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirFlightTicket $flightTickets
     * @return \StructType\AirBooking
     */
    public function setFlightTickets(\ArrayType\ArrayOfAirFlightTicket $flightTickets = null)
    {
        if (is_null($flightTickets) || (is_array($flightTickets) && empty($flightTickets))) {
            unset($this->FlightTickets);
        } else {
            $this->FlightTickets = $flightTickets;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWarning|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWarning $warnings
     * @return \StructType\AirBooking
     */
    public function setWarnings(\ArrayType\ArrayOfWarning $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get TotalAgencyAmount value
     * @return float|null
     */
    public function getTotalAgencyAmount()
    {
        return $this->TotalAgencyAmount;
    }
    /**
     * Set TotalAgencyAmount value
     * @param float $totalAgencyAmount
     * @return \StructType\AirBooking
     */
    public function setTotalAgencyAmount($totalAgencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAgencyAmount) && !(is_float($totalAgencyAmount) || is_numeric($totalAgencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAgencyAmount, true), gettype($totalAgencyAmount)), __LINE__);
        }
        $this->TotalAgencyAmount = $totalAgencyAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\AirBooking
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get Messages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getMessages()
    {
        return isset($this->Messages) ? $this->Messages : null;
    }
    /**
     * Set Messages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $messages
     * @return \StructType\AirBooking
     */
    public function setMessages(\ArrayType\ArrayOfstring $messages = null)
    {
        if (is_null($messages) || (is_array($messages) && empty($messages))) {
            unset($this->Messages);
        } else {
            $this->Messages = $messages;
        }
        return $this;
    }
    /**
     * Get LuggageRequestID value
     * @return int|null
     */
    public function getLuggageRequestID()
    {
        return $this->LuggageRequestID;
    }
    /**
     * Set LuggageRequestID value
     * @param int $luggageRequestID
     * @return \StructType\AirBooking
     */
    public function setLuggageRequestID($luggageRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($luggageRequestID) && !(is_int($luggageRequestID) || ctype_digit($luggageRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($luggageRequestID, true), gettype($luggageRequestID)), __LINE__);
        }
        $this->LuggageRequestID = $luggageRequestID;
        return $this;
    }
    /**
     * Get CabinBaggageTravelfusion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingBaggageLowCostTf|null
     */
    public function getCabinBaggageTravelfusion()
    {
        return isset($this->CabinBaggageTravelfusion) ? $this->CabinBaggageTravelfusion : null;
    }
    /**
     * Set CabinBaggageTravelfusion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion
     * @return \StructType\AirBooking
     */
    public function setCabinBaggageTravelfusion(\StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion = null)
    {
        if (is_null($cabinBaggageTravelfusion) || (is_array($cabinBaggageTravelfusion) && empty($cabinBaggageTravelfusion))) {
            unset($this->CabinBaggageTravelfusion);
        } else {
            $this->CabinBaggageTravelfusion = $cabinBaggageTravelfusion;
        }
        return $this;
    }
    /**
     * Get PreCheckNDCIdPeticion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPreCheckNDCIdPeticion()
    {
        return isset($this->PreCheckNDCIdPeticion) ? $this->PreCheckNDCIdPeticion : null;
    }
    /**
     * Set PreCheckNDCIdPeticion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $preCheckNDCIdPeticion
     * @return \StructType\AirBooking
     */
    public function setPreCheckNDCIdPeticion($preCheckNDCIdPeticion = null)
    {
        // validation for constraint: int
        if (!is_null($preCheckNDCIdPeticion) && !(is_int($preCheckNDCIdPeticion) || ctype_digit($preCheckNDCIdPeticion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preCheckNDCIdPeticion, true), gettype($preCheckNDCIdPeticion)), __LINE__);
        }
        if (is_null($preCheckNDCIdPeticion) || (is_array($preCheckNDCIdPeticion) && empty($preCheckNDCIdPeticion))) {
            unset($this->PreCheckNDCIdPeticion);
        } else {
            $this->PreCheckNDCIdPeticion = $preCheckNDCIdPeticion;
        }
        return $this;
    }
    /**
     * Get FareFamiliesBooking value
     * @return bool|null
     */
    public function getFareFamiliesBooking()
    {
        return $this->FareFamiliesBooking;
    }
    /**
     * Set FareFamiliesBooking value
     * @param bool $fareFamiliesBooking
     * @return \StructType\AirBooking
     */
    public function setFareFamiliesBooking($fareFamiliesBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($fareFamiliesBooking) && !is_bool($fareFamiliesBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fareFamiliesBooking, true), gettype($fareFamiliesBooking)), __LINE__);
        }
        $this->FareFamiliesBooking = $fareFamiliesBooking;
        return $this;
    }
    /**
     * Get FareFamiliesDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFareFamilies|null
     */
    public function getFareFamiliesDetails()
    {
        return isset($this->FareFamiliesDetails) ? $this->FareFamiliesDetails : null;
    }
    /**
     * Set FareFamiliesDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFareFamilies $fareFamiliesDetails
     * @return \StructType\AirBooking
     */
    public function setFareFamiliesDetails(\ArrayType\ArrayOfAirBookingFareFamilies $fareFamiliesDetails = null)
    {
        if (is_null($fareFamiliesDetails) || (is_array($fareFamiliesDetails) && empty($fareFamiliesDetails))) {
            unset($this->FareFamiliesDetails);
        } else {
            $this->FareFamiliesDetails = $fareFamiliesDetails;
        }
        return $this;
    }
    /**
     * Get AlternativeBookingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativeBookingReference()
    {
        return isset($this->AlternativeBookingReference) ? $this->AlternativeBookingReference : null;
    }
    /**
     * Set AlternativeBookingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativeBookingReference
     * @return \StructType\AirBooking
     */
    public function setAlternativeBookingReference($alternativeBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeBookingReference) && !is_string($alternativeBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternativeBookingReference, true), gettype($alternativeBookingReference)), __LINE__);
        }
        if (is_null($alternativeBookingReference) || (is_array($alternativeBookingReference) && empty($alternativeBookingReference))) {
            unset($this->AlternativeBookingReference);
        } else {
            $this->AlternativeBookingReference = $alternativeBookingReference;
        }
        return $this;
    }
}
