<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailSearch StructType
 * @subpackage Structs
 */
class AirAvailSearch extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The availRQ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirAvailRQ
     */
    public $availRQ;
    /**
     * Constructor method for AirAvailSearch
     * @uses AirAvailSearch::setCredentials()
     * @uses AirAvailSearch::setAvailRQ()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param \StructType\AirAvailRQ $availRQ
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, \StructType\AirAvailRQ $availRQ = null)
    {
        $this
            ->setCredentials($credentials)
            ->setAvailRQ($availRQ);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirAvailSearch
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get availRQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirAvailRQ|null
     */
    public function getAvailRQ()
    {
        return isset($this->availRQ) ? $this->availRQ : null;
    }
    /**
     * Set availRQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirAvailRQ $availRQ
     * @return \StructType\AirAvailSearch
     */
    public function setAvailRQ(\StructType\AirAvailRQ $availRQ = null)
    {
        if (is_null($availRQ) || (is_array($availRQ) && empty($availRQ))) {
            unset($this->availRQ);
        } else {
            $this->availRQ = $availRQ;
        }
        return $this;
    }
}
