<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailRateNotesRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada, para recuperar las notas de tarifa, sobre una combinación de vuelos devuelta en la petición de disponibilidad
 * - nillable: true
 * - type: tns:AirAvailRateNotesRQ
 * @subpackage Structs
 */
class AirAvailRateNotesRQ extends AbstractStructBase
{
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda a partir del cual estamos generando esta reserva
     * - minOccurs: 0
     * @var int
     */
    public $AvailRequestID;
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del grupo de precios devuelto por la búsqueda de disponibilidad para el cual se quiere crear la reserva
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupID;
    /**
     * The ItinerariesID
     * Meta information extracted from the WSDL
     * - documentation: Array con los identificadores de los itinerarios devueltos por la búsqueda de disponibilidad para los que se quiere crear la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $ItinerariesID;
    /**
     * The AdultNumber
     * Meta information extracted from the WSDL
     * - documentation: Indica el Numero de adultos
     * - minOccurs: 0
     * @var int
     */
    public $AdultNumber;
    /**
     * The ChildrenNumber
     * Meta information extracted from the WSDL
     * - documentation: Indica el Numero de Niños
     * - minOccurs: 0
     * @var int
     */
    public $ChildrenNumber;
    /**
     * The InfantNumber
     * Meta information extracted from the WSDL
     * - documentation: Indica el Numero de Bebes
     * - minOccurs: 0
     * @var int
     */
    public $InfantNumber;
    /**
     * Constructor method for AirAvailRateNotesRQ
     * @uses AirAvailRateNotesRQ::setAvailRequestID()
     * @uses AirAvailRateNotesRQ::setPricingGroupID()
     * @uses AirAvailRateNotesRQ::setItinerariesID()
     * @uses AirAvailRateNotesRQ::setAdultNumber()
     * @uses AirAvailRateNotesRQ::setChildrenNumber()
     * @uses AirAvailRateNotesRQ::setInfantNumber()
     * @param int $availRequestID
     * @param int $pricingGroupID
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @param int $adultNumber
     * @param int $childrenNumber
     * @param int $infantNumber
     */
    public function __construct($availRequestID = null, $pricingGroupID = null, \ArrayType\ArrayOfInt $itinerariesID = null, $adultNumber = null, $childrenNumber = null, $infantNumber = null)
    {
        $this
            ->setAvailRequestID($availRequestID)
            ->setPricingGroupID($pricingGroupID)
            ->setItinerariesID($itinerariesID)
            ->setAdultNumber($adultNumber)
            ->setChildrenNumber($childrenNumber)
            ->setInfantNumber($infantNumber);
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirAvailRateNotesRQ
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirAvailRateNotesRQ
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get ItinerariesID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItinerariesID()
    {
        return isset($this->ItinerariesID) ? $this->ItinerariesID : null;
    }
    /**
     * Set ItinerariesID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @return \StructType\AirAvailRateNotesRQ
     */
    public function setItinerariesID(\ArrayType\ArrayOfInt $itinerariesID = null)
    {
        if (is_null($itinerariesID) || (is_array($itinerariesID) && empty($itinerariesID))) {
            unset($this->ItinerariesID);
        } else {
            $this->ItinerariesID = $itinerariesID;
        }
        return $this;
    }
    /**
     * Get AdultNumber value
     * @return int|null
     */
    public function getAdultNumber()
    {
        return $this->AdultNumber;
    }
    /**
     * Set AdultNumber value
     * @param int $adultNumber
     * @return \StructType\AirAvailRateNotesRQ
     */
    public function setAdultNumber($adultNumber = null)
    {
        // validation for constraint: int
        if (!is_null($adultNumber) && !(is_int($adultNumber) || ctype_digit($adultNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adultNumber, true), gettype($adultNumber)), __LINE__);
        }
        $this->AdultNumber = $adultNumber;
        return $this;
    }
    /**
     * Get ChildrenNumber value
     * @return int|null
     */
    public function getChildrenNumber()
    {
        return $this->ChildrenNumber;
    }
    /**
     * Set ChildrenNumber value
     * @param int $childrenNumber
     * @return \StructType\AirAvailRateNotesRQ
     */
    public function setChildrenNumber($childrenNumber = null)
    {
        // validation for constraint: int
        if (!is_null($childrenNumber) && !(is_int($childrenNumber) || ctype_digit($childrenNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childrenNumber, true), gettype($childrenNumber)), __LINE__);
        }
        $this->ChildrenNumber = $childrenNumber;
        return $this;
    }
    /**
     * Get InfantNumber value
     * @return int|null
     */
    public function getInfantNumber()
    {
        return $this->InfantNumber;
    }
    /**
     * Set InfantNumber value
     * @param int $infantNumber
     * @return \StructType\AirAvailRateNotesRQ
     */
    public function setInfantNumber($infantNumber = null)
    {
        // validation for constraint: int
        if (!is_null($infantNumber) && !(is_int($infantNumber) || ctype_digit($infantNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infantNumber, true), gettype($infantNumber)), __LINE__);
        }
        $this->InfantNumber = $infantNumber;
        return $this;
    }
}
