<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailFareFamiliesRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que contiene información de las FareFamilies de una combinación
 * - nillable: true
 * - type: tns:AirAvailFareFamiliesRS
 * @subpackage Structs
 */
class AirAvailFareFamiliesRS extends AbstractStructBase
{
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al metodo invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda
     * - minOccurs: 0
     * @var int
     */
    public $AvailRequestID;
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del esquema de precio
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupID;
    /**
     * The ItinerariesID
     * Meta information extracted from the WSDL
     * - documentation: Array con los identificadores de los itinerarios devueltos por la búsqueda de disponibilidad para los que consultamos las FF Importante: deben ponerse todos los itinerarios que se han devuelto en la disponibilidad, es decir, si la
     * disponibilidad es ida y vuelta deben ponerse los dos.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $ItinerariesID;
    /**
     * The FareFamiliesOptions
     * Meta information extracted from the WSDL
     * - documentation: Lista de opciones de FareFamilies por Segmento-Trayecto de la combinacion
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirAvailFareFamiliesOptions
     */
    public $FareFamiliesOptions;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al recuperar las fareFamilies
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirAvailFareFamiliesRS
     * @uses AirAvailFareFamiliesRS::setRequestID()
     * @uses AirAvailFareFamiliesRS::setAvailRequestID()
     * @uses AirAvailFareFamiliesRS::setPricingGroupID()
     * @uses AirAvailFareFamiliesRS::setItinerariesID()
     * @uses AirAvailFareFamiliesRS::setFareFamiliesOptions()
     * @uses AirAvailFareFamiliesRS::setError()
     * @param int $requestID
     * @param int $availRequestID
     * @param int $pricingGroupID
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @param \ArrayType\ArrayOfAirAvailFareFamiliesOptions $fareFamiliesOptions
     * @param \StructType\ResponseError $error
     */
    public function __construct($requestID = null, $availRequestID = null, $pricingGroupID = null, \ArrayType\ArrayOfInt $itinerariesID = null, \ArrayType\ArrayOfAirAvailFareFamiliesOptions $fareFamiliesOptions = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setRequestID($requestID)
            ->setAvailRequestID($availRequestID)
            ->setPricingGroupID($pricingGroupID)
            ->setItinerariesID($itinerariesID)
            ->setFareFamiliesOptions($fareFamiliesOptions)
            ->setError($error);
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirAvailFareFamiliesRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirAvailFareFamiliesRS
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirAvailFareFamiliesRS
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get ItinerariesID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItinerariesID()
    {
        return isset($this->ItinerariesID) ? $this->ItinerariesID : null;
    }
    /**
     * Set ItinerariesID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @return \StructType\AirAvailFareFamiliesRS
     */
    public function setItinerariesID(\ArrayType\ArrayOfInt $itinerariesID = null)
    {
        if (is_null($itinerariesID) || (is_array($itinerariesID) && empty($itinerariesID))) {
            unset($this->ItinerariesID);
        } else {
            $this->ItinerariesID = $itinerariesID;
        }
        return $this;
    }
    /**
     * Get FareFamiliesOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirAvailFareFamiliesOptions|null
     */
    public function getFareFamiliesOptions()
    {
        return isset($this->FareFamiliesOptions) ? $this->FareFamiliesOptions : null;
    }
    /**
     * Set FareFamiliesOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirAvailFareFamiliesOptions $fareFamiliesOptions
     * @return \StructType\AirAvailFareFamiliesRS
     */
    public function setFareFamiliesOptions(\ArrayType\ArrayOfAirAvailFareFamiliesOptions $fareFamiliesOptions = null)
    {
        if (is_null($fareFamiliesOptions) || (is_array($fareFamiliesOptions) && empty($fareFamiliesOptions))) {
            unset($this->FareFamiliesOptions);
        } else {
            $this->FareFamiliesOptions = $fareFamiliesOptions;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirAvailFareFamiliesRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
