<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyCard StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una tarjeta de una agencia, para usarla como forma de pago UYU (Tarjeta autorizada)
 * - nillable: true
 * - type: tns:AgencyCard
 * @subpackage Structs
 */
class AgencyCard extends AbstractStructBase
{
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de tarjeta
     * - minOccurs: 0
     * @var int
     */
    public $CardID;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Número de tarjeta
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardOwner
     * Meta information extracted from the WSDL
     * - documentation: Titular de la tarjeta
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardOwner;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - documentation: Descripción del tipo de tarjeta
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de caducidad de la tarjeta en el formato mmaa
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * Constructor method for AgencyCard
     * @uses AgencyCard::setCardID()
     * @uses AgencyCard::setCardNumber()
     * @uses AgencyCard::setCardOwner()
     * @uses AgencyCard::setCardType()
     * @uses AgencyCard::setExpirationDate()
     * @param int $cardID
     * @param string $cardNumber
     * @param string $cardOwner
     * @param string $cardType
     * @param string $expirationDate
     */
    public function __construct($cardID = null, $cardNumber = null, $cardOwner = null, $cardType = null, $expirationDate = null)
    {
        $this
            ->setCardID($cardID)
            ->setCardNumber($cardNumber)
            ->setCardOwner($cardOwner)
            ->setCardType($cardType)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get CardID value
     * @return int|null
     */
    public function getCardID()
    {
        return $this->CardID;
    }
    /**
     * Set CardID value
     * @param int $cardID
     * @return \StructType\AgencyCard
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        $this->CardID = $cardID;
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \StructType\AgencyCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardOwner()
    {
        return isset($this->CardOwner) ? $this->CardOwner : null;
    }
    /**
     * Set CardOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardOwner
     * @return \StructType\AgencyCard
     */
    public function setCardOwner($cardOwner = null)
    {
        // validation for constraint: string
        if (!is_null($cardOwner) && !is_string($cardOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardOwner, true), gettype($cardOwner)), __LINE__);
        }
        if (is_null($cardOwner) || (is_array($cardOwner) && empty($cardOwner))) {
            unset($this->CardOwner);
        } else {
            $this->CardOwner = $cardOwner;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardType
     * @return \StructType\AgencyCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \StructType\AgencyCard
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
}
