<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Airline ServiceType
 * @subpackage Services
 */
class Airline extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AirlineCarriersList
     * Meta information extracted from the WSDL
     * - documentation: Devuelve las compañias aereas, ordenadas por nombre@param credentials credenciales de autenticación@return Lista de objetos AirAirlineCarrier con las compañias aereas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirlineCarriersList $parameters
     * @return \StructType\AirlineCarriersListResponse|bool
     */
    public function AirlineCarriersList(\StructType\AirlineCarriersList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirlineCarriersList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AirlineCarriersListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
