<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Agency ServiceType
 * @subpackage Services
 */
class Agency extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AgencyCardsList
     * Meta information extracted from the WSDL
     * - documentation: [OBSOLETO] Devuelve las tarjetas disponibles para una Agencia. IMPORTANTE: ya no se permite la emisión de billetes contra tarjeta autorizada. Si tiene alguna duda contacte con Servivuelo@param credentials credenciales de
     * autenticación@return Objeto del tipo AgencyCardsListRS con las tarjetas de la agencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgencyCardsList $parameters
     * @return \StructType\AgencyCardsListResponse|bool
     */
    public function AgencyCardsList(\StructType\AgencyCardsList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AgencyCardsList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AgencyCardsListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
