<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirTravelerTypes EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeración con los tipos de pasajeros
 * - nillable: true
 * - type: tns:AirTravelerTypes
 * @subpackage Enumerations
 */
class AirTravelerTypes extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Adult'
     * Meta information extracted from the WSDL
     * - documentation: Adulto (mayor o igual que 12 años)
     * @return string 'Adult'
     */
    const VALUE_ADULT = 'Adult';
    /**
     * Constant for value 'Child'
     * Meta information extracted from the WSDL
     * - documentation: Niño (mayor o igual que 2 años y menor que 12 años)
     * @return string 'Child'
     */
    const VALUE_CHILD = 'Child';
    /**
     * Constant for value 'Infant'
     * Meta information extracted from the WSDL
     * - documentation: Bebe (menor que 2 años)
     * @return string 'Infant'
     */
    const VALUE_INFANT = 'Infant';
    /**
     * Return allowed values
     * @uses self::VALUE_ADULT
     * @uses self::VALUE_CHILD
     * @uses self::VALUE_INFANT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADULT,
            self::VALUE_CHILD,
            self::VALUE_INFANT,
        );
    }
}
