<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerFlightSegmentLeg StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un trayecto para cada pasajero
 * - nillable: true
 * - type: tns:AirTravelerFlightSegmentLeg
 * @subpackage Structs
 */
class AirTravelerFlightSegmentLeg extends AbstractStructBase
{
    /**
     * The IDAirbookingFlightSegmentLeg
     * Meta information extracted from the WSDL
     * - documentation: Identifica el trayecto dentro de la reserva util para relacionar con AirFlightSegmentLeg
     * - minOccurs: 0
     * @var int
     */
    public $IDAirbookingFlightSegmentLeg;
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - documentation: La clase de cabina para el vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClass;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: El tipo de cabina para el vuelo - 1 letra
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinType;
    /**
     * The BaggageQuantity
     * Meta information extracted from the WSDL
     * - documentation: La cantidad de equipaje permitido
     * - minOccurs: 0
     * @var int
     */
    public $BaggageQuantity;
    /**
     * The BaggageType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de equipaje
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaggageType;
    /**
     * The BaggageWeight
     * Meta information extracted from the WSDL
     * - documentation: Cuando se permite peso en vez de piezas, se especifica aqui
     * - minOccurs: 0
     * @var float
     */
    public $BaggageWeight;
    /**
     * The MeasureUnit
     * Meta information extracted from the WSDL
     * - documentation: Indica la unidad de medida del equipaje (piezas o peso)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MeasureUnit;
    /**
     * The FareBasis
     * Meta information extracted from the WSDL
     * - documentation: El codigo farebasis del vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasis;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Notas de tarifa para este segmento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The FareFamiliesName
     * Meta information extracted from the WSDL
     * - documentation: FareFamilies para este segmento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareFamiliesName;
    /**
     * The FareFamiliesDescripcion
     * Meta information extracted from the WSDL
     * - documentation: FareFamilies Descripcion para este segmento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareFamiliesDescripcion;
    /**
     * Constructor method for AirTravelerFlightSegmentLeg
     * @uses AirTravelerFlightSegmentLeg::setIDAirbookingFlightSegmentLeg()
     * @uses AirTravelerFlightSegmentLeg::setCabinClass()
     * @uses AirTravelerFlightSegmentLeg::setCabinType()
     * @uses AirTravelerFlightSegmentLeg::setBaggageQuantity()
     * @uses AirTravelerFlightSegmentLeg::setBaggageType()
     * @uses AirTravelerFlightSegmentLeg::setBaggageWeight()
     * @uses AirTravelerFlightSegmentLeg::setMeasureUnit()
     * @uses AirTravelerFlightSegmentLeg::setFareBasis()
     * @uses AirTravelerFlightSegmentLeg::setNotes()
     * @uses AirTravelerFlightSegmentLeg::setFareFamiliesName()
     * @uses AirTravelerFlightSegmentLeg::setFareFamiliesDescripcion()
     * @param int $iDAirbookingFlightSegmentLeg
     * @param string $cabinClass
     * @param string $cabinType
     * @param int $baggageQuantity
     * @param string $baggageType
     * @param float $baggageWeight
     * @param string $measureUnit
     * @param string $fareBasis
     * @param string $notes
     * @param string $fareFamiliesName
     * @param string $fareFamiliesDescripcion
     */
    public function __construct($iDAirbookingFlightSegmentLeg = null, $cabinClass = null, $cabinType = null, $baggageQuantity = null, $baggageType = null, $baggageWeight = null, $measureUnit = null, $fareBasis = null, $notes = null, $fareFamiliesName = null, $fareFamiliesDescripcion = null)
    {
        $this
            ->setIDAirbookingFlightSegmentLeg($iDAirbookingFlightSegmentLeg)
            ->setCabinClass($cabinClass)
            ->setCabinType($cabinType)
            ->setBaggageQuantity($baggageQuantity)
            ->setBaggageType($baggageType)
            ->setBaggageWeight($baggageWeight)
            ->setMeasureUnit($measureUnit)
            ->setFareBasis($fareBasis)
            ->setNotes($notes)
            ->setFareFamiliesName($fareFamiliesName)
            ->setFareFamiliesDescripcion($fareFamiliesDescripcion);
    }
    /**
     * Get IDAirbookingFlightSegmentLeg value
     * @return int|null
     */
    public function getIDAirbookingFlightSegmentLeg()
    {
        return $this->IDAirbookingFlightSegmentLeg;
    }
    /**
     * Set IDAirbookingFlightSegmentLeg value
     * @param int $iDAirbookingFlightSegmentLeg
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setIDAirbookingFlightSegmentLeg($iDAirbookingFlightSegmentLeg = null)
    {
        // validation for constraint: int
        if (!is_null($iDAirbookingFlightSegmentLeg) && !(is_int($iDAirbookingFlightSegmentLeg) || ctype_digit($iDAirbookingFlightSegmentLeg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDAirbookingFlightSegmentLeg, true), gettype($iDAirbookingFlightSegmentLeg)), __LINE__);
        }
        $this->IDAirbookingFlightSegmentLeg = $iDAirbookingFlightSegmentLeg;
        return $this;
    }
    /**
     * Get CabinClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClass()
    {
        return isset($this->CabinClass) ? $this->CabinClass : null;
    }
    /**
     * Set CabinClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinClass
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinClass, true), gettype($cabinClass)), __LINE__);
        }
        if (is_null($cabinClass) || (is_array($cabinClass) && empty($cabinClass))) {
            unset($this->CabinClass);
        } else {
            $this->CabinClass = $cabinClass;
        }
        return $this;
    }
    /**
     * Get CabinType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinType()
    {
        return isset($this->CabinType) ? $this->CabinType : null;
    }
    /**
     * Set CabinType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinType
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: string
        if (!is_null($cabinType) && !is_string($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinType, true), gettype($cabinType)), __LINE__);
        }
        if (is_null($cabinType) || (is_array($cabinType) && empty($cabinType))) {
            unset($this->CabinType);
        } else {
            $this->CabinType = $cabinType;
        }
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return int|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param int $baggageQuantity
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($baggageQuantity) && !(is_int($baggageQuantity) || ctype_digit($baggageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baggageQuantity, true), gettype($baggageQuantity)), __LINE__);
        }
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get BaggageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaggageType()
    {
        return isset($this->BaggageType) ? $this->BaggageType : null;
    }
    /**
     * Set BaggageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baggageType
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setBaggageType($baggageType = null)
    {
        // validation for constraint: string
        if (!is_null($baggageType) && !is_string($baggageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageType, true), gettype($baggageType)), __LINE__);
        }
        if (is_null($baggageType) || (is_array($baggageType) && empty($baggageType))) {
            unset($this->BaggageType);
        } else {
            $this->BaggageType = $baggageType;
        }
        return $this;
    }
    /**
     * Get BaggageWeight value
     * @return float|null
     */
    public function getBaggageWeight()
    {
        return $this->BaggageWeight;
    }
    /**
     * Set BaggageWeight value
     * @param float $baggageWeight
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setBaggageWeight($baggageWeight = null)
    {
        // validation for constraint: float
        if (!is_null($baggageWeight) && !(is_float($baggageWeight) || is_numeric($baggageWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baggageWeight, true), gettype($baggageWeight)), __LINE__);
        }
        $this->BaggageWeight = $baggageWeight;
        return $this;
    }
    /**
     * Get MeasureUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeasureUnit()
    {
        return isset($this->MeasureUnit) ? $this->MeasureUnit : null;
    }
    /**
     * Set MeasureUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $measureUnit
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setMeasureUnit($measureUnit = null)
    {
        // validation for constraint: string
        if (!is_null($measureUnit) && !is_string($measureUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measureUnit, true), gettype($measureUnit)), __LINE__);
        }
        if (is_null($measureUnit) || (is_array($measureUnit) && empty($measureUnit))) {
            unset($this->MeasureUnit);
        } else {
            $this->MeasureUnit = $measureUnit;
        }
        return $this;
    }
    /**
     * Get FareBasis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasis()
    {
        return isset($this->FareBasis) ? $this->FareBasis : null;
    }
    /**
     * Set FareBasis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasis
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasis, true), gettype($fareBasis)), __LINE__);
        }
        if (is_null($fareBasis) || (is_array($fareBasis) && empty($fareBasis))) {
            unset($this->FareBasis);
        } else {
            $this->FareBasis = $fareBasis;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get FareFamiliesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareFamiliesName()
    {
        return isset($this->FareFamiliesName) ? $this->FareFamiliesName : null;
    }
    /**
     * Set FareFamiliesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareFamiliesName
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setFareFamiliesName($fareFamiliesName = null)
    {
        // validation for constraint: string
        if (!is_null($fareFamiliesName) && !is_string($fareFamiliesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareFamiliesName, true), gettype($fareFamiliesName)), __LINE__);
        }
        if (is_null($fareFamiliesName) || (is_array($fareFamiliesName) && empty($fareFamiliesName))) {
            unset($this->FareFamiliesName);
        } else {
            $this->FareFamiliesName = $fareFamiliesName;
        }
        return $this;
    }
    /**
     * Get FareFamiliesDescripcion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareFamiliesDescripcion()
    {
        return isset($this->FareFamiliesDescripcion) ? $this->FareFamiliesDescripcion : null;
    }
    /**
     * Set FareFamiliesDescripcion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareFamiliesDescripcion
     * @return \StructType\AirTravelerFlightSegmentLeg
     */
    public function setFareFamiliesDescripcion($fareFamiliesDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($fareFamiliesDescripcion) && !is_string($fareFamiliesDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareFamiliesDescripcion, true), gettype($fareFamiliesDescripcion)), __LINE__);
        }
        if (is_null($fareFamiliesDescripcion) || (is_array($fareFamiliesDescripcion) && empty($fareFamiliesDescripcion))) {
            unset($this->FareFamiliesDescripcion);
        } else {
            $this->FareFamiliesDescripcion = $fareFamiliesDescripcion;
        }
        return $this;
    }
}
