<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPricingGroup StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con la estructura necesaria para almacenar los distintos grupos de precios asociados a un viaje.
 * - nillable: true
 * - type: tns:AirPricingGroup
 * @subpackage Structs
 */
class AirPricingGroup extends AbstractStructBase
{
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de cada uno de los grupos de precio de una respuesta de disponibilidad
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupID;
    /**
     * The AdultTicketAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio unitario en euros del billete para los pasajeros adultos
     * - minOccurs: 0
     * @var float
     */
    public $AdultTicketAmount;
    /**
     * The ChildrenTicketAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio unitario en euros del billete para los pasajeros niños
     * - minOccurs: 0
     * @var float
     */
    public $ChildrenTicketAmount;
    /**
     * The InfantTicketAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio unitario en euros del billete para los pasajeros bebes
     * - minOccurs: 0
     * @var float
     */
    public $InfantTicketAmount;
    /**
     * The AdultTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio unitario en euros de las tasas para los pasajeros adultos
     * - minOccurs: 0
     * @var float
     */
    public $AdultTaxAmount;
    /**
     * The ChildrenTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio unitario en euros de las tasas para los pasajeros niños
     * - minOccurs: 0
     * @var float
     */
    public $ChildrenTaxAmount;
    /**
     * The InfantTaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio unitario en euros de las tasas para los pasajeros bebes
     * - minOccurs: 0
     * @var float
     */
    public $InfantTaxAmount;
    /**
     * The AgencyFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee de agencia para este grupo de precios
     * - minOccurs: 0
     * @var float
     */
    public $AgencyFeeAmount;
    /**
     * The AramixFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee de Aramix para este grupo de precios
     * - minOccurs: 0
     * @var float
     */
    public $AramixFeeAmount;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - documentation: Descuento para residentes
     * - minOccurs: 0
     * @var float
     */
    public $DiscountAmount;
    /**
     * The LastTicketDate
     * Meta information extracted from the WSDL
     * - documentation: La fecha limite de emision de la reserva (formato dd/MM/aaaa). Según Amadeus esta fecha no es vinculante. La fecha vinculante es la que se nos informa a la hora de realizar la reserva.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastTicketDate;
    /**
     * The IsLowCost
     * Meta information extracted from the WSDL
     * - documentation: Indica si esta combinación de precios es low cost
     * - minOccurs: 0
     * @var bool
     */
    public $IsLowCost;
    /**
     * The GdsProposalIndex
     * Meta information extracted from the WSDL
     * - documentation: Este indicador es necesario para completar una reserva low cost con el proveedor Iris
     * - minOccurs: 0
     * @var int
     */
    public $GdsProposalIndex;
    /**
     * The FareNotes
     * Meta information extracted from the WSDL
     * - documentation: Notas informativas básicas acerca de fecha de límite emision y posibles penalizaciones para la cancelación de la reserva.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirFareNote
     */
    public $FareNotes;
    /**
     * The AirPricingGroupOptions
     * Meta information extracted from the WSDL
     * - documentation: Lista de estructuras necesaria para almacenar una combinacion factible de vuelos, para completar un viaje. Basándonos en un grupo de precios (precio).
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirPricingGroupOption
     */
    public $AirPricingGroupOptions;
    /**
     * The GroupID
     * Meta information extracted from the WSDL
     * - documentation: Esta propiedad será usada en los trayectos multiples, para poder tener varios grupos con un mismo esquema de precio
     * - minOccurs: 0
     * @var int
     */
    public $GroupID;
    /**
     * The IsTourOperator
     * Meta information extracted from the WSDL
     * - documentation: Propiedad para controlar que el esquema de precio es de tipo Tour Operacion o no
     * - minOccurs: 0
     * @var bool
     */
    public $IsTourOperator;
    /**
     * Constructor method for AirPricingGroup
     * @uses AirPricingGroup::setPricingGroupID()
     * @uses AirPricingGroup::setAdultTicketAmount()
     * @uses AirPricingGroup::setChildrenTicketAmount()
     * @uses AirPricingGroup::setInfantTicketAmount()
     * @uses AirPricingGroup::setAdultTaxAmount()
     * @uses AirPricingGroup::setChildrenTaxAmount()
     * @uses AirPricingGroup::setInfantTaxAmount()
     * @uses AirPricingGroup::setAgencyFeeAmount()
     * @uses AirPricingGroup::setAramixFeeAmount()
     * @uses AirPricingGroup::setDiscountAmount()
     * @uses AirPricingGroup::setLastTicketDate()
     * @uses AirPricingGroup::setIsLowCost()
     * @uses AirPricingGroup::setGdsProposalIndex()
     * @uses AirPricingGroup::setFareNotes()
     * @uses AirPricingGroup::setAirPricingGroupOptions()
     * @uses AirPricingGroup::setGroupID()
     * @uses AirPricingGroup::setIsTourOperator()
     * @param int $pricingGroupID
     * @param float $adultTicketAmount
     * @param float $childrenTicketAmount
     * @param float $infantTicketAmount
     * @param float $adultTaxAmount
     * @param float $childrenTaxAmount
     * @param float $infantTaxAmount
     * @param float $agencyFeeAmount
     * @param float $aramixFeeAmount
     * @param float $discountAmount
     * @param string $lastTicketDate
     * @param bool $isLowCost
     * @param int $gdsProposalIndex
     * @param \ArrayType\ArrayOfAirFareNote $fareNotes
     * @param \ArrayType\ArrayOfAirPricingGroupOption $airPricingGroupOptions
     * @param int $groupID
     * @param bool $isTourOperator
     */
    public function __construct($pricingGroupID = null, $adultTicketAmount = null, $childrenTicketAmount = null, $infantTicketAmount = null, $adultTaxAmount = null, $childrenTaxAmount = null, $infantTaxAmount = null, $agencyFeeAmount = null, $aramixFeeAmount = null, $discountAmount = null, $lastTicketDate = null, $isLowCost = null, $gdsProposalIndex = null, \ArrayType\ArrayOfAirFareNote $fareNotes = null, \ArrayType\ArrayOfAirPricingGroupOption $airPricingGroupOptions = null, $groupID = null, $isTourOperator = null)
    {
        $this
            ->setPricingGroupID($pricingGroupID)
            ->setAdultTicketAmount($adultTicketAmount)
            ->setChildrenTicketAmount($childrenTicketAmount)
            ->setInfantTicketAmount($infantTicketAmount)
            ->setAdultTaxAmount($adultTaxAmount)
            ->setChildrenTaxAmount($childrenTaxAmount)
            ->setInfantTaxAmount($infantTaxAmount)
            ->setAgencyFeeAmount($agencyFeeAmount)
            ->setAramixFeeAmount($aramixFeeAmount)
            ->setDiscountAmount($discountAmount)
            ->setLastTicketDate($lastTicketDate)
            ->setIsLowCost($isLowCost)
            ->setGdsProposalIndex($gdsProposalIndex)
            ->setFareNotes($fareNotes)
            ->setAirPricingGroupOptions($airPricingGroupOptions)
            ->setGroupID($groupID)
            ->setIsTourOperator($isTourOperator);
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirPricingGroup
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get AdultTicketAmount value
     * @return float|null
     */
    public function getAdultTicketAmount()
    {
        return $this->AdultTicketAmount;
    }
    /**
     * Set AdultTicketAmount value
     * @param float $adultTicketAmount
     * @return \StructType\AirPricingGroup
     */
    public function setAdultTicketAmount($adultTicketAmount = null)
    {
        // validation for constraint: float
        if (!is_null($adultTicketAmount) && !(is_float($adultTicketAmount) || is_numeric($adultTicketAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adultTicketAmount, true), gettype($adultTicketAmount)), __LINE__);
        }
        $this->AdultTicketAmount = $adultTicketAmount;
        return $this;
    }
    /**
     * Get ChildrenTicketAmount value
     * @return float|null
     */
    public function getChildrenTicketAmount()
    {
        return $this->ChildrenTicketAmount;
    }
    /**
     * Set ChildrenTicketAmount value
     * @param float $childrenTicketAmount
     * @return \StructType\AirPricingGroup
     */
    public function setChildrenTicketAmount($childrenTicketAmount = null)
    {
        // validation for constraint: float
        if (!is_null($childrenTicketAmount) && !(is_float($childrenTicketAmount) || is_numeric($childrenTicketAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($childrenTicketAmount, true), gettype($childrenTicketAmount)), __LINE__);
        }
        $this->ChildrenTicketAmount = $childrenTicketAmount;
        return $this;
    }
    /**
     * Get InfantTicketAmount value
     * @return float|null
     */
    public function getInfantTicketAmount()
    {
        return $this->InfantTicketAmount;
    }
    /**
     * Set InfantTicketAmount value
     * @param float $infantTicketAmount
     * @return \StructType\AirPricingGroup
     */
    public function setInfantTicketAmount($infantTicketAmount = null)
    {
        // validation for constraint: float
        if (!is_null($infantTicketAmount) && !(is_float($infantTicketAmount) || is_numeric($infantTicketAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($infantTicketAmount, true), gettype($infantTicketAmount)), __LINE__);
        }
        $this->InfantTicketAmount = $infantTicketAmount;
        return $this;
    }
    /**
     * Get AdultTaxAmount value
     * @return float|null
     */
    public function getAdultTaxAmount()
    {
        return $this->AdultTaxAmount;
    }
    /**
     * Set AdultTaxAmount value
     * @param float $adultTaxAmount
     * @return \StructType\AirPricingGroup
     */
    public function setAdultTaxAmount($adultTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($adultTaxAmount) && !(is_float($adultTaxAmount) || is_numeric($adultTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($adultTaxAmount, true), gettype($adultTaxAmount)), __LINE__);
        }
        $this->AdultTaxAmount = $adultTaxAmount;
        return $this;
    }
    /**
     * Get ChildrenTaxAmount value
     * @return float|null
     */
    public function getChildrenTaxAmount()
    {
        return $this->ChildrenTaxAmount;
    }
    /**
     * Set ChildrenTaxAmount value
     * @param float $childrenTaxAmount
     * @return \StructType\AirPricingGroup
     */
    public function setChildrenTaxAmount($childrenTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($childrenTaxAmount) && !(is_float($childrenTaxAmount) || is_numeric($childrenTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($childrenTaxAmount, true), gettype($childrenTaxAmount)), __LINE__);
        }
        $this->ChildrenTaxAmount = $childrenTaxAmount;
        return $this;
    }
    /**
     * Get InfantTaxAmount value
     * @return float|null
     */
    public function getInfantTaxAmount()
    {
        return $this->InfantTaxAmount;
    }
    /**
     * Set InfantTaxAmount value
     * @param float $infantTaxAmount
     * @return \StructType\AirPricingGroup
     */
    public function setInfantTaxAmount($infantTaxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($infantTaxAmount) && !(is_float($infantTaxAmount) || is_numeric($infantTaxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($infantTaxAmount, true), gettype($infantTaxAmount)), __LINE__);
        }
        $this->InfantTaxAmount = $infantTaxAmount;
        return $this;
    }
    /**
     * Get AgencyFeeAmount value
     * @return float|null
     */
    public function getAgencyFeeAmount()
    {
        return $this->AgencyFeeAmount;
    }
    /**
     * Set AgencyFeeAmount value
     * @param float $agencyFeeAmount
     * @return \StructType\AirPricingGroup
     */
    public function setAgencyFeeAmount($agencyFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($agencyFeeAmount) && !(is_float($agencyFeeAmount) || is_numeric($agencyFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agencyFeeAmount, true), gettype($agencyFeeAmount)), __LINE__);
        }
        $this->AgencyFeeAmount = $agencyFeeAmount;
        return $this;
    }
    /**
     * Get AramixFeeAmount value
     * @return float|null
     */
    public function getAramixFeeAmount()
    {
        return $this->AramixFeeAmount;
    }
    /**
     * Set AramixFeeAmount value
     * @param float $aramixFeeAmount
     * @return \StructType\AirPricingGroup
     */
    public function setAramixFeeAmount($aramixFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($aramixFeeAmount) && !(is_float($aramixFeeAmount) || is_numeric($aramixFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aramixFeeAmount, true), gettype($aramixFeeAmount)), __LINE__);
        }
        $this->AramixFeeAmount = $aramixFeeAmount;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param float $discountAmount
     * @return \StructType\AirPricingGroup
     */
    public function setDiscountAmount($discountAmount = null)
    {
        // validation for constraint: float
        if (!is_null($discountAmount) && !(is_float($discountAmount) || is_numeric($discountAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountAmount, true), gettype($discountAmount)), __LINE__);
        }
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return isset($this->LastTicketDate) ? $this->LastTicketDate : null;
    }
    /**
     * Set LastTicketDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastTicketDate
     * @return \StructType\AirPricingGroup
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastTicketDate) && !is_string($lastTicketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTicketDate, true), gettype($lastTicketDate)), __LINE__);
        }
        if (is_null($lastTicketDate) || (is_array($lastTicketDate) && empty($lastTicketDate))) {
            unset($this->LastTicketDate);
        } else {
            $this->LastTicketDate = $lastTicketDate;
        }
        return $this;
    }
    /**
     * Get IsLowCost value
     * @return bool|null
     */
    public function getIsLowCost()
    {
        return $this->IsLowCost;
    }
    /**
     * Set IsLowCost value
     * @param bool $isLowCost
     * @return \StructType\AirPricingGroup
     */
    public function setIsLowCost($isLowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLowCost) && !is_bool($isLowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLowCost, true), gettype($isLowCost)), __LINE__);
        }
        $this->IsLowCost = $isLowCost;
        return $this;
    }
    /**
     * Get GdsProposalIndex value
     * @return int|null
     */
    public function getGdsProposalIndex()
    {
        return $this->GdsProposalIndex;
    }
    /**
     * Set GdsProposalIndex value
     * @param int $gdsProposalIndex
     * @return \StructType\AirPricingGroup
     */
    public function setGdsProposalIndex($gdsProposalIndex = null)
    {
        // validation for constraint: int
        if (!is_null($gdsProposalIndex) && !(is_int($gdsProposalIndex) || ctype_digit($gdsProposalIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gdsProposalIndex, true), gettype($gdsProposalIndex)), __LINE__);
        }
        $this->GdsProposalIndex = $gdsProposalIndex;
        return $this;
    }
    /**
     * Get FareNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirFareNote|null
     */
    public function getFareNotes()
    {
        return isset($this->FareNotes) ? $this->FareNotes : null;
    }
    /**
     * Set FareNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirFareNote $fareNotes
     * @return \StructType\AirPricingGroup
     */
    public function setFareNotes(\ArrayType\ArrayOfAirFareNote $fareNotes = null)
    {
        if (is_null($fareNotes) || (is_array($fareNotes) && empty($fareNotes))) {
            unset($this->FareNotes);
        } else {
            $this->FareNotes = $fareNotes;
        }
        return $this;
    }
    /**
     * Get AirPricingGroupOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirPricingGroupOption|null
     */
    public function getAirPricingGroupOptions()
    {
        return isset($this->AirPricingGroupOptions) ? $this->AirPricingGroupOptions : null;
    }
    /**
     * Set AirPricingGroupOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirPricingGroupOption $airPricingGroupOptions
     * @return \StructType\AirPricingGroup
     */
    public function setAirPricingGroupOptions(\ArrayType\ArrayOfAirPricingGroupOption $airPricingGroupOptions = null)
    {
        if (is_null($airPricingGroupOptions) || (is_array($airPricingGroupOptions) && empty($airPricingGroupOptions))) {
            unset($this->AirPricingGroupOptions);
        } else {
            $this->AirPricingGroupOptions = $airPricingGroupOptions;
        }
        return $this;
    }
    /**
     * Get GroupID value
     * @return int|null
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \StructType\AirPricingGroup
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !(is_int($groupID) || ctype_digit($groupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupID, true), gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get IsTourOperator value
     * @return bool|null
     */
    public function getIsTourOperator()
    {
        return $this->IsTourOperator;
    }
    /**
     * Set IsTourOperator value
     * @param bool $isTourOperator
     * @return \StructType\AirPricingGroup
     */
    public function setIsTourOperator($isTourOperator = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTourOperator) && !is_bool($isTourOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTourOperator, true), gettype($isTourOperator)), __LINE__);
        }
        $this->IsTourOperator = $isTourOperator;
        return $this;
    }
}
