<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada para crear una reserva aérea
 * - nillable: true
 * - type: tns:AirBookingRQ
 * @subpackage Structs
 */
class AirBookingRQ extends AbstractStructBase
{
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda a partir del cual estamos generando esta reserva
     * - minOccurs: 0
     * @var int
     */
    public $AvailRequestID;
    /**
     * The AirTravelers
     * Meta information extracted from the WSDL
     * - documentation: Lista de pasajeros que componen la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTraveler
     */
    public $AirTravelers;
    /**
     * The IssuerNotes
     * Meta information extracted from the WSDL
     * - documentation: CAMPO OBSOLETO: este campo está obsoleto y no produce ningun efecto en la reserva, se eliminará en siguientes versiones del interfaz
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuerNotes;
    /**
     * The CustomerNotes
     * Meta information extracted from the WSDL
     * - documentation: CAMPO OBSOLETO: este campo está obsoleto y no produce ningun efecto en la reserva, se eliminará en siguientes versiones del interfaz
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerNotes;
    /**
     * The AgentEmail
     * Meta information extracted from the WSDL
     * - documentation: Email del agente que recibirá una copia de la reserva en cada cambio de estado
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentEmail;
    /**
     * The DestinationContactPhone
     * Meta information extracted from the WSDL
     * - documentation: Telefono de contacto en destino del pasajero responsable de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationContactPhone;
    /**
     * The CancellationInsurance
     * Meta information extracted from the WSDL
     * - documentation: [Obsoleto] Indica si se desea contratar el seguro de cancelación junto con la reserva Importante: esta propiedad deja de ser válida y no se tratará su valor. No implementamos la emisión de seguro para reservas realizadas mediante
     * webservice.
     * - minOccurs: 0
     * @var bool
     */
    public $CancellationInsurance;
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del grupo de precios devuelto por la búsqueda de disponibilidad para el cual se quiere crear la reserva
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupID;
    /**
     * The ItinerariesID
     * Meta information extracted from the WSDL
     * - documentation: Array con los identificadores de los itinerarios devueltos por la búsqueda de disponibilidad para los que se quiere crear la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $ItinerariesID;
    /**
     * The AirCreditCard
     * Meta information extracted from the WSDL
     * - documentation: Tarjeta de crédito para las LowCost
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirCreditCard
     */
    public $AirCreditCard;
    /**
     * The AmountDifference
     * Meta information extracted from the WSDL
     * - documentation: Diferencia de precio para el control del Fee de la tarjeta de credito
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifference;
    /**
     * The AmountDifferenceAccepted
     * Meta information extracted from the WSDL
     * - documentation: Diferencia de precio ACEPTADA como Fee de pago con tarjeta de credito
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifferenceAccepted;
    /**
     * The EmisionSaldo
     * Meta information extracted from the WSDL
     * - documentation: Indica si se realizará una emisión contra Saldo
     * - minOccurs: 0
     * @var bool
     */
    public $EmisionSaldo;
    /**
     * The LuggageRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada que hemos realizado a travelfusion para obtener el equipaje
     * - minOccurs: 0
     * @var int
     */
    public $LuggageRequestID;
    /**
     * The AirAddress
     * Meta information extracted from the WSDL
     * - documentation: Datos facturacion de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirAddress
     */
    public $AirAddress;
    /**
     * The AirBillingInformation
     * Meta information extracted from the WSDL
     * - documentation: Datos facturacion de la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBillingInformation
     */
    public $AirBillingInformation;
    /**
     * The PreCheckNDCID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada que hemos realizado a NDC para el prechequeo
     * - minOccurs: 0
     * @var int
     */
    public $PreCheckNDCID;
    /**
     * The BookingStatusTravelfusion
     * Meta information extracted from the WSDL
     * - documentation: Estado reserva Tf específico que se requiere sea devuelto
     * - minOccurs: 0
     * @var string
     */
    public $BookingStatusTravelfusion;
    /**
     * The CabinBaggageTravelfusion
     * Meta information extracted from the WSDL
     * - documentation: Para el caso de que se haya seleccionado equipaje de mano y particularmente para Ryanair En esta propiedad, se almacena la opción seleccionada y es para toda la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingBaggageLowCostTf
     */
    public $CabinBaggageTravelfusion;
    /**
     * The FareFamiliesBooking
     * Meta information extracted from the WSDL
     * - documentation: Indica si se contratará FareFamilies
     * - minOccurs: 0
     * @var bool
     */
    public $FareFamiliesBooking;
    /**
     * The FareFamiliesRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de FareFamilies a partir del cual estamos generando la reserva
     * - minOccurs: 0
     * @var int
     */
    public $FareFamiliesRequestID;
    /**
     * The FareFamiliesDescription
     * Meta information extracted from the WSDL
     * - documentation: Indica la descripción de las FareFamilies seleccionadas para reservar
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfString_1
     */
    public $FareFamiliesDescription;
    /**
     * Constructor method for AirBookingRQ
     * @uses AirBookingRQ::setAvailRequestID()
     * @uses AirBookingRQ::setAirTravelers()
     * @uses AirBookingRQ::setIssuerNotes()
     * @uses AirBookingRQ::setCustomerNotes()
     * @uses AirBookingRQ::setAgentEmail()
     * @uses AirBookingRQ::setDestinationContactPhone()
     * @uses AirBookingRQ::setCancellationInsurance()
     * @uses AirBookingRQ::setPricingGroupID()
     * @uses AirBookingRQ::setItinerariesID()
     * @uses AirBookingRQ::setAirCreditCard()
     * @uses AirBookingRQ::setAmountDifference()
     * @uses AirBookingRQ::setAmountDifferenceAccepted()
     * @uses AirBookingRQ::setEmisionSaldo()
     * @uses AirBookingRQ::setLuggageRequestID()
     * @uses AirBookingRQ::setAirAddress()
     * @uses AirBookingRQ::setAirBillingInformation()
     * @uses AirBookingRQ::setPreCheckNDCID()
     * @uses AirBookingRQ::setBookingStatusTravelfusion()
     * @uses AirBookingRQ::setCabinBaggageTravelfusion()
     * @uses AirBookingRQ::setFareFamiliesBooking()
     * @uses AirBookingRQ::setFareFamiliesRequestID()
     * @uses AirBookingRQ::setFareFamiliesDescription()
     * @param int $availRequestID
     * @param \ArrayType\ArrayOfAirTraveler $airTravelers
     * @param string $issuerNotes
     * @param string $customerNotes
     * @param string $agentEmail
     * @param string $destinationContactPhone
     * @param bool $cancellationInsurance
     * @param int $pricingGroupID
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @param \StructType\AirCreditCard $airCreditCard
     * @param float $amountDifference
     * @param float $amountDifferenceAccepted
     * @param bool $emisionSaldo
     * @param int $luggageRequestID
     * @param \StructType\AirAddress $airAddress
     * @param \StructType\AirBillingInformation $airBillingInformation
     * @param int $preCheckNDCID
     * @param string $bookingStatusTravelfusion
     * @param \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion
     * @param bool $fareFamiliesBooking
     * @param int $fareFamiliesRequestID
     * @param \ArrayType\ArrayOfString_1 $fareFamiliesDescription
     */
    public function __construct($availRequestID = null, \ArrayType\ArrayOfAirTraveler $airTravelers = null, $issuerNotes = null, $customerNotes = null, $agentEmail = null, $destinationContactPhone = null, $cancellationInsurance = null, $pricingGroupID = null, \ArrayType\ArrayOfInt $itinerariesID = null, \StructType\AirCreditCard $airCreditCard = null, $amountDifference = null, $amountDifferenceAccepted = null, $emisionSaldo = null, $luggageRequestID = null, \StructType\AirAddress $airAddress = null, \StructType\AirBillingInformation $airBillingInformation = null, $preCheckNDCID = null, $bookingStatusTravelfusion = null, \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion = null, $fareFamiliesBooking = null, $fareFamiliesRequestID = null, \ArrayType\ArrayOfString_1 $fareFamiliesDescription = null)
    {
        $this
            ->setAvailRequestID($availRequestID)
            ->setAirTravelers($airTravelers)
            ->setIssuerNotes($issuerNotes)
            ->setCustomerNotes($customerNotes)
            ->setAgentEmail($agentEmail)
            ->setDestinationContactPhone($destinationContactPhone)
            ->setCancellationInsurance($cancellationInsurance)
            ->setPricingGroupID($pricingGroupID)
            ->setItinerariesID($itinerariesID)
            ->setAirCreditCard($airCreditCard)
            ->setAmountDifference($amountDifference)
            ->setAmountDifferenceAccepted($amountDifferenceAccepted)
            ->setEmisionSaldo($emisionSaldo)
            ->setLuggageRequestID($luggageRequestID)
            ->setAirAddress($airAddress)
            ->setAirBillingInformation($airBillingInformation)
            ->setPreCheckNDCID($preCheckNDCID)
            ->setBookingStatusTravelfusion($bookingStatusTravelfusion)
            ->setCabinBaggageTravelfusion($cabinBaggageTravelfusion)
            ->setFareFamiliesBooking($fareFamiliesBooking)
            ->setFareFamiliesRequestID($fareFamiliesRequestID)
            ->setFareFamiliesDescription($fareFamiliesDescription);
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirBookingRQ
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get AirTravelers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTraveler|null
     */
    public function getAirTravelers()
    {
        return isset($this->AirTravelers) ? $this->AirTravelers : null;
    }
    /**
     * Set AirTravelers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTraveler $airTravelers
     * @return \StructType\AirBookingRQ
     */
    public function setAirTravelers(\ArrayType\ArrayOfAirTraveler $airTravelers = null)
    {
        if (is_null($airTravelers) || (is_array($airTravelers) && empty($airTravelers))) {
            unset($this->AirTravelers);
        } else {
            $this->AirTravelers = $airTravelers;
        }
        return $this;
    }
    /**
     * Get IssuerNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuerNotes()
    {
        return isset($this->IssuerNotes) ? $this->IssuerNotes : null;
    }
    /**
     * Set IssuerNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuerNotes
     * @return \StructType\AirBookingRQ
     */
    public function setIssuerNotes($issuerNotes = null)
    {
        // validation for constraint: string
        if (!is_null($issuerNotes) && !is_string($issuerNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuerNotes, true), gettype($issuerNotes)), __LINE__);
        }
        if (is_null($issuerNotes) || (is_array($issuerNotes) && empty($issuerNotes))) {
            unset($this->IssuerNotes);
        } else {
            $this->IssuerNotes = $issuerNotes;
        }
        return $this;
    }
    /**
     * Get CustomerNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerNotes()
    {
        return isset($this->CustomerNotes) ? $this->CustomerNotes : null;
    }
    /**
     * Set CustomerNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerNotes
     * @return \StructType\AirBookingRQ
     */
    public function setCustomerNotes($customerNotes = null)
    {
        // validation for constraint: string
        if (!is_null($customerNotes) && !is_string($customerNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNotes, true), gettype($customerNotes)), __LINE__);
        }
        if (is_null($customerNotes) || (is_array($customerNotes) && empty($customerNotes))) {
            unset($this->CustomerNotes);
        } else {
            $this->CustomerNotes = $customerNotes;
        }
        return $this;
    }
    /**
     * Get AgentEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentEmail()
    {
        return isset($this->AgentEmail) ? $this->AgentEmail : null;
    }
    /**
     * Set AgentEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentEmail
     * @return \StructType\AirBookingRQ
     */
    public function setAgentEmail($agentEmail = null)
    {
        // validation for constraint: string
        if (!is_null($agentEmail) && !is_string($agentEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentEmail, true), gettype($agentEmail)), __LINE__);
        }
        if (is_null($agentEmail) || (is_array($agentEmail) && empty($agentEmail))) {
            unset($this->AgentEmail);
        } else {
            $this->AgentEmail = $agentEmail;
        }
        return $this;
    }
    /**
     * Get DestinationContactPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationContactPhone()
    {
        return isset($this->DestinationContactPhone) ? $this->DestinationContactPhone : null;
    }
    /**
     * Set DestinationContactPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationContactPhone
     * @return \StructType\AirBookingRQ
     */
    public function setDestinationContactPhone($destinationContactPhone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationContactPhone) && !is_string($destinationContactPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationContactPhone, true), gettype($destinationContactPhone)), __LINE__);
        }
        if (is_null($destinationContactPhone) || (is_array($destinationContactPhone) && empty($destinationContactPhone))) {
            unset($this->DestinationContactPhone);
        } else {
            $this->DestinationContactPhone = $destinationContactPhone;
        }
        return $this;
    }
    /**
     * Get CancellationInsurance value
     * @return bool|null
     */
    public function getCancellationInsurance()
    {
        return $this->CancellationInsurance;
    }
    /**
     * Set CancellationInsurance value
     * @param bool $cancellationInsurance
     * @return \StructType\AirBookingRQ
     */
    public function setCancellationInsurance($cancellationInsurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellationInsurance) && !is_bool($cancellationInsurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellationInsurance, true), gettype($cancellationInsurance)), __LINE__);
        }
        $this->CancellationInsurance = $cancellationInsurance;
        return $this;
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirBookingRQ
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get ItinerariesID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItinerariesID()
    {
        return isset($this->ItinerariesID) ? $this->ItinerariesID : null;
    }
    /**
     * Set ItinerariesID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @return \StructType\AirBookingRQ
     */
    public function setItinerariesID(\ArrayType\ArrayOfInt $itinerariesID = null)
    {
        if (is_null($itinerariesID) || (is_array($itinerariesID) && empty($itinerariesID))) {
            unset($this->ItinerariesID);
        } else {
            $this->ItinerariesID = $itinerariesID;
        }
        return $this;
    }
    /**
     * Get AirCreditCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirCreditCard|null
     */
    public function getAirCreditCard()
    {
        return isset($this->AirCreditCard) ? $this->AirCreditCard : null;
    }
    /**
     * Set AirCreditCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirCreditCard $airCreditCard
     * @return \StructType\AirBookingRQ
     */
    public function setAirCreditCard(\StructType\AirCreditCard $airCreditCard = null)
    {
        if (is_null($airCreditCard) || (is_array($airCreditCard) && empty($airCreditCard))) {
            unset($this->AirCreditCard);
        } else {
            $this->AirCreditCard = $airCreditCard;
        }
        return $this;
    }
    /**
     * Get AmountDifference value
     * @return float|null
     */
    public function getAmountDifference()
    {
        return $this->AmountDifference;
    }
    /**
     * Set AmountDifference value
     * @param float $amountDifference
     * @return \StructType\AirBookingRQ
     */
    public function setAmountDifference($amountDifference = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifference) && !(is_float($amountDifference) || is_numeric($amountDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifference, true), gettype($amountDifference)), __LINE__);
        }
        $this->AmountDifference = $amountDifference;
        return $this;
    }
    /**
     * Get AmountDifferenceAccepted value
     * @return float|null
     */
    public function getAmountDifferenceAccepted()
    {
        return $this->AmountDifferenceAccepted;
    }
    /**
     * Set AmountDifferenceAccepted value
     * @param float $amountDifferenceAccepted
     * @return \StructType\AirBookingRQ
     */
    public function setAmountDifferenceAccepted($amountDifferenceAccepted = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifferenceAccepted) && !(is_float($amountDifferenceAccepted) || is_numeric($amountDifferenceAccepted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifferenceAccepted, true), gettype($amountDifferenceAccepted)), __LINE__);
        }
        $this->AmountDifferenceAccepted = $amountDifferenceAccepted;
        return $this;
    }
    /**
     * Get EmisionSaldo value
     * @return bool|null
     */
    public function getEmisionSaldo()
    {
        return $this->EmisionSaldo;
    }
    /**
     * Set EmisionSaldo value
     * @param bool $emisionSaldo
     * @return \StructType\AirBookingRQ
     */
    public function setEmisionSaldo($emisionSaldo = null)
    {
        // validation for constraint: boolean
        if (!is_null($emisionSaldo) && !is_bool($emisionSaldo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emisionSaldo, true), gettype($emisionSaldo)), __LINE__);
        }
        $this->EmisionSaldo = $emisionSaldo;
        return $this;
    }
    /**
     * Get LuggageRequestID value
     * @return int|null
     */
    public function getLuggageRequestID()
    {
        return $this->LuggageRequestID;
    }
    /**
     * Set LuggageRequestID value
     * @param int $luggageRequestID
     * @return \StructType\AirBookingRQ
     */
    public function setLuggageRequestID($luggageRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($luggageRequestID) && !(is_int($luggageRequestID) || ctype_digit($luggageRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($luggageRequestID, true), gettype($luggageRequestID)), __LINE__);
        }
        $this->LuggageRequestID = $luggageRequestID;
        return $this;
    }
    /**
     * Get AirAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirAddress|null
     */
    public function getAirAddress()
    {
        return isset($this->AirAddress) ? $this->AirAddress : null;
    }
    /**
     * Set AirAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirAddress $airAddress
     * @return \StructType\AirBookingRQ
     */
    public function setAirAddress(\StructType\AirAddress $airAddress = null)
    {
        if (is_null($airAddress) || (is_array($airAddress) && empty($airAddress))) {
            unset($this->AirAddress);
        } else {
            $this->AirAddress = $airAddress;
        }
        return $this;
    }
    /**
     * Get AirBillingInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBillingInformation|null
     */
    public function getAirBillingInformation()
    {
        return isset($this->AirBillingInformation) ? $this->AirBillingInformation : null;
    }
    /**
     * Set AirBillingInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBillingInformation $airBillingInformation
     * @return \StructType\AirBookingRQ
     */
    public function setAirBillingInformation(\StructType\AirBillingInformation $airBillingInformation = null)
    {
        if (is_null($airBillingInformation) || (is_array($airBillingInformation) && empty($airBillingInformation))) {
            unset($this->AirBillingInformation);
        } else {
            $this->AirBillingInformation = $airBillingInformation;
        }
        return $this;
    }
    /**
     * Get PreCheckNDCID value
     * @return int|null
     */
    public function getPreCheckNDCID()
    {
        return $this->PreCheckNDCID;
    }
    /**
     * Set PreCheckNDCID value
     * @param int $preCheckNDCID
     * @return \StructType\AirBookingRQ
     */
    public function setPreCheckNDCID($preCheckNDCID = null)
    {
        // validation for constraint: int
        if (!is_null($preCheckNDCID) && !(is_int($preCheckNDCID) || ctype_digit($preCheckNDCID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preCheckNDCID, true), gettype($preCheckNDCID)), __LINE__);
        }
        $this->PreCheckNDCID = $preCheckNDCID;
        return $this;
    }
    /**
     * Get BookingStatusTravelfusion value
     * @return string|null
     */
    public function getBookingStatusTravelfusion()
    {
        return $this->BookingStatusTravelfusion;
    }
    /**
     * Set BookingStatusTravelfusion value
     * @uses \EnumType\Enumeraciones_StatusBookingTravelfusion::valueIsValid()
     * @uses \EnumType\Enumeraciones_StatusBookingTravelfusion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bookingStatusTravelfusion
     * @return \StructType\AirBookingRQ
     */
    public function setBookingStatusTravelfusion($bookingStatusTravelfusion = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumeraciones_StatusBookingTravelfusion::valueIsValid($bookingStatusTravelfusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumeraciones_StatusBookingTravelfusion', is_array($bookingStatusTravelfusion) ? implode(', ', $bookingStatusTravelfusion) : var_export($bookingStatusTravelfusion, true), implode(', ', \EnumType\Enumeraciones_StatusBookingTravelfusion::getValidValues())), __LINE__);
        }
        $this->BookingStatusTravelfusion = $bookingStatusTravelfusion;
        return $this;
    }
    /**
     * Get CabinBaggageTravelfusion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingBaggageLowCostTf|null
     */
    public function getCabinBaggageTravelfusion()
    {
        return isset($this->CabinBaggageTravelfusion) ? $this->CabinBaggageTravelfusion : null;
    }
    /**
     * Set CabinBaggageTravelfusion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion
     * @return \StructType\AirBookingRQ
     */
    public function setCabinBaggageTravelfusion(\StructType\AirBookingBaggageLowCostTf $cabinBaggageTravelfusion = null)
    {
        if (is_null($cabinBaggageTravelfusion) || (is_array($cabinBaggageTravelfusion) && empty($cabinBaggageTravelfusion))) {
            unset($this->CabinBaggageTravelfusion);
        } else {
            $this->CabinBaggageTravelfusion = $cabinBaggageTravelfusion;
        }
        return $this;
    }
    /**
     * Get FareFamiliesBooking value
     * @return bool|null
     */
    public function getFareFamiliesBooking()
    {
        return $this->FareFamiliesBooking;
    }
    /**
     * Set FareFamiliesBooking value
     * @param bool $fareFamiliesBooking
     * @return \StructType\AirBookingRQ
     */
    public function setFareFamiliesBooking($fareFamiliesBooking = null)
    {
        // validation for constraint: boolean
        if (!is_null($fareFamiliesBooking) && !is_bool($fareFamiliesBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fareFamiliesBooking, true), gettype($fareFamiliesBooking)), __LINE__);
        }
        $this->FareFamiliesBooking = $fareFamiliesBooking;
        return $this;
    }
    /**
     * Get FareFamiliesRequestID value
     * @return int|null
     */
    public function getFareFamiliesRequestID()
    {
        return $this->FareFamiliesRequestID;
    }
    /**
     * Set FareFamiliesRequestID value
     * @param int $fareFamiliesRequestID
     * @return \StructType\AirBookingRQ
     */
    public function setFareFamiliesRequestID($fareFamiliesRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($fareFamiliesRequestID) && !(is_int($fareFamiliesRequestID) || ctype_digit($fareFamiliesRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fareFamiliesRequestID, true), gettype($fareFamiliesRequestID)), __LINE__);
        }
        $this->FareFamiliesRequestID = $fareFamiliesRequestID;
        return $this;
    }
    /**
     * Get FareFamiliesDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfString_1|null
     */
    public function getFareFamiliesDescription()
    {
        return isset($this->FareFamiliesDescription) ? $this->FareFamiliesDescription : null;
    }
    /**
     * Set FareFamiliesDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfString_1 $fareFamiliesDescription
     * @return \StructType\AirBookingRQ
     */
    public function setFareFamiliesDescription(\ArrayType\ArrayOfString_1 $fareFamiliesDescription = null)
    {
        if (is_null($fareFamiliesDescription) || (is_array($fareFamiliesDescription) && empty($fareFamiliesDescription))) {
            unset($this->FareFamiliesDescription);
        } else {
            $this->FareFamiliesDescription = $fareFamiliesDescription;
        }
        return $this;
    }
}
