<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingPaxFaresRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa las lineas de tarifas disponibles para un pasajero
 * - nillable: true
 * - type: tns:AirBookingPaxFaresRS
 * @subpackage Structs
 */
class AirBookingPaxFaresRS extends AbstractStructBase
{
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al metodo invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de reserva para la que se devuelven las tarifas
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The TravelerID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del pasajero para el que se devuelven las tarifas
     * - minOccurs: 0
     * @var int
     */
    public $TravelerID;
    /**
     * The AirBookingPaxFares
     * Meta information extracted from the WSDL
     * - documentation: Lista con las tarifas disponibles (null en caso de error)
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingPaxFare
     */
    public $AirBookingPaxFares;
    /**
     * The AirBookingFlightSegments
     * Meta information extracted from the WSDL
     * - documentation: Lista de segmentos de vuelo que componen la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFlightSegment
     */
    public $AirBookingFlightSegments;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de crear, editar o cancelar la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirBookingPaxFaresRS
     * @uses AirBookingPaxFaresRS::setRequestID()
     * @uses AirBookingPaxFaresRS::setBookingID()
     * @uses AirBookingPaxFaresRS::setTravelerID()
     * @uses AirBookingPaxFaresRS::setAirBookingPaxFares()
     * @uses AirBookingPaxFaresRS::setAirBookingFlightSegments()
     * @uses AirBookingPaxFaresRS::setError()
     * @param int $requestID
     * @param int $bookingID
     * @param int $travelerID
     * @param \ArrayType\ArrayOfAirBookingPaxFare $airBookingPaxFares
     * @param \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments
     * @param \StructType\ResponseError $error
     */
    public function __construct($requestID = null, $bookingID = null, $travelerID = null, \ArrayType\ArrayOfAirBookingPaxFare $airBookingPaxFares = null, \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setRequestID($requestID)
            ->setBookingID($bookingID)
            ->setTravelerID($travelerID)
            ->setAirBookingPaxFares($airBookingPaxFares)
            ->setAirBookingFlightSegments($airBookingFlightSegments)
            ->setError($error);
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirBookingPaxFaresRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingPaxFaresRS
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get TravelerID value
     * @return int|null
     */
    public function getTravelerID()
    {
        return $this->TravelerID;
    }
    /**
     * Set TravelerID value
     * @param int $travelerID
     * @return \StructType\AirBookingPaxFaresRS
     */
    public function setTravelerID($travelerID = null)
    {
        // validation for constraint: int
        if (!is_null($travelerID) && !(is_int($travelerID) || ctype_digit($travelerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerID, true), gettype($travelerID)), __LINE__);
        }
        $this->TravelerID = $travelerID;
        return $this;
    }
    /**
     * Get AirBookingPaxFares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingPaxFare|null
     */
    public function getAirBookingPaxFares()
    {
        return isset($this->AirBookingPaxFares) ? $this->AirBookingPaxFares : null;
    }
    /**
     * Set AirBookingPaxFares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingPaxFare $airBookingPaxFares
     * @return \StructType\AirBookingPaxFaresRS
     */
    public function setAirBookingPaxFares(\ArrayType\ArrayOfAirBookingPaxFare $airBookingPaxFares = null)
    {
        if (is_null($airBookingPaxFares) || (is_array($airBookingPaxFares) && empty($airBookingPaxFares))) {
            unset($this->AirBookingPaxFares);
        } else {
            $this->AirBookingPaxFares = $airBookingPaxFares;
        }
        return $this;
    }
    /**
     * Get AirBookingFlightSegments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFlightSegment|null
     */
    public function getAirBookingFlightSegments()
    {
        return isset($this->AirBookingFlightSegments) ? $this->AirBookingFlightSegments : null;
    }
    /**
     * Set AirBookingFlightSegments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments
     * @return \StructType\AirBookingPaxFaresRS
     */
    public function setAirBookingFlightSegments(\ArrayType\ArrayOfAirBookingFlightSegment $airBookingFlightSegments = null)
    {
        if (is_null($airBookingFlightSegments) || (is_array($airBookingFlightSegments) && empty($airBookingFlightSegments))) {
            unset($this->AirBookingFlightSegments);
        } else {
            $this->AirBookingFlightSegments = $airBookingFlightSegments;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingPaxFaresRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
