<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingFlightSegment StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un segmento de vuelo de una reserva
 * - nillable: true
 * - type: tns:AirBookingFlightSegment
 * @subpackage Structs
 */
class AirBookingFlightSegment extends AbstractStructBase
{
    /**
     * The SegmentNumber
     * Meta information extracted from the WSDL
     * - documentation: El numero de segmento en el viaje (ida = 1, vuelta = 2, multidestino = x)
     * - minOccurs: 0
     * @var int
     */
    public $SegmentNumber;
    /**
     * The TotalDuration
     * Meta information extracted from the WSDL
     * - documentation: Duracion en formato 02:59 que indica la cantidad total de horas y minutos necesarios para completar el segmento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TotalDuration;
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código del aeropuerto de origen
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código del aeropuerto de destino
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de salida (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de llegada (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FlightSegmentLegs
     * Meta information extracted from the WSDL
     * - documentation: Lista de trayectos o patas que componen el segmento
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingFlightSegmentLeg
     */
    public $FlightSegmentLegs;
    /**
     * Constructor method for AirBookingFlightSegment
     * @uses AirBookingFlightSegment::setSegmentNumber()
     * @uses AirBookingFlightSegment::setTotalDuration()
     * @uses AirBookingFlightSegment::setDepartureAirportLocationCode()
     * @uses AirBookingFlightSegment::setArrivalAirportLocationCode()
     * @uses AirBookingFlightSegment::setDepartureDateTime()
     * @uses AirBookingFlightSegment::setArrivalDateTime()
     * @uses AirBookingFlightSegment::setFlightSegmentLegs()
     * @param int $segmentNumber
     * @param string $totalDuration
     * @param string $departureAirportLocationCode
     * @param string $arrivalAirportLocationCode
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param \ArrayType\ArrayOfAirBookingFlightSegmentLeg $flightSegmentLegs
     */
    public function __construct($segmentNumber = null, $totalDuration = null, $departureAirportLocationCode = null, $arrivalAirportLocationCode = null, $departureDateTime = null, $arrivalDateTime = null, \ArrayType\ArrayOfAirBookingFlightSegmentLeg $flightSegmentLegs = null)
    {
        $this
            ->setSegmentNumber($segmentNumber)
            ->setTotalDuration($totalDuration)
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFlightSegmentLegs($flightSegmentLegs);
    }
    /**
     * Get SegmentNumber value
     * @return int|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param int $segmentNumber
     * @return \StructType\AirBookingFlightSegment
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($segmentNumber) && !(is_int($segmentNumber) || ctype_digit($segmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segmentNumber, true), gettype($segmentNumber)), __LINE__);
        }
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get TotalDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTotalDuration()
    {
        return isset($this->TotalDuration) ? $this->TotalDuration : null;
    }
    /**
     * Set TotalDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $totalDuration
     * @return \StructType\AirBookingFlightSegment
     */
    public function setTotalDuration($totalDuration = null)
    {
        // validation for constraint: string
        if (!is_null($totalDuration) && !is_string($totalDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalDuration, true), gettype($totalDuration)), __LINE__);
        }
        if (is_null($totalDuration) || (is_array($totalDuration) && empty($totalDuration))) {
            unset($this->TotalDuration);
        } else {
            $this->TotalDuration = $totalDuration;
        }
        return $this;
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirBookingFlightSegment
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirBookingFlightSegment
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * Set DepartureDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDateTime
     * @return \StructType\AirBookingFlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return isset($this->ArrivalDateTime) ? $this->ArrivalDateTime : null;
    }
    /**
     * Set ArrivalDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalDateTime
     * @return \StructType\AirBookingFlightSegment
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        if (is_null($arrivalDateTime) || (is_array($arrivalDateTime) && empty($arrivalDateTime))) {
            unset($this->ArrivalDateTime);
        } else {
            $this->ArrivalDateTime = $arrivalDateTime;
        }
        return $this;
    }
    /**
     * Get FlightSegmentLegs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingFlightSegmentLeg|null
     */
    public function getFlightSegmentLegs()
    {
        return isset($this->FlightSegmentLegs) ? $this->FlightSegmentLegs : null;
    }
    /**
     * Set FlightSegmentLegs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingFlightSegmentLeg $flightSegmentLegs
     * @return \StructType\AirBookingFlightSegment
     */
    public function setFlightSegmentLegs(\ArrayType\ArrayOfAirBookingFlightSegmentLeg $flightSegmentLegs = null)
    {
        if (is_null($flightSegmentLegs) || (is_array($flightSegmentLegs) && empty($flightSegmentLegs))) {
            unset($this->FlightSegmentLegs);
        } else {
            $this->FlightSegmentLegs = $flightSegmentLegs;
        }
        return $this;
    }
}
