<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingBaggageNDC StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto auxiliar para contener los equipajes - DTO con la forma del equipaje de NDC
 * - nillable: true
 * - type: tns:AirBookingBaggageNDC
 * @subpackage Structs
 */
class AirBookingBaggageNDC extends AbstractStructBase
{
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: El número de servicio de equipaje
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceID;
    /**
     * The CantidadMaximaReservable
     * Meta information extracted from the WSDL
     * - documentation: Indica el número máximo de maletas por pasajero que se puede reservar de este servicio
     * - minOccurs: 0
     * @var int
     */
    public $CantidadMaximaReservable;
    /**
     * The PesoMax
     * Meta information extracted from the WSDL
     * - documentation: Peso max. Valido para guardar en BBDD
     * - minOccurs: 0
     * @var float
     */
    public $PesoMax;
    /**
     * The ByPax
     * Meta information extracted from the WSDL
     * - documentation: Indica si se puede contratar por cada pasajero o para la reserva
     * - minOccurs: 0
     * @var bool
     */
    public $ByPax;
    /**
     * The LuggageOption
     * Meta information extracted from the WSDL
     * - documentation: Indica el tipo de opcion de equipaje que se ha seleccionado
     * - minOccurs: 0
     * @var string
     */
    public $LuggageOption;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: Precio del equipaje
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Peso y numero de piezas de la opcion seleccionada
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The CantidadAReservar
     * Meta information extracted from the WSDL
     * - documentation: Indica la cantidad a reservar
     * - minOccurs: 0
     * @var int
     */
    public $CantidadAReservar;
    /**
     * The ListKey
     * Meta information extracted from the WSDL
     * - documentation: Lista a la que pertenece el servicio, si aplica.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListKey;
    /**
     * The PaxID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de pasajero (PAX1, PAX2, etc)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaxID;
    /**
     * The PaxType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de Pasajero (ADT, CHD, INF)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaxType;
    /**
     * The OfferID
     * Meta information extracted from the WSDL
     * - documentation: El OfferID de equipaje
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OfferID;
    /**
     * The OfferItemID
     * Meta information extracted from the WSDL
     * - documentation: El OfferItemID de equipaje
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OfferItemID;
    /**
     * Constructor method for AirBookingBaggageNDC
     * @uses AirBookingBaggageNDC::setServiceID()
     * @uses AirBookingBaggageNDC::setCantidadMaximaReservable()
     * @uses AirBookingBaggageNDC::setPesoMax()
     * @uses AirBookingBaggageNDC::setByPax()
     * @uses AirBookingBaggageNDC::setLuggageOption()
     * @uses AirBookingBaggageNDC::setPrice()
     * @uses AirBookingBaggageNDC::setDescription()
     * @uses AirBookingBaggageNDC::setCantidadAReservar()
     * @uses AirBookingBaggageNDC::setListKey()
     * @uses AirBookingBaggageNDC::setPaxID()
     * @uses AirBookingBaggageNDC::setPaxType()
     * @uses AirBookingBaggageNDC::setOfferID()
     * @uses AirBookingBaggageNDC::setOfferItemID()
     * @param string $serviceID
     * @param int $cantidadMaximaReservable
     * @param float $pesoMax
     * @param bool $byPax
     * @param string $luggageOption
     * @param float $price
     * @param string $description
     * @param int $cantidadAReservar
     * @param string $listKey
     * @param string $paxID
     * @param string $paxType
     * @param string $offerID
     * @param string $offerItemID
     */
    public function __construct($serviceID = null, $cantidadMaximaReservable = null, $pesoMax = null, $byPax = null, $luggageOption = null, $price = null, $description = null, $cantidadAReservar = null, $listKey = null, $paxID = null, $paxType = null, $offerID = null, $offerItemID = null)
    {
        $this
            ->setServiceID($serviceID)
            ->setCantidadMaximaReservable($cantidadMaximaReservable)
            ->setPesoMax($pesoMax)
            ->setByPax($byPax)
            ->setLuggageOption($luggageOption)
            ->setPrice($price)
            ->setDescription($description)
            ->setCantidadAReservar($cantidadAReservar)
            ->setListKey($listKey)
            ->setPaxID($paxID)
            ->setPaxType($paxType)
            ->setOfferID($offerID)
            ->setOfferItemID($offerItemID);
    }
    /**
     * Get ServiceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceID()
    {
        return isset($this->ServiceID) ? $this->ServiceID : null;
    }
    /**
     * Set ServiceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceID
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        if (is_null($serviceID) || (is_array($serviceID) && empty($serviceID))) {
            unset($this->ServiceID);
        } else {
            $this->ServiceID = $serviceID;
        }
        return $this;
    }
    /**
     * Get CantidadMaximaReservable value
     * @return int|null
     */
    public function getCantidadMaximaReservable()
    {
        return $this->CantidadMaximaReservable;
    }
    /**
     * Set CantidadMaximaReservable value
     * @param int $cantidadMaximaReservable
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setCantidadMaximaReservable($cantidadMaximaReservable = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadMaximaReservable) && !(is_int($cantidadMaximaReservable) || ctype_digit($cantidadMaximaReservable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadMaximaReservable, true), gettype($cantidadMaximaReservable)), __LINE__);
        }
        $this->CantidadMaximaReservable = $cantidadMaximaReservable;
        return $this;
    }
    /**
     * Get PesoMax value
     * @return float|null
     */
    public function getPesoMax()
    {
        return $this->PesoMax;
    }
    /**
     * Set PesoMax value
     * @param float $pesoMax
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setPesoMax($pesoMax = null)
    {
        // validation for constraint: float
        if (!is_null($pesoMax) && !(is_float($pesoMax) || is_numeric($pesoMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pesoMax, true), gettype($pesoMax)), __LINE__);
        }
        $this->PesoMax = $pesoMax;
        return $this;
    }
    /**
     * Get ByPax value
     * @return bool|null
     */
    public function getByPax()
    {
        return $this->ByPax;
    }
    /**
     * Set ByPax value
     * @param bool $byPax
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setByPax($byPax = null)
    {
        // validation for constraint: boolean
        if (!is_null($byPax) && !is_bool($byPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($byPax, true), gettype($byPax)), __LINE__);
        }
        $this->ByPax = $byPax;
        return $this;
    }
    /**
     * Get LuggageOption value
     * @return string|null
     */
    public function getLuggageOption()
    {
        return $this->LuggageOption;
    }
    /**
     * Set LuggageOption value
     * @uses \EnumType\Enums_NDCOpcionEquipaje::valueIsValid()
     * @uses \EnumType\Enums_NDCOpcionEquipaje::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $luggageOption
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setLuggageOption($luggageOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enums_NDCOpcionEquipaje::valueIsValid($luggageOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enums_NDCOpcionEquipaje', is_array($luggageOption) ? implode(', ', $luggageOption) : var_export($luggageOption, true), implode(', ', \EnumType\Enums_NDCOpcionEquipaje::getValidValues())), __LINE__);
        }
        $this->LuggageOption = $luggageOption;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get CantidadAReservar value
     * @return int|null
     */
    public function getCantidadAReservar()
    {
        return $this->CantidadAReservar;
    }
    /**
     * Set CantidadAReservar value
     * @param int $cantidadAReservar
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setCantidadAReservar($cantidadAReservar = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadAReservar) && !(is_int($cantidadAReservar) || ctype_digit($cantidadAReservar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadAReservar, true), gettype($cantidadAReservar)), __LINE__);
        }
        $this->CantidadAReservar = $cantidadAReservar;
        return $this;
    }
    /**
     * Get ListKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListKey()
    {
        return isset($this->ListKey) ? $this->ListKey : null;
    }
    /**
     * Set ListKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listKey
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setListKey($listKey = null)
    {
        // validation for constraint: string
        if (!is_null($listKey) && !is_string($listKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listKey, true), gettype($listKey)), __LINE__);
        }
        if (is_null($listKey) || (is_array($listKey) && empty($listKey))) {
            unset($this->ListKey);
        } else {
            $this->ListKey = $listKey;
        }
        return $this;
    }
    /**
     * Get PaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaxID()
    {
        return isset($this->PaxID) ? $this->PaxID : null;
    }
    /**
     * Set PaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paxID
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setPaxID($paxID = null)
    {
        // validation for constraint: string
        if (!is_null($paxID) && !is_string($paxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxID, true), gettype($paxID)), __LINE__);
        }
        if (is_null($paxID) || (is_array($paxID) && empty($paxID))) {
            unset($this->PaxID);
        } else {
            $this->PaxID = $paxID;
        }
        return $this;
    }
    /**
     * Get PaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaxType()
    {
        return isset($this->PaxType) ? $this->PaxType : null;
    }
    /**
     * Set PaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paxType
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setPaxType($paxType = null)
    {
        // validation for constraint: string
        if (!is_null($paxType) && !is_string($paxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxType, true), gettype($paxType)), __LINE__);
        }
        if (is_null($paxType) || (is_array($paxType) && empty($paxType))) {
            unset($this->PaxType);
        } else {
            $this->PaxType = $paxType;
        }
        return $this;
    }
    /**
     * Get OfferID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOfferID()
    {
        return isset($this->OfferID) ? $this->OfferID : null;
    }
    /**
     * Set OfferID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $offerID
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setOfferID($offerID = null)
    {
        // validation for constraint: string
        if (!is_null($offerID) && !is_string($offerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerID, true), gettype($offerID)), __LINE__);
        }
        if (is_null($offerID) || (is_array($offerID) && empty($offerID))) {
            unset($this->OfferID);
        } else {
            $this->OfferID = $offerID;
        }
        return $this;
    }
    /**
     * Get OfferItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOfferItemID()
    {
        return isset($this->OfferItemID) ? $this->OfferItemID : null;
    }
    /**
     * Set OfferItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $offerItemID
     * @return \StructType\AirBookingBaggageNDC
     */
    public function setOfferItemID($offerItemID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemID) && !is_string($offerItemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemID, true), gettype($offerItemID)), __LINE__);
        }
        if (is_null($offerItemID) || (is_array($offerItemID) && empty($offerItemID))) {
            unset($this->OfferItemID);
        } else {
            $this->OfferItemID = $offerItemID;
        }
        return $this;
    }
}
