<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa el resultado de una búsqueda
 * - nillable: true
 * - type: tns:AirAvailRS
 * @subpackage Structs
 */
class AirAvailRS extends AbstractStructBase
{
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único de la peticion que se realiza al webservice del motor
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * The AirAvail
     * Meta information extracted from the WSDL
     * - documentation: Resultado de la búsqueda (null en caso de error)
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirAvail
     */
    public $AirAvail;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de realizar la búsqueda
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirAvailRS
     * @uses AirAvailRS::setRequestID()
     * @uses AirAvailRS::setAirAvail()
     * @uses AirAvailRS::setError()
     * @param int $requestID
     * @param \StructType\AirAvail $airAvail
     * @param \StructType\ResponseError $error
     */
    public function __construct($requestID = null, \StructType\AirAvail $airAvail = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setRequestID($requestID)
            ->setAirAvail($airAvail)
            ->setError($error);
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirAvailRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get AirAvail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirAvail|null
     */
    public function getAirAvail()
    {
        return isset($this->AirAvail) ? $this->AirAvail : null;
    }
    /**
     * Set AirAvail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirAvail $airAvail
     * @return \StructType\AirAvailRS
     */
    public function setAirAvail(\StructType\AirAvail $airAvail = null)
    {
        if (is_null($airAvail) || (is_array($airAvail) && empty($airAvail))) {
            unset($this->AirAvail);
        } else {
            $this->AirAvail = $airAvail;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirAvailRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
