<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Air ServiceType
 * @subpackage Services
 */
class Air extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AirDestinationAirportsList
     * Meta information extracted from the WSDL
     * - documentation: Devuelve los codigos de aeropuerto y ciudades activos@param credentials credenciales de autenticación@return Lista de objetos AirDestinationAirport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirDestinationAirportsList $parameters
     * @return \StructType\AirDestinationAirportsListResponse|bool
     */
    public function AirDestinationAirportsList(\StructType\AirDestinationAirportsList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirDestinationAirportsList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirMunicipalCodeList
     * Meta information extracted from the WSDL
     * - documentation: Devuelve los codigos de municipio a partir de una lista de destinos@param credentials credenciales de autenticación@param lstIata Lista de Iatas para obtener los municipios, ej: IBZ, PMI@return Lista de objetos AirMunicipalCode con
     * los codigos de municipio
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirMunicipalCodeList $parameters
     * @return \StructType\AirMunicipalCodeListResponse|bool
     */
    public function AirMunicipalCodeList(\StructType\AirMunicipalCodeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirMunicipalCodeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirAvailSearch
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el resultado de la búsqueda normal de aereos@param credentials credenciales de autenticación@param availRQ objeto con los criterios de búsqueda@return resultado de la búsqueda de disponibilidad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirAvailSearch $parameters
     * @return \StructType\AirAvailSearchResponse|bool
     */
    public function AirAvailSearch(\StructType\AirAvailSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirAvailSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirAvailMultiSegmentSearch
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el resultado de la búsqueda multidestino de aereos@param credentials credenciales de autenticación@param availRQ objeto con los criterios de búsqueda@return resultado de la búsqueda de disponibilidad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirAvailMultiSegmentSearch $parameters
     * @return \StructType\AirAvailMultiSegmentSearchResponse|bool
     */
    public function AirAvailMultiSegmentSearch(\StructType\AirAvailMultiSegmentSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirAvailMultiSegmentSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirAvailCalendarSearch
     * Meta information extracted from the WSDL
     * - documentation: Devuelve el resultado de la búsqueda de aereos con calendario@param credentials credenciales de autenticación@param availRQ objeto con los criterios de búsqueda@return resultado de la búsqueda de disponibilidad
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirAvailCalendarSearch $parameters
     * @return \StructType\AirAvailCalendarSearchResponse|bool
     */
    public function AirAvailCalendarSearch(\StructType\AirAvailCalendarSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirAvailCalendarSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirAvailGetRateNotes
     * Meta information extracted from the WSDL
     * - documentation: Recupera las notas de tarifa para el resultado de una búsqueda de disponibilidad de vuelos@param credentials credenciales de autenticación@param airAvailRateNotesRQ objeto con los criterios para recuperar las notas de tarifa@return
     * objeto con las notas de tarifa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirAvailGetRateNotes $parameters
     * @return \StructType\AirAvailGetRateNotesResponse|bool
     */
    public function AirAvailGetRateNotes(\StructType\AirAvailGetRateNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirAvailGetRateNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirAvailGetFareFamilies
     * Meta information extracted from the WSDL
     * - documentation: Devuelve un listado de la FareFamilies asociadas a la Tarifa Base de la combinación pasada por parámetro@param credentials credenciales de autenticación@param airAvailFareFamiliesRQ objeto con los criterios para recuperar las
     * fareFamilies de una combinación@return objeto con las notas de tarifa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirAvailGetFareFamilies $parameters
     * @return \StructType\AirAvailGetFareFamiliesResponse|bool
     */
    public function AirAvailGetFareFamilies(\StructType\AirAvailGetFareFamilies $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirAvailGetFareFamilies($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingCreate
     * Meta information extracted from the WSDL
     * - documentation: Crea una reserva con los datos indicados.@param credentials credenciales de autenticación@param airBookingRQ objeto con los datos de la reserva@return objeto AirBookingRS con los datos completos de la reserva creada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingCreate $parameters
     * @return \StructType\AirBookingCreateResponse|bool
     */
    public function AirBookingCreate(\StructType\AirBookingCreate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingCreate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingEdit
     * Meta information extracted from the WSDL
     * - documentation: Devuelve los datos de una reserva@param credentials credenciales de autenticación@param bookingID identificador único de la reserva@return objeto con los datos de la reserva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingEdit $parameters
     * @return \StructType\AirBookingEditResponse|bool
     */
    public function AirBookingEdit(\StructType\AirBookingEdit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingEdit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingCancel
     * Meta information extracted from the WSDL
     * - documentation: Cancela una reserva@param credentials credenciales de autenticación@param bookingID identificador único de la reserva@return objeto del tipo AirBookingRS con los datos de la reserva actualizados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingCancel $parameters
     * @return \StructType\AirBookingCancelResponse|bool
     */
    public function AirBookingCancel(\StructType\AirBookingCancel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingCancel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingMarkToTicketing
     * Meta information extracted from the WSDL
     * - documentation: Marca para emisión la reserva indicada@param credentials credenciales de autenticación@param airBookingMarkToTicketingRQ objeto con los datos de entrada para la emisión@return objeto del tipo AirBookingRS con los datos de la
     * reserva actualizados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingMarkToTicketing $parameters
     * @return \StructType\AirBookingMarkToTicketingResponse|bool
     */
    public function AirBookingMarkToTicketing(\StructType\AirBookingMarkToTicketing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingMarkToTicketing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingTicketing
     * Meta information extracted from the WSDL
     * - documentation: Emite los billetes de la reserva indicada. MUY IMPORTANTE: ESTE METODO SOLO PERMITE LA EMISION DE LA RESERVA CONTRA SALDO PREPAGADO DE LA AGENCIA (Requiere Activación). Ya no se pemite la emisión con tarjeta autorizada cargada en
     * el sistema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingTicketing $parameters
     * @return \StructType\AirBookingTicketingResponse|bool
     */
    public function AirBookingTicketing(\StructType\AirBookingTicketing $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingTicketing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingCancelTickets
     * Meta information extracted from the WSDL
     * - documentation: Cancela los billetes de una reserva@param credentials credenciales de autenticación@param bookingID identificador único de la reserva@return objeto del tipo AirBookingRS con los datos de la reserva actualizada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingCancelTickets $parameters
     * @return \StructType\AirBookingCancelTicketsResponse|bool
     */
    public function AirBookingCancelTickets(\StructType\AirBookingCancelTickets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingCancelTickets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingSearch
     * Meta information extracted from the WSDL
     * - documentation: Busca las reservas por varios criterios@param credentials credenciales de autenticación@param airBookingSearchRQ objeto con los criterios de búsqueda@return objeto con el resultado de la búsqueda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingSearch $parameters
     * @return \StructType\AirBookingSearchResponse|bool
     */
    public function AirBookingSearch(\StructType\AirBookingSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingGetPaxFares
     * Meta information extracted from the WSDL
     * - documentation: Devuelve un objeto AirBookingPaxFaresRS con las tarifas disponibles y equipaje permitido, para un pasajero de la reserva@param credentials credenciales de autenticación@param bookingID identificador único de la reserva@param
     * travelerID identificador único del pasajero@return objeto con los datos de la reserva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingGetPaxFares $parameters
     * @return \StructType\AirBookingGetPaxFaresResponse|bool
     */
    public function AirBookingGetPaxFares(\StructType\AirBookingGetPaxFares $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingGetPaxFares($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingChangePaxFares
     * Meta information extracted from the WSDL
     * - documentation: Cambia la tarifa a un pasajero, y devuelve un objeto AirBookingRS con los datos de la reserva@param credentials credenciales de autenticación@param bookingID identificador único de la reserva@param travelerID identificador único
     * del pasajero@param selectedPaxFare datos de la tarifa seleccionada a establecer@return objeto con los datos de la reserva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingChangePaxFares $parameters
     * @return \StructType\AirBookingChangePaxFaresResponse|bool
     */
    public function AirBookingChangePaxFares(\StructType\AirBookingChangePaxFares $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingChangePaxFares($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingGetRateNotes
     * Meta information extracted from the WSDL
     * - documentation: Recupera las notas de tarifa de la reserva indicada@param credentials credenciales de autenticación@param bookingID identificador único de la reserva@return objeto con las notas de tarifa de la reserva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingGetRateNotes $parameters
     * @return \StructType\AirBookingGetRateNotesResponse|bool
     */
    public function AirBookingGetRateNotes(\StructType\AirBookingGetRateNotes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingGetRateNotes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingUpdateTravelerTSAData
     * Meta information extracted from the WSDL
     * - documentation: Actualiza los datos TSA de una pasajero de una reserva@param credentials credenciales de autenticación@param airBookingUpdateTsaTravelerRQ objeto con los nuevos datos del pasajero@return objeto con el resultado de la actualización
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingUpdateTravelerTSAData $parameters
     * @return \StructType\AirBookingUpdateTravelerTSADataResponse|bool
     */
    public function AirBookingUpdateTravelerTSAData(\StructType\AirBookingUpdateTravelerTSAData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingUpdateTravelerTSAData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingImport
     * Meta information extracted from the WSDL
     * - documentation: Recupera la reserva del localizador indicado y la introduce en el sistema@param credentials credenciales de autenticación@param airBookingImportRQ objeto con los datos necesarios para importar la reserva@return &gt;objeto con los
     * datos de la reserva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingImport $parameters
     * @return \StructType\AirBookingImportResponse|bool
     */
    public function AirBookingImport(\StructType\AirBookingImport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingImport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AirBookingCheckFeeCreditCardLowCost
     * Meta information extracted from the WSDL
     * - documentation: Pre chequea una reserva LowCost@param credentials credenciales de autenticación@param airBookingRQ objeto con los datos de la reserva@return objeto del tipo AirBookingRS con los datos completos de la reserva creada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingCheckFeeCreditCardLowCost $parameters
     * @return \StructType\AirBookingCheckFeeCreditCardLowCostResponse|bool
     */
    public function AirBookingCheckFeeCreditCardLowCost(\StructType\AirBookingCheckFeeCreditCardLowCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingCheckFeeCreditCardLowCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingPreCheckLowCostTf
     * Meta information extracted from the WSDL
     * - documentation: PreChequea ReservaTravelFusion LowCost@param credentials credenciales de autenticación@param airBookingTfLowCostRQ objeto con los datos de la reserva para prechequear una reserva TravelFusion LowCost@return objeto del tipo
     * AirBookingLowCostPreCheck con los datos recuperados luego del chequeo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingPreCheckLowCostTf $parameters
     * @return \StructType\AirBookingPreCheckLowCostTfResponse|bool
     */
    public function AirBookingPreCheckLowCostTf(\StructType\AirBookingPreCheckLowCostTf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingPreCheckLowCostTf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingCheckFeeLowCostTf
     * Meta information extracted from the WSDL
     * - documentation: Chequea el Fee de la Tarjeta de Crédito de una LowCost TravelFusion@param credentials credenciales de autenticación@param airBookingRQ objeto con los datos de la reserva@return objeto del tipo AirBookingRS con los datos completos
     * de la reserva luego de chequear el FEE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingCheckFeeLowCostTf $parameters
     * @return \StructType\AirBookingCheckFeeLowCostTfResponse|bool
     */
    public function AirBookingCheckFeeLowCostTf(\StructType\AirBookingCheckFeeLowCostTf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingCheckFeeLowCostTf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingTicketingLowCostTf
     * Meta information extracted from the WSDL
     * - documentation: Método de creación de una LowCost TravelFusion@param credentials credenciales de autenticación@param airBookingTicketingRQ objeto con los datos de la reserva@return objeto del tipo AirBookingRS con los datos completos de la
     * reserva luego de chequear el FEE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingTicketingLowCostTf $parameters
     * @return \StructType\AirBookingTicketingLowCostTfResponse|bool
     */
    public function AirBookingTicketingLowCostTf(\StructType\AirBookingTicketingLowCostTf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingTicketingLowCostTf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingPreCheckNDC
     * Meta information extracted from the WSDL
     * - documentation: Realiza el Prechequeo de una oferta NDC. Chequea que no ha habido variacion de precios y recupera servicios de equipaje disponibles para la oferta.@param credentials credenciales de autenticación@param abPrecheckRQ objeto con los
     * datos de la reserva@return objeto AirBookingRS con los datos completos de la reserva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingPreCheckNDC $parameters
     * @return \StructType\AirBookingPreCheckNDCResponse|bool
     */
    public function AirBookingPreCheckNDC(\StructType\AirBookingPreCheckNDC $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingPreCheckNDC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirBookingTicketingLowCost
     * Meta information extracted from the WSDL
     * - documentation: [OBSOLETO] Este metodo emitia una reserva lowcost realizada a través de amadeus. Actualmente solo está disponible la emision de lowcost a traves de travelfusion@param credentials credenciales de autenticación@param airBookingRQ
     * objeto con los datos de la reserva@return objeto AirBookingRS con los datos completos de la reserva creada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirBookingTicketingLowCost $parameters
     * @return \StructType\AirBookingTicketingLowCostResponse|bool
     */
    public function AirBookingTicketingLowCost(\StructType\AirBookingTicketingLowCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirBookingTicketingLowCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AirAvailLowCostBaggagePrice
     * Meta information extracted from the WSDL
     * - documentation: [OBSOLETO] IMPORTANTE: Este metodo ya no está disponible debido a que devuelve el quipaje permitido para reservas LowCost - Amadeus. Recupera la lista de equipajes y sus precios para el itinerario enviado y un solo pasajero@param
     * credentials credenciales de autenticación@param airAvailLowCostBaggagePriceRQ Objeto con los parametros para completar la petición
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AirAvailLowCostBaggagePrice $parameters
     * @return \StructType\AirAvailLowCostBaggagePriceResponse|bool
     */
    public function AirAvailLowCostBaggagePrice(\StructType\AirAvailLowCostBaggagePrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AirAvailLowCostBaggagePrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AirAvailCalendarSearchResponse|\StructType\AirAvailGetFareFamiliesResponse|\StructType\AirAvailGetRateNotesResponse|\StructType\AirAvailLowCostBaggagePriceResponse|\StructType\AirAvailMultiSegmentSearchResponse|\StructType\AirAvailSearchResponse|\StructType\AirBookingCancelResponse|\StructType\AirBookingCancelTicketsResponse|\StructType\AirBookingChangePaxFaresResponse|\StructType\AirBookingCheckFeeCreditCardLowCostResponse|\StructType\AirBookingCheckFeeLowCostTfResponse|\StructType\AirBookingCreateResponse|\StructType\AirBookingEditResponse|\StructType\AirBookingGetPaxFaresResponse|\StructType\AirBookingGetRateNotesResponse|\StructType\AirBookingImportResponse|\StructType\AirBookingMarkToTicketingResponse|\StructType\AirBookingPreCheckLowCostTfResponse|\StructType\AirBookingPreCheckNDCResponse|\StructType\AirBookingSearchResponse|\StructType\AirBookingTicketingLowCostResponse|\StructType\AirBookingTicketingLowCostTfResponse|\StructType\AirBookingTicketingResponse|\StructType\AirBookingUpdateTravelerTSADataResponse|\StructType\AirDestinationAirportsListResponse|\StructType\AirMunicipalCodeListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
