<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTechnicalStop StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una parada técnica para un vuelo
 * - nillable: true
 * - type: tns:AirTechnicalStop
 * @subpackage Structs
 */
class AirTechnicalStop extends AbstractStructBase
{
    /**
     * The AirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo IATA del aeropuerto donde se efectua la parada
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirportLocationCode;
    /**
     * The StartDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y Hora de inicio de la parada (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y Hora de fin de la parada (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateTime;
    /**
     * Constructor method for AirTechnicalStop
     * @uses AirTechnicalStop::setAirportLocationCode()
     * @uses AirTechnicalStop::setStartDateTime()
     * @uses AirTechnicalStop::setEndDateTime()
     * @param string $airportLocationCode
     * @param string $startDateTime
     * @param string $endDateTime
     */
    public function __construct($airportLocationCode = null, $startDateTime = null, $endDateTime = null)
    {
        $this
            ->setAirportLocationCode($airportLocationCode)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime);
    }
    /**
     * Get AirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirportLocationCode()
    {
        return isset($this->AirportLocationCode) ? $this->AirportLocationCode : null;
    }
    /**
     * Set AirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airportLocationCode
     * @return \StructType\AirTechnicalStop
     */
    public function setAirportLocationCode($airportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($airportLocationCode) && !is_string($airportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airportLocationCode, true), gettype($airportLocationCode)), __LINE__);
        }
        if (is_null($airportLocationCode) || (is_array($airportLocationCode) && empty($airportLocationCode))) {
            unset($this->AirportLocationCode);
        } else {
            $this->AirportLocationCode = $airportLocationCode;
        }
        return $this;
    }
    /**
     * Get StartDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateTime()
    {
        return isset($this->StartDateTime) ? $this->StartDateTime : null;
    }
    /**
     * Set StartDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateTime
     * @return \StructType\AirTechnicalStop
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        if (is_null($startDateTime) || (is_array($startDateTime) && empty($startDateTime))) {
            unset($this->StartDateTime);
        } else {
            $this->StartDateTime = $startDateTime;
        }
        return $this;
    }
    /**
     * Get EndDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateTime()
    {
        return isset($this->EndDateTime) ? $this->EndDateTime : null;
    }
    /**
     * Set EndDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateTime
     * @return \StructType\AirTechnicalStop
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        if (is_null($endDateTime) || (is_array($endDateTime) && empty($endDateTime))) {
            unset($this->EndDateTime);
        } else {
            $this->EndDateTime = $endDateTime;
        }
        return $this;
    }
}
