<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFlightTicket StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un billete aereo
 * - nillable: true
 * - type: tns:AirFlightTicket
 * @subpackage Structs
 */
class AirFlightTicket extends AbstractStructBase
{
    /**
     * The TicketID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del billete
     * - minOccurs: 0
     * @var int
     */
    public $TicketID;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de billete
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketNumber;
    /**
     * The TravelerID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del pasajero titular del billete
     * - minOccurs: 0
     * @var int
     */
    public $TravelerID;
    /**
     * The SegmentID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del segmento de vuelo referenciado por el billete
     * - minOccurs: 0
     * @var int
     */
    public $SegmentID;
    /**
     * Constructor method for AirFlightTicket
     * @uses AirFlightTicket::setTicketID()
     * @uses AirFlightTicket::setTicketNumber()
     * @uses AirFlightTicket::setTravelerID()
     * @uses AirFlightTicket::setSegmentID()
     * @param int $ticketID
     * @param string $ticketNumber
     * @param int $travelerID
     * @param int $segmentID
     */
    public function __construct($ticketID = null, $ticketNumber = null, $travelerID = null, $segmentID = null)
    {
        $this
            ->setTicketID($ticketID)
            ->setTicketNumber($ticketNumber)
            ->setTravelerID($travelerID)
            ->setSegmentID($segmentID);
    }
    /**
     * Get TicketID value
     * @return int|null
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \StructType\AirFlightTicket
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !(is_int($ticketID) || ctype_digit($ticketID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketID, true), gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketNumber
     * @return \StructType\AirFlightTicket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TravelerID value
     * @return int|null
     */
    public function getTravelerID()
    {
        return $this->TravelerID;
    }
    /**
     * Set TravelerID value
     * @param int $travelerID
     * @return \StructType\AirFlightTicket
     */
    public function setTravelerID($travelerID = null)
    {
        // validation for constraint: int
        if (!is_null($travelerID) && !(is_int($travelerID) || ctype_digit($travelerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerID, true), gettype($travelerID)), __LINE__);
        }
        $this->TravelerID = $travelerID;
        return $this;
    }
    /**
     * Get SegmentID value
     * @return int|null
     */
    public function getSegmentID()
    {
        return $this->SegmentID;
    }
    /**
     * Set SegmentID value
     * @param int $segmentID
     * @return \StructType\AirFlightTicket
     */
    public function setSegmentID($segmentID = null)
    {
        // validation for constraint: int
        if (!is_null($segmentID) && !(is_int($segmentID) || ctype_digit($segmentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($segmentID, true), gettype($segmentID)), __LINE__);
        }
        $this->SegmentID = $segmentID;
        return $this;
    }
}
