<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingTicketingRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada para Emitir los billetes. Solo para forma de pago UYU
 * - nillable: true
 * - type: tns:AirBookingTicketingRQ
 * @subpackage Structs
 */
class AirBookingTicketingRQ extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de la reserva en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la tarjeta autorizada. (OBSOLETO: No se permite la emisión contra tarjeta autorizada)
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CardID;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del Seguro de cancelacion
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The AmountDifference
     * Meta information extracted from the WSDL
     * - documentation: Diferencial permitido para poder marcar la reserva en caso de que el importe de la misma sea superior
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifference;
    /**
     * The LowCostPreReserveID
     * Meta information extracted from the WSDL
     * - documentation: El RequestID de la petición obtenido en el método AirBookingCheckFeeLowCostTf
     * - minOccurs: 0
     * @var int
     */
    public $LowCostPreReserveID;
    /**
     * Constructor method for AirBookingTicketingRQ
     * @uses AirBookingTicketingRQ::setBookingID()
     * @uses AirBookingTicketingRQ::setCardID()
     * @uses AirBookingTicketingRQ::setInsuranceAmount()
     * @uses AirBookingTicketingRQ::setAmountDifference()
     * @uses AirBookingTicketingRQ::setLowCostPreReserveID()
     * @param int $bookingID
     * @param int $cardID
     * @param float $insuranceAmount
     * @param float $amountDifference
     * @param int $lowCostPreReserveID
     */
    public function __construct($bookingID = null, $cardID = null, $insuranceAmount = null, $amountDifference = null, $lowCostPreReserveID = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setCardID($cardID)
            ->setInsuranceAmount($insuranceAmount)
            ->setAmountDifference($amountDifference)
            ->setLowCostPreReserveID($lowCostPreReserveID);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingTicketingRQ
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get CardID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCardID()
    {
        return isset($this->CardID) ? $this->CardID : null;
    }
    /**
     * Set CardID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cardID
     * @return \StructType\AirBookingTicketingRQ
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        if (is_null($cardID) || (is_array($cardID) && empty($cardID))) {
            unset($this->CardID);
        } else {
            $this->CardID = $cardID;
        }
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float|null
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \StructType\AirBookingTicketingRQ
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get AmountDifference value
     * @return float|null
     */
    public function getAmountDifference()
    {
        return $this->AmountDifference;
    }
    /**
     * Set AmountDifference value
     * @param float $amountDifference
     * @return \StructType\AirBookingTicketingRQ
     */
    public function setAmountDifference($amountDifference = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifference) && !(is_float($amountDifference) || is_numeric($amountDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifference, true), gettype($amountDifference)), __LINE__);
        }
        $this->AmountDifference = $amountDifference;
        return $this;
    }
    /**
     * Get LowCostPreReserveID value
     * @return int|null
     */
    public function getLowCostPreReserveID()
    {
        return $this->LowCostPreReserveID;
    }
    /**
     * Set LowCostPreReserveID value
     * @param int $lowCostPreReserveID
     * @return \StructType\AirBookingTicketingRQ
     */
    public function setLowCostPreReserveID($lowCostPreReserveID = null)
    {
        // validation for constraint: int
        if (!is_null($lowCostPreReserveID) && !(is_int($lowCostPreReserveID) || ctype_digit($lowCostPreReserveID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lowCostPreReserveID, true), gettype($lowCostPreReserveID)), __LINE__);
        }
        $this->LowCostPreReserveID = $lowCostPreReserveID;
        return $this;
    }
}
