<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingSearch StructType
 * @subpackage Structs
 */
class AirBookingSearch extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The airBookingSearchRQ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingSearchRQ
     */
    public $airBookingSearchRQ;
    /**
     * Constructor method for AirBookingSearch
     * @uses AirBookingSearch::setCredentials()
     * @uses AirBookingSearch::setAirBookingSearchRQ()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param \StructType\AirBookingSearchRQ $airBookingSearchRQ
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, \StructType\AirBookingSearchRQ $airBookingSearchRQ = null)
    {
        $this
            ->setCredentials($credentials)
            ->setAirBookingSearchRQ($airBookingSearchRQ);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingSearch
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get airBookingSearchRQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingSearchRQ|null
     */
    public function getAirBookingSearchRQ()
    {
        return isset($this->airBookingSearchRQ) ? $this->airBookingSearchRQ : null;
    }
    /**
     * Set airBookingSearchRQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingSearchRQ $airBookingSearchRQ
     * @return \StructType\AirBookingSearch
     */
    public function setAirBookingSearchRQ(\StructType\AirBookingSearchRQ $airBookingSearchRQ = null)
    {
        if (is_null($airBookingSearchRQ) || (is_array($airBookingSearchRQ) && empty($airBookingSearchRQ))) {
            unset($this->airBookingSearchRQ);
        } else {
            $this->airBookingSearchRQ = $airBookingSearchRQ;
        }
        return $this;
    }
}
