<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingPreCheckTfLowCostRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que contiene información de maletas, parámetros obligatorios dependiendo de aerolinea...
 * - nillable: true
 * - type: tns:AirBookingPreCheckTfLowCostRS
 * @subpackage Structs
 */
class AirBookingPreCheckTfLowCostRS extends AbstractStructBase
{
    /**
     * The LuggageRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al método invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $LuggageRequestID;
    /**
     * The ListAirBookingBaggage
     * Meta information extracted from the WSDL
     * - documentation: Listado de tipo de equipaje disponible para la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingBaggageLowCostTf
     */
    public $ListAirBookingBaggage;
    /**
     * The IsChangePriceAvailabilityTravelFusion
     * Meta information extracted from the WSDL
     * - documentation: Indica si hay cambio de precios con respecto a la disponibilidad para una LowCost
     * - minOccurs: 0
     * @var bool
     */
    public $IsChangePriceAvailabilityTravelFusion;
    /**
     * The AirPricingChange
     * Meta information extracted from the WSDL
     * - documentation: Actualización de los Precios Moneda para el caso de TravelFusion y en caso de que existan discrepancias respecto a la disponibilidad
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirPricingGroup
     */
    public $AirPricingChange;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de realizar la búsqueda
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirBookingPreCheckTfLowCostRS
     * @uses AirBookingPreCheckTfLowCostRS::setLuggageRequestID()
     * @uses AirBookingPreCheckTfLowCostRS::setListAirBookingBaggage()
     * @uses AirBookingPreCheckTfLowCostRS::setIsChangePriceAvailabilityTravelFusion()
     * @uses AirBookingPreCheckTfLowCostRS::setAirPricingChange()
     * @uses AirBookingPreCheckTfLowCostRS::setError()
     * @param int $luggageRequestID
     * @param \ArrayType\ArrayOfAirBookingBaggageLowCostTf $listAirBookingBaggage
     * @param bool $isChangePriceAvailabilityTravelFusion
     * @param \StructType\AirPricingGroup $airPricingChange
     * @param \StructType\ResponseError $error
     */
    public function __construct($luggageRequestID = null, \ArrayType\ArrayOfAirBookingBaggageLowCostTf $listAirBookingBaggage = null, $isChangePriceAvailabilityTravelFusion = null, \StructType\AirPricingGroup $airPricingChange = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setLuggageRequestID($luggageRequestID)
            ->setListAirBookingBaggage($listAirBookingBaggage)
            ->setIsChangePriceAvailabilityTravelFusion($isChangePriceAvailabilityTravelFusion)
            ->setAirPricingChange($airPricingChange)
            ->setError($error);
    }
    /**
     * Get LuggageRequestID value
     * @return int|null
     */
    public function getLuggageRequestID()
    {
        return $this->LuggageRequestID;
    }
    /**
     * Set LuggageRequestID value
     * @param int $luggageRequestID
     * @return \StructType\AirBookingPreCheckTfLowCostRS
     */
    public function setLuggageRequestID($luggageRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($luggageRequestID) && !(is_int($luggageRequestID) || ctype_digit($luggageRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($luggageRequestID, true), gettype($luggageRequestID)), __LINE__);
        }
        $this->LuggageRequestID = $luggageRequestID;
        return $this;
    }
    /**
     * Get ListAirBookingBaggage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingBaggageLowCostTf|null
     */
    public function getListAirBookingBaggage()
    {
        return isset($this->ListAirBookingBaggage) ? $this->ListAirBookingBaggage : null;
    }
    /**
     * Set ListAirBookingBaggage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingBaggageLowCostTf $listAirBookingBaggage
     * @return \StructType\AirBookingPreCheckTfLowCostRS
     */
    public function setListAirBookingBaggage(\ArrayType\ArrayOfAirBookingBaggageLowCostTf $listAirBookingBaggage = null)
    {
        if (is_null($listAirBookingBaggage) || (is_array($listAirBookingBaggage) && empty($listAirBookingBaggage))) {
            unset($this->ListAirBookingBaggage);
        } else {
            $this->ListAirBookingBaggage = $listAirBookingBaggage;
        }
        return $this;
    }
    /**
     * Get IsChangePriceAvailabilityTravelFusion value
     * @return bool|null
     */
    public function getIsChangePriceAvailabilityTravelFusion()
    {
        return $this->IsChangePriceAvailabilityTravelFusion;
    }
    /**
     * Set IsChangePriceAvailabilityTravelFusion value
     * @param bool $isChangePriceAvailabilityTravelFusion
     * @return \StructType\AirBookingPreCheckTfLowCostRS
     */
    public function setIsChangePriceAvailabilityTravelFusion($isChangePriceAvailabilityTravelFusion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isChangePriceAvailabilityTravelFusion) && !is_bool($isChangePriceAvailabilityTravelFusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isChangePriceAvailabilityTravelFusion, true), gettype($isChangePriceAvailabilityTravelFusion)), __LINE__);
        }
        $this->IsChangePriceAvailabilityTravelFusion = $isChangePriceAvailabilityTravelFusion;
        return $this;
    }
    /**
     * Get AirPricingChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirPricingGroup|null
     */
    public function getAirPricingChange()
    {
        return isset($this->AirPricingChange) ? $this->AirPricingChange : null;
    }
    /**
     * Set AirPricingChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirPricingGroup $airPricingChange
     * @return \StructType\AirBookingPreCheckTfLowCostRS
     */
    public function setAirPricingChange(\StructType\AirPricingGroup $airPricingChange = null)
    {
        if (is_null($airPricingChange) || (is_array($airPricingChange) && empty($airPricingChange))) {
            unset($this->AirPricingChange);
        } else {
            $this->AirPricingChange = $airPricingChange;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingPreCheckTfLowCostRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
