<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingMarkToTicketingRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada para Marcar la Reservas para Emitir
 * - nillable: true
 * - type: tns:AirBookingMarkToTicketingRQ
 * @subpackage Structs
 */
class AirBookingMarkToTicketingRQ extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de la reserva en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - documentation: Forma de pago
     * - minOccurs: 0
     * @var string
     */
    public $PaymentForm;
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la tarjeta autorizada
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CardID;
    /**
     * The InsuranceAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del Seguro de cancelacion
     * - minOccurs: 0
     * @var float
     */
    public $InsuranceAmount;
    /**
     * The Observations
     * Meta information extracted from the WSDL
     * - documentation: Observaciones
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observations;
    /**
     * The AmountDifference
     * Meta information extracted from the WSDL
     * - documentation: Diferencial permitido para poder marcar la reserva en caso de que el importe de la misma sea superior
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifference;
    /**
     * Constructor method for AirBookingMarkToTicketingRQ
     * @uses AirBookingMarkToTicketingRQ::setBookingID()
     * @uses AirBookingMarkToTicketingRQ::setPaymentForm()
     * @uses AirBookingMarkToTicketingRQ::setCardID()
     * @uses AirBookingMarkToTicketingRQ::setInsuranceAmount()
     * @uses AirBookingMarkToTicketingRQ::setObservations()
     * @uses AirBookingMarkToTicketingRQ::setAmountDifference()
     * @param int $bookingID
     * @param string $paymentForm
     * @param int $cardID
     * @param float $insuranceAmount
     * @param string $observations
     * @param float $amountDifference
     */
    public function __construct($bookingID = null, $paymentForm = null, $cardID = null, $insuranceAmount = null, $observations = null, $amountDifference = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setPaymentForm($paymentForm)
            ->setCardID($cardID)
            ->setInsuranceAmount($insuranceAmount)
            ->setObservations($observations)
            ->setAmountDifference($amountDifference);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingMarkToTicketingRQ
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return string|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @uses \EnumType\AirPaymentForms::valueIsValid()
     * @uses \EnumType\AirPaymentForms::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentForm
     * @return \StructType\AirBookingMarkToTicketingRQ
     */
    public function setPaymentForm($paymentForm = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirPaymentForms::valueIsValid($paymentForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirPaymentForms', is_array($paymentForm) ? implode(', ', $paymentForm) : var_export($paymentForm, true), implode(', ', \EnumType\AirPaymentForms::getValidValues())), __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Get CardID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCardID()
    {
        return isset($this->CardID) ? $this->CardID : null;
    }
    /**
     * Set CardID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cardID
     * @return \StructType\AirBookingMarkToTicketingRQ
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        if (is_null($cardID) || (is_array($cardID) && empty($cardID))) {
            unset($this->CardID);
        } else {
            $this->CardID = $cardID;
        }
        return $this;
    }
    /**
     * Get InsuranceAmount value
     * @return float|null
     */
    public function getInsuranceAmount()
    {
        return $this->InsuranceAmount;
    }
    /**
     * Set InsuranceAmount value
     * @param float $insuranceAmount
     * @return \StructType\AirBookingMarkToTicketingRQ
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        $this->InsuranceAmount = $insuranceAmount;
        return $this;
    }
    /**
     * Get Observations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservations()
    {
        return isset($this->Observations) ? $this->Observations : null;
    }
    /**
     * Set Observations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observations
     * @return \StructType\AirBookingMarkToTicketingRQ
     */
    public function setObservations($observations = null)
    {
        // validation for constraint: string
        if (!is_null($observations) && !is_string($observations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observations, true), gettype($observations)), __LINE__);
        }
        if (is_null($observations) || (is_array($observations) && empty($observations))) {
            unset($this->Observations);
        } else {
            $this->Observations = $observations;
        }
        return $this;
    }
    /**
     * Get AmountDifference value
     * @return float|null
     */
    public function getAmountDifference()
    {
        return $this->AmountDifference;
    }
    /**
     * Set AmountDifference value
     * @param float $amountDifference
     * @return \StructType\AirBookingMarkToTicketingRQ
     */
    public function setAmountDifference($amountDifference = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifference) && !(is_float($amountDifference) || is_numeric($amountDifference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifference, true), gettype($amountDifference)), __LINE__);
        }
        $this->AmountDifference = $amountDifference;
        return $this;
    }
}
