<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingBaggageLowCostTf StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto auxiliar para contener los equipajes - DTO con la forma del equipaje de Travelfusion
 * - nillable: true
 * - type: tns:AirBookingBaggageLowCostTf
 * @subpackage Structs
 */
class AirBookingBaggageLowCostTf extends AbstractStructBase
{
    /**
     * The NumberOption
     * Meta information extracted from the WSDL
     * - documentation: El número de opcion que selecciona el usuario
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberOption;
    /**
     * The ByPax
     * Meta information extracted from the WSDL
     * - documentation: Indica si se puede contratar por cada pasajero o para la reserva
     * - minOccurs: 0
     * @var bool
     */
    public $ByPax;
    /**
     * The LuggageOption
     * Meta information extracted from the WSDL
     * - documentation: Indica el tipo de opcion de equipaje que se ha seleccionado
     * - minOccurs: 0
     * @var string
     */
    public $LuggageOption;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: Precio del equipaje
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Peso y numero de piezas de la opcion seleccionada
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The OriginalCurrencyPrice
     * Meta information extracted from the WSDL
     * - documentation: Precio del equipaje en la divisa en que viene informada
     * - minOccurs: 0
     * @var float
     */
    public $OriginalCurrencyPrice;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Código de moneda de 3 dígitos
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for AirBookingBaggageLowCostTf
     * @uses AirBookingBaggageLowCostTf::setNumberOption()
     * @uses AirBookingBaggageLowCostTf::setByPax()
     * @uses AirBookingBaggageLowCostTf::setLuggageOption()
     * @uses AirBookingBaggageLowCostTf::setPrice()
     * @uses AirBookingBaggageLowCostTf::setDescription()
     * @uses AirBookingBaggageLowCostTf::setOriginalCurrencyPrice()
     * @uses AirBookingBaggageLowCostTf::setCurrencyCode()
     * @param string $numberOption
     * @param bool $byPax
     * @param string $luggageOption
     * @param float $price
     * @param string $description
     * @param float $originalCurrencyPrice
     * @param string $currencyCode
     */
    public function __construct($numberOption = null, $byPax = null, $luggageOption = null, $price = null, $description = null, $originalCurrencyPrice = null, $currencyCode = null)
    {
        $this
            ->setNumberOption($numberOption)
            ->setByPax($byPax)
            ->setLuggageOption($luggageOption)
            ->setPrice($price)
            ->setDescription($description)
            ->setOriginalCurrencyPrice($originalCurrencyPrice)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get NumberOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberOption()
    {
        return isset($this->NumberOption) ? $this->NumberOption : null;
    }
    /**
     * Set NumberOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberOption
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setNumberOption($numberOption = null)
    {
        // validation for constraint: string
        if (!is_null($numberOption) && !is_string($numberOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberOption, true), gettype($numberOption)), __LINE__);
        }
        if (is_null($numberOption) || (is_array($numberOption) && empty($numberOption))) {
            unset($this->NumberOption);
        } else {
            $this->NumberOption = $numberOption;
        }
        return $this;
    }
    /**
     * Get ByPax value
     * @return bool|null
     */
    public function getByPax()
    {
        return $this->ByPax;
    }
    /**
     * Set ByPax value
     * @param bool $byPax
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setByPax($byPax = null)
    {
        // validation for constraint: boolean
        if (!is_null($byPax) && !is_bool($byPax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($byPax, true), gettype($byPax)), __LINE__);
        }
        $this->ByPax = $byPax;
        return $this;
    }
    /**
     * Get LuggageOption value
     * @return string|null
     */
    public function getLuggageOption()
    {
        return $this->LuggageOption;
    }
    /**
     * Set LuggageOption value
     * @uses \EnumType\Enumeraciones_TravelfusionOpcionEquipaje::valueIsValid()
     * @uses \EnumType\Enumeraciones_TravelfusionOpcionEquipaje::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $luggageOption
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setLuggageOption($luggageOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumeraciones_TravelfusionOpcionEquipaje::valueIsValid($luggageOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumeraciones_TravelfusionOpcionEquipaje', is_array($luggageOption) ? implode(', ', $luggageOption) : var_export($luggageOption, true), implode(', ', \EnumType\Enumeraciones_TravelfusionOpcionEquipaje::getValidValues())), __LINE__);
        }
        $this->LuggageOption = $luggageOption;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get OriginalCurrencyPrice value
     * @return float|null
     */
    public function getOriginalCurrencyPrice()
    {
        return $this->OriginalCurrencyPrice;
    }
    /**
     * Set OriginalCurrencyPrice value
     * @param float $originalCurrencyPrice
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setOriginalCurrencyPrice($originalCurrencyPrice = null)
    {
        // validation for constraint: float
        if (!is_null($originalCurrencyPrice) && !(is_float($originalCurrencyPrice) || is_numeric($originalCurrencyPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalCurrencyPrice, true), gettype($originalCurrencyPrice)), __LINE__);
        }
        $this->OriginalCurrencyPrice = $originalCurrencyPrice;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\AirBookingBaggageLowCostTf
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
}
