<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAirlineCarrier StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una compañia aérea dada de alta en el sistema Servivuelo
 * - nillable: true
 * - type: tns:AirAirlineCarrier
 * @subpackage Structs
 */
class AirAirlineCarrier extends AbstractStructBase
{
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Código de la aerolinea
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Nombre completo de la aerolinea
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Alias
     * Meta information extracted from the WSDL
     * - documentation: Alias de la aerolinea
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alias;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - documentation: Id de la aerolinea
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - documentation: Indica si está activa para la venta
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for AirAirlineCarrier
     * @uses AirAirlineCarrier::setCarrierCode()
     * @uses AirAirlineCarrier::setName()
     * @uses AirAirlineCarrier::setAlias()
     * @uses AirAirlineCarrier::setId()
     * @uses AirAirlineCarrier::setActive()
     * @param string $carrierCode
     * @param string $name
     * @param string $alias
     * @param int $id
     * @param bool $active
     */
    public function __construct($carrierCode = null, $name = null, $alias = null, $id = null, $active = null)
    {
        $this
            ->setCarrierCode($carrierCode)
            ->setName($name)
            ->setAlias($alias)
            ->setId($id)
            ->setActive($active);
    }
    /**
     * Get CarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierCode()
    {
        return isset($this->CarrierCode) ? $this->CarrierCode : null;
    }
    /**
     * Set CarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierCode
     * @return \StructType\AirAirlineCarrier
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        if (is_null($carrierCode) || (is_array($carrierCode) && empty($carrierCode))) {
            unset($this->CarrierCode);
        } else {
            $this->CarrierCode = $carrierCode;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AirAirlineCarrier
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Alias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlias()
    {
        return isset($this->Alias) ? $this->Alias : null;
    }
    /**
     * Set Alias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alias
     * @return \StructType\AirAirlineCarrier
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        if (is_null($alias) || (is_array($alias) && empty($alias))) {
            unset($this->Alias);
        } else {
            $this->Alias = $alias;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\AirAirlineCarrier
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\AirAirlineCarrier
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
