<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirAvailIncludeNDC EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeración para incluir NDC en las búsquedas
 * - nillable: true
 * - type: tns:AirAvailIncludeNDC
 * @subpackage Enumerations
 */
class AirAvailIncludeNDC extends AbstractStructEnumBase
{
    /**
     * Constant for value 'SinNDC'
     * Meta information extracted from the WSDL
     * - documentation: Se excluiran las ofertas de NDC para la busqueda realizada
     * @return string 'SinNDC'
     */
    const VALUE_SIN_NDC = 'SinNDC';
    /**
     * Constant for value 'SoloNDC'
     * Meta information extracted from the WSDL
     * - documentation: Solo se devolveran ofertas de NDC para la busqueda realizada
     * @return string 'SoloNDC'
     */
    const VALUE_SOLO_NDC = 'SoloNDC';
    /**
     * Constant for value 'ConNDC'
     * Meta information extracted from the WSDL
     * - documentation: Se incorporaran las ofertas de NDC para la busqueda realizada
     * @return string 'ConNDC'
     */
    const VALUE_CON_NDC = 'ConNDC';
    /**
     * Return allowed values
     * @uses self::VALUE_SIN_NDC
     * @uses self::VALUE_SOLO_NDC
     * @uses self::VALUE_CON_NDC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIN_NDC,
            self::VALUE_SOLO_NDC,
            self::VALUE_CON_NDC,
        );
    }
}
