<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirAvailClassPreferences EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeración con las preferencias de precios
 * - nillable: true
 * - type: tns:AirAvailClassPreferences
 * @subpackage Enumerations
 */
class AirAvailClassPreferences extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotSet'
     * Meta information extracted from the WSDL
     * - documentation: Sin preferencias
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'First'
     * Meta information extracted from the WSDL
     * - documentation: Primera Clase obligatoria para todos los vuelos
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'First60'
     * Meta information extracted from the WSDL
     * - documentation: Primera clase con al menos 60% de los vuelos en Primera Clase
     * @return string 'First60'
     */
    const VALUE_FIRST_60 = 'First60';
    /**
     * Constant for value 'Business'
     * Meta information extracted from the WSDL
     * - documentation: Business Class obligatoria para todos los vuelos
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'Business60'
     * Meta information extracted from the WSDL
     * - documentation: Business Class con al menos 60% de los vuelos en Businness Class
     * @return string 'Business60'
     */
    const VALUE_BUSINESS_60 = 'Business60';
    /**
     * Constant for value 'Tourist'
     * Meta information extracted from the WSDL
     * - documentation: Turista (Económica) obligatoria para todos los vuelos
     * @return string 'Tourist'
     */
    const VALUE_TOURIST = 'Tourist';
    /**
     * Constant for value 'Tourist60'
     * Meta information extracted from the WSDL
     * - documentation: Turista (Económica) con al menos 60% de los vuelos en Turista
     * @return string 'Tourist60'
     */
    const VALUE_TOURIST_60 = 'Tourist60';
    /**
     * Constant for value 'EconomyPremium'
     * Meta information extracted from the WSDL
     * - documentation: Economy Premium obligatoria para todos los vuelos
     * @return string 'EconomyPremium'
     */
    const VALUE_ECONOMY_PREMIUM = 'EconomyPremium';
    /**
     * Constant for value 'EconomyPremium60'
     * Meta information extracted from the WSDL
     * - documentation: Economy Premium con al menos 60% de los vuelos Economy Premium
     * @return string 'EconomyPremium60'
     */
    const VALUE_ECONOMY_PREMIUM_60 = 'EconomyPremium60';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_FIRST_60
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_BUSINESS_60
     * @uses self::VALUE_TOURIST
     * @uses self::VALUE_TOURIST_60
     * @uses self::VALUE_ECONOMY_PREMIUM
     * @uses self::VALUE_ECONOMY_PREMIUM_60
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_FIRST,
            self::VALUE_FIRST_60,
            self::VALUE_BUSINESS,
            self::VALUE_BUSINESS_60,
            self::VALUE_TOURIST,
            self::VALUE_TOURIST_60,
            self::VALUE_ECONOMY_PREMIUM,
            self::VALUE_ECONOMY_PREMIUM_60,
        );
    }
}
