<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warning StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una advertencia a tener en cuenta
 * - nillable: true
 * - type: tns:Warning
 * @subpackage Structs
 */
class Warning extends AbstractStructBase
{
    /**
     * The WarningCode
     * Meta information extracted from the WSDL
     * - documentation: Código del warning
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarningCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Descripción del warning
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Warning
     * @uses Warning::setWarningCode()
     * @uses Warning::setDescription()
     * @param string $warningCode
     * @param string $description
     */
    public function __construct($warningCode = null, $description = null)
    {
        $this
            ->setWarningCode($warningCode)
            ->setDescription($description);
    }
    /**
     * Get WarningCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarningCode()
    {
        return isset($this->WarningCode) ? $this->WarningCode : null;
    }
    /**
     * Set WarningCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warningCode
     * @return \StructType\Warning
     */
    public function setWarningCode($warningCode = null)
    {
        // validation for constraint: string
        if (!is_null($warningCode) && !is_string($warningCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningCode, true), gettype($warningCode)), __LINE__);
        }
        if (is_null($warningCode) || (is_array($warningCode) && empty($warningCode))) {
            unset($this->WarningCode);
        } else {
            $this->WarningCode = $warningCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Warning
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
